package org.eso.phase3.validator.catalog;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.phase3.validator.ValidationReport;
import org.eso.phase3.validator.ValidatorStat;
import org.eso.phase3.validator.ValidationReport.STATUS;
import org.eso.phase3.validator.ValidatorStat.StatType;

public class TCommNKwdValidator extends IndexedKeywordValidator {
	
	/** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(TCommNKwdValidator.class);
	
    public static final String kwIdentifier = "TCOMM";  
    
	public TCommNKwdValidator(int tFields, ValidationReport report, ValidatorStat stat, String fileName) {
		super(tFields, report, stat, fileName);
	}

	@Override
	public void process() {
		for (TypedHeaderCard card: cards) {
			if (card.getValue() == null || card.getValue().isEmpty()) {
				String msg = "[" + fileName + "] - Empty column description:" + card.getKey();
				logger.warn(msg);
				report.attemptStatus(STATUS.WARN, msg);
			}
		}
		
		if (cards.size() != totalFields) {
			String msg = "[" + fileName + "] - Number of TCOMM keywords does not match the total number of fields";
			logger.error(msg);
			report.attemptStatus(STATUS.ERROR, msg);
			stat.add(StatType.ERROR_CATALOG_VALIDATION);
		}
	}

}
