package org.eso.phase3.validator.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.phase3.validator.ValidationReport;
import org.eso.phase3.validator.ValidatorStat;
import org.eso.phase3.validator.ValidationReport.STATUS;
import org.eso.phase3.validator.ValidatorStat.StatType;

public class TFKeyNKwdValidator extends IndexedKeywordValidator {
	
	/** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(TFormNKwdValidator.class);
    
    public static final String kwIdentifier = "TFKEY";
    
    // TFKEYn must match one of this patterns
    private static List<Pattern> patterns = Arrays.asList(
    		Pattern.compile("DPKey"),
    		Pattern.compile("CatalogKey " + CatalogConsts.identifierRegExp + "\\." + CatalogConsts.identifierRegExp)
    		);
	
	public TFKeyNKwdValidator(int tFields, ValidationReport report, ValidatorStat stat, String fileName) {
		super(tFields, report, stat, fileName);
	}
	
	@Override
	public void process() {
		for (TypedHeaderCard card: cards) {
			String val = card.getValue();
			boolean patternMatch = false;
			for (Pattern p: patterns) {
				if (p.matcher(val).matches()) {
					patternMatch = true;
					break;
				}
			}

			if (!patternMatch) {
				String msg = "[" + fileName + "] - Foreign key column does not start with an allowed literal: " 
					+ val + " - keyword:" + card.getKey();
				logger.error(msg);
				report.attemptStatus(STATUS.ERROR, msg);
				stat.add(StatType.ERROR_CATALOG_VALIDATION);
			}
		}
	}

}
