package org.eso.phase3.validator.catalog;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.phase3.validator.Util;
import org.eso.phase3.validator.ValidationReport;
import org.eso.phase3.validator.ValidatorStat;
import org.eso.phase3.validator.ValidationReport.STATUS;
import org.eso.phase3.validator.ValidatorStat.StatType;

public class TFormNKwdValidator extends IndexedKeywordValidator {
	
	/** Apache Log4J logger for this class namespace. */
    private static final Logger logger = Logger.getLogger(TFormNKwdValidator.class);
	
    public static final String kwIdentifier = "TFORM";  
    
	public TFormNKwdValidator(int tFields, ValidationReport report,	ValidatorStat stat, String fileName) {
		super(tFields, report, stat, fileName);
	}
    
	@Override
	public void process() {
		for (TypedHeaderCard card: cards) {
			try {
				Util.extractTFormInformation(card);
			} catch (Exception e) {
				String msg = "[" + fileName + "] - " + e.getMessage();
				logger.error(msg);
				report.attemptStatus(STATUS.ERROR, msg);
				stat.add(StatType.ERROR_CATALOG_VALIDATION);
			}
		}
		
		if (cards.size() != totalFields) {
			String msg = "[" + fileName + "] - Number of TFORM keywords does not match the total number of fields";
			logger.error(msg);
			report.attemptStatus(STATUS.ERROR, msg);
			stat.add(StatType.ERROR_CATALOG_VALIDATION);
		}
	}
}
