#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QDate>
#include <QStandardItemModel>
#include <QTextEdit>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
    , model(this)
{
    ui->setupUi(this);

    for( int i = 0 ; i < 10; i ++){
        auto *string_item = new QStandardItem(QString("This is a QString"));
        this->model.setItem(i,0,string_item);

        auto *date_item = new QStandardItem();
        date_item->setData(QDate::currentDate(), Qt::DisplayRole);
        this->model.setItem(i,1,date_item );

        auto *datetime_item = new QStandardItem();
        datetime_item->setData(QDateTime::currentDateTime(), Qt::DisplayRole);
        this->model.setItem(i,2,datetime_item );

        auto *bool_item = new QStandardItem();
        bool_item->setData(true, Qt::DisplayRole);
        this->model.setItem(i,3,bool_item );

        auto *int_item = new QStandardItem();
        int_item->setData(42, Qt::DisplayRole);
        this->model.setItem(i,4,int_item );

        auto *double_item = new QStandardItem();
        double_item->setData(3.14, Qt::DisplayRole);
        this->model.setItem(i,5,double_item );

        auto *color_item = new QStandardItem();
        color_item->setData(QColor(255,255,0), Qt::DisplayRole);
        this->model.setItem(i,6,color_item );
    }

    this->ui->listView->setModel( &this->model );
    this->ui->tableView->setModel(&this->model);
    this->ui->treeView->setModel(&this->model);
    this->ui->columnView->setModel(&this->model);

}

MainWindow::~MainWindow()
{
    delete ui;
}

