#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QIcon>
#include <QStandardItemModel>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
    , model(this)
{
    ui->setupUi(this);

    QVector<QIcon> icon_vector = {QIcon::fromTheme("document-new"),
                                  QIcon::fromTheme("document-open"),
                                  QIcon::fromTheme("document-save"),
                                  QIcon::fromTheme("document-save-as"),
                                  QIcon::fromTheme("document-close"),
                                  QIcon::fromTheme("document-print"),
                                  QIcon::fromTheme("edit-copy"),
                                  QIcon::fromTheme("edit-cut"),
                                  QIcon::fromTheme("edit-paste"),
                                  QIcon::fromTheme("application-exit"),
                                  QIcon::fromTheme("warning"),
                                  };
    QVector<QColor> color_vector = {QColor(255,0,0),
                                    QColor(0,255,0),
                                    QColor(0,0,255),
                                    QColor(255,255,0),
                                    QColor(0,255,255),

    };
    for( int i = 0 ; i < 15; i ++){
        // We create an empty item
        auto *item = new QStandardItem();



        // We fill the UserRole
        item->setData(i, Qt::UserRole);

        // Now we try the DecorationRole
        if( i < 10 )
            item->setData(icon_vector.at(i), Qt::DecorationRole);
        else
            item->setData(color_vector.at(i-10), Qt::DecorationRole);

        // Let's try the DisplayRole, but we reuse the UserRole
        item->setData(QString("Real value of %0").arg(item->data(Qt::UserRole).toInt()+1), Qt::DisplayRole);

        //item->setData(QString("Value used by the delegate for editing Item %0").arg(i+1), Qt::EditRole);

        item->setData(QString("Please enter a suitable value."), Qt::ToolTipRole);

        item->setData(QString("A new values is needed for item %0, please input it in the corresponding cell").arg(i+1), Qt::StatusTipRole);

        item->setData(QString("This is the cell were the value for item %o is displayed. You can also edit it here.").arg(i+1), Qt::WhatsThisRole);

        // We set for all items, checked status
        item->setData(Qt::Checked, Qt::CheckStateRole);

        if( i == 2 ){
            item->setData(QString("Real value of %0, increased size").arg(i+1), Qt::DisplayRole);
            item->setData(QSize(400,100), Qt::SizeHintRole);
        }else if( i == 3 ){
            item->setData(QString("Real value of %0, font changed").arg(i+1), Qt::DisplayRole);
            item->setData(QFont("Consolas"), Qt::FontRole);
        }else if( i == 4 ){
            item->setData(QString("Real value of %0, alignment changed").arg(i+1), Qt::DisplayRole);
            item->setData(Qt::AlignRight, Qt::TextAlignmentRole);
        }else if( i == 5 ){
            item->setData(QString("Real value of %0, background changed").arg(i+1), Qt::DisplayRole);
            item->setData(QColor(200,200,200), Qt::BackgroundRole);
        }else if( i == 6 ){
            item->setData(QString("Real value of %0, foreground changed").arg(i+1), Qt::DisplayRole);
            item->setData(QColor(255,0,0), Qt::ForegroundRole);
        }else if( i == 7 ){
            item->setData(QString("Real value of %0, unchecked").arg(i+1), Qt::DisplayRole);
            item->setData(Qt::Unchecked, Qt::CheckStateRole);
        }

        this->model.setItem(i,0,item);

    }

    this->ui->listView->setModel(&this->model);
    this->ui->tableView->setModel(&this->model);
    this->ui->treeView->setModel(&this->model);
    this->ui->columnView->setModel(&this->model);

}

MainWindow::~MainWindow()
{
    delete ui;
}

