import sys
from taurus.qt.qtgui.icon import getCachedPixmap
from taurus.qt.qtgui.application import TaurusApplication
from taurus.qt.qtgui.input import GraphicalChoiceDlg

app = TaurusApplication(sys.argv, cmd_line_parser=None)
pixmaps = {}
choices = [['TaurusForm', 'TaurusTrend'], ['TaurusPlot', 'Qub']]
for row in choices:
    for k in row:
        pixmaps[k] = getCachedPixmap('snapshot:%s.png' % k)

print(GraphicalChoiceDlg.getChoice(parent=None, title='Panel chooser', msg='Choose the type of Panel:', choices=choices, pixmaps=pixmaps))
sys.exit()
