#!/opt/anaconda3/bin/python
from taurus import Attribute

sine_value = Attribute('cii.oldb:/root/example/double/sine')

print('sine value: %f'% (sine_value.rvalue.magnitude))

print('sine alarm ranges: ]%s, %s['% (sine_value.alarms[0], sine_value.alarms[1]))

print('sine units: %s'% (sine_value.rvalue.units))

print('sine datapoint description: %s' % (sine_value.description))

print('sine uri: %s' % (sine_value.fullname))

print('sine label: %s' % (sine_value.label))

print('Can we write into sine?: %s' % (sine_value.isWritable()))

#Tip: You can stop the oldbproducer example app for a bit.
sine_value.write(0.5)
print( sine_value.read() )

print('sine quality: %s' % (sine_value.quality.name))
