import sys
import random
from taurus.external.qt import Qt
from taurus.qt.qtgui.util.ui import UILoadable
from taurus.qt.qtgui.application import TaurusApplication
from taurus.qt.qtgui.plot import TaurusTrend


@UILoadable
class MyWidget(Qt.QWidget):

    def __init__(self, parent=None):
        Qt.QWidget.__init__(self, parent)
        self.loadUi()
        
        self.finishWidgets()
        
    def finishWidgets(self):
        trend = TaurusTrend(self)
        model = ['cii.oldb:/root/example/double/sine',
                       'cii.oldb:/root/example/double/cosine',
                       'cii.oldb:/root/example/double/tan']
        trend.setModel(model)
        self.layout().addWidget(trend,0,2,3,1)

if __name__ == "__main__":
    app = TaurusApplication(sys.argv)

    widget = MyWidget()
    #widget.resize(800, 600)
    widget.show()

    sys.exit(app.exec_())
