/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.uml2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.uml2.uml.Profile;
import org.openarchitectureware.MetamodelContainer;
import org.openarchitectureware.MetamodelContributor;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.uml2.UML2MetaModel;
import org.openarchitectureware.uml2.Uml2AdapterLog;
import org.openarchitectureware.uml2.Uml2AdapterPlugin;
import org.openarchitectureware.uml2.profile.ProfileMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uml2MetamodelContributor
implements MetamodelContributor {
    private static Map<IJavaProject, MetamodelContainer> metamodels = new HashMap<IJavaProject, MetamodelContainer>();

    public MetaModel[] getMetamodels(IJavaProject project, TypeSystem builtin) {
        MetamodelContainer container = metamodels.get(project);
        if (container == null || container.hasChanged()) {
            if (container != null) {
                metamodels.remove(project);
                JavaCore.removeElementChangedListener((IElementChangedListener)container);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)container);
            }
            HashMap<Profile, ProfileMetaModel> result = new HashMap<Profile, ProfileMetaModel>();
            ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
            projects.add(project);
            try {
                IProject[] ps = project.getProject().getReferencedProjects();
                int i = 0;
                while (i < ps.length) {
                    IProject p = ps[i];
                    IJavaProject jp = JavaCore.create((IProject)p);
                    if (jp != null) {
                        projects.add(jp);
                    }
                    ++i;
                }
            }
            catch (CoreException e1) {
                Uml2AdapterLog.logError(e1);
            }
            HashSet<IFile> resources = new HashSet<IFile>();
            Map<IResource, Profile> models = Uml2AdapterPlugin.getFileModels();
            if (!models.isEmpty()) {
                HashSet<IJavaProject> jps = new HashSet<IJavaProject>();
                for (IFile iFile : models.keySet()) {
                    if (!project.isOnClasspath((IResource)iFile) && !this.isOnProjectsClasspath(iFile, jps)) continue;
                    Profile profile = models.get(iFile);
                    result.put(profile, new ProfileMetaModel(profile));
                    resources.add(iFile);
                }
            }
            container = new MetamodelContainer(projects, resources, new HashSet(result.values()));
            JavaCore.addElementChangedListener((IElementChangedListener)container);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)container);
            metamodels.put(project, container);
        }
        ArrayList<UML2MetaModel> all = new ArrayList<UML2MetaModel>();
        all.add(new UML2MetaModel());
        all.addAll(container.getMetaModels());
        return all.toArray(new MetaModel[all.size()]);
    }

    private boolean isOnProjectsClasspath(IFile f, Set<IJavaProject> jps) {
        for (IJavaProject element : jps) {
            if (!element.isOnClasspath((IResource)f)) continue;
            return true;
        }
        return false;
    }
}

