/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.debug.model.OawBreakpoint;
import org.openarchitectureware.debug.processing.IPluginAdapter;
import org.openarchitectureware.expression.ast.BooleanOperation;
import org.openarchitectureware.expression.ast.Cast;
import org.openarchitectureware.expression.ast.ChainExpression;
import org.openarchitectureware.expression.ast.FeatureCall;
import org.openarchitectureware.expression.ast.ISyntaxElement;
import org.openarchitectureware.expression.ast.IfExpression;
import org.openarchitectureware.expression.ast.LetExpression;
import org.openarchitectureware.expression.ast.OperationCall;
import org.openarchitectureware.expression.ast.SwitchExpression;
import org.openarchitectureware.expression.debug.BaseSpecialTreatment;
import org.openarchitectureware.expression.debug.EvaluatedElementWrapper;
import org.openarchitectureware.expression.debug.ExpressionModelPresentation;
import org.openarchitectureware.internal.OawLog;
import org.openarchitectureware.workflow.util.PluginConfigurationElementUtil;
import org.openarchitectureware.xtend.XtendEditorPlugin;
import org.openarchitectureware.xtend.ast.Around;
import org.openarchitectureware.xtend.ast.CreateExtensionStatement;
import org.openarchitectureware.xtend.ast.ExpressionExtensionStatement;
import org.openarchitectureware.xtend.ast.ExtensionFile;
import org.openarchitectureware.xtend.editor.XtendEditor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionPluginAdapter
implements IPluginAdapter {
    protected ExpressionModelPresentation pres;
    protected Set<BaseSpecialTreatment> specials = new HashSet<BaseSpecialTreatment>();
    private Image icon = null;

    public ExpressionPluginAdapter() {
        this.pres = new ExpressionModelPresentation(this.specials);
    }

    protected String getRequiredExtension() {
        return "ext";
    }

    public boolean canHandleResourceExtension(String ext) {
        return this.getRequiredExtension().equals(ext);
    }

    public boolean canHandleType(String type) {
        return "expression".equals(type);
    }

    public String getEditorId() {
        return PluginConfigurationElementUtil.getConfigAttribute((String)("org.eclipse.ui.editors/editor[class=" + XtendEditor.class.getName() + "]/id"));
    }

    public boolean isToggleBpEnabled(IResource resource, int start, int end, int line) {
        List<ISyntaxElement> candidates = this.getAllElementsForExtensionAtOffset(resource, start);
        if (candidates.isEmpty()) {
            return false;
        }
        ISyntaxElement element = this.findLastValidElementBeforeOffset(candidates, start);
        if (element == null) {
            return false;
        }
        return this.pres.getStart(element) <= start && this.pres.getStartingEndPosition(element) >= end;
    }

    public OawBreakpoint createBreakpoint(IResource resource, int start, int end, int line) throws CoreException {
        ISyntaxElement element = this.findElementForPosition(resource, start, end);
        if (element == null) {
            return null;
        }
        return new OawBreakpoint(resource, element.getNameString(null), element.getLine(), this.pres.getStart(element), this.pres.getStartingEndPosition(element));
    }

    public IBreakpoint checkBreakpoints(IBreakpoint[] bps, IResource resource, int start, int end, int line) throws CoreException {
        ISyntaxElement element = this.findElementForPosition(resource, start, end);
        if (element == null) {
            return null;
        }
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp1 = iBreakpointArray[n2];
            OawBreakpoint bp = (OawBreakpoint)bp1;
            if (bp.getResource().equals(resource.getFullPath().toString()) && bp.getLine() == element.getLine() && bp.getCharStart() == this.pres.getStart(element) && bp.getCharEnd() == this.pres.getStartingEndPosition(element)) {
                return bp;
            }
            ++n2;
        }
        return null;
    }

    private ISyntaxElement findElementForPosition(IResource resource, int start, int end) {
        List<ISyntaxElement> candidates = this.getAllElementsForExtensionAtOffset(resource, start);
        ISyntaxElement element = null;
        element = end == start ? this.findLastValidElementBeforeOffset(candidates, start) : this.findFirstValidElementInLine(candidates, start, end);
        if (element == null) {
            element = this.findLastValidElementBeforeOffset(candidates, start);
        }
        return element;
    }

    private List<ISyntaxElement> getAllElementsForExtensionAtOffset(IResource resource, int offset) {
        IOawProject project = OawPlugin.getOawModelManager().findProject(resource.getProject().getFullPath());
        if (project != null) {
            IOawResource[] iOawResourceArray = project.getAllRegisteredResources();
            int n = iOawResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOawResource res = iOawResourceArray[n2];
                if (res.getUnderlyingStorage().equals(resource)) {
                    List<ISyntaxElement> candidates = this.collectFirstLevelElements(res);
                    if (candidates.isEmpty()) {
                        return Collections.emptyList();
                    }
                    ISyntaxElement topElement = candidates.get(0);
                    for (ISyntaxElement next : candidates) {
                        int start = next.getStart();
                        if (start == 0) {
                            System.out.println("Start is 0 for " + next.getClass().getSimpleName());
                            List<ISyntaxElement> bodyElements = this.getBody(next);
                            if (!bodyElements.isEmpty()) {
                                start = this.pres.getStart(bodyElements.get(0));
                            }
                        }
                        if (start > offset) break;
                        topElement = next;
                    }
                    return this.getAllContainingElements(topElement);
                }
                ++n2;
            }
        } else {
            OawLog.logInfo((String)("Couldn't create oAW Project for project " + resource.getProject().getName()));
        }
        return Collections.emptyList();
    }

    private List<ISyntaxElement> getAllContainingElements(ISyntaxElement parent) {
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        if (parent instanceof EvaluatedElementWrapper) {
            result.add(((EvaluatedElementWrapper)parent).getElement());
        } else {
            List<ISyntaxElement> bodyElements = this.getBody(parent);
            for (ISyntaxElement element : bodyElements) {
                result.addAll(this.getAllContainingElements(element));
            }
        }
        return result;
    }

    private ISyntaxElement findLastValidElementBeforeOffset(List<ISyntaxElement> candidates, int offset) {
        ISyntaxElement previousValid = null;
        ISyntaxElement candidate = null;
        for (ISyntaxElement next : candidates) {
            if (this.isValidReturnElement(next)) {
                previousValid = next;
            }
            if (this.pres.getStart(next) > offset && this.isValidReturnElement(candidate)) {
                return candidate;
            }
            candidate = next;
        }
        if (this.isValidReturnElement(candidate)) {
            return candidate;
        }
        return previousValid;
    }

    private ISyntaxElement findFirstValidElementInLine(List<ISyntaxElement> candidates, int start, int end) {
        for (ISyntaxElement next : candidates) {
            if (this.pres.getStart(next) > start && this.isValidReturnElement(next)) {
                return next;
            }
            if (this.pres.getStart(next) > end) break;
        }
        return null;
    }

    protected List<ISyntaxElement> collectFirstLevelElements(IOawResource res) {
        ArrayList exts = new ArrayList();
        exts.addAll(((ExtensionFile)res.getOawResource()).getExtensions());
        exts.addAll(((ExtensionFile)res.getOawResource()).getArounds());
        ArrayList<ISyntaxElement> expressions = new ArrayList<ISyntaxElement>();
        for (ISyntaxElement ext : exts) {
            if (ext instanceof ExpressionExtensionStatement) {
                expressions.add(ext);
                continue;
            }
            if (ext instanceof CreateExtensionStatement) {
                expressions.add(ext);
                continue;
            }
            if (!(ext instanceof Around)) continue;
            expressions.add(ext);
        }
        return expressions;
    }

    protected List<ISyntaxElement> getBody(ISyntaxElement exp) {
        IfExpression op;
        ISyntaxElement[] body = new ISyntaxElement[]{};
        if (exp instanceof IfExpression) {
            op = (IfExpression)exp;
            body = new ISyntaxElement[]{op.getCondition(), op.getThenPart(), op.getElsePart()};
        } else if (exp instanceof OperationCall) {
            op = (OperationCall)exp;
            ArrayList<Object> kids = new ArrayList<Object>();
            kids.add(op.getTarget());
            kids.add(new EvaluatedElementWrapper((ISyntaxElement)op));
            kids.addAll(op.getParamsAsList());
            body = kids.toArray(new ISyntaxElement[0]);
        } else if (exp instanceof FeatureCall) {
            body = new ISyntaxElement[]{((FeatureCall)exp).getTarget(), new EvaluatedElementWrapper(exp)};
        } else if (exp instanceof ExpressionExtensionStatement) {
            body = new ISyntaxElement[]{((ExpressionExtensionStatement)exp).getExpression()};
        } else if (exp instanceof CreateExtensionStatement) {
            body = new ISyntaxElement[]{((CreateExtensionStatement)exp).getExpression()};
        } else if (exp instanceof Around) {
            body = new ISyntaxElement[]{((Around)exp).getExpression()};
        } else if (exp instanceof BooleanOperation) {
            op = (BooleanOperation)exp;
            body = new ISyntaxElement[]{op.getLeft(), op.getRight()};
        } else if (exp instanceof SwitchExpression) {
            op = (SwitchExpression)exp;
            body = new ISyntaxElement[]{op.getSwitchExpr(), op.getDefaultExpr()};
        } else if (exp instanceof ChainExpression) {
            op = (ChainExpression)exp;
            body = new ISyntaxElement[]{op.getFirst(), op.getNext()};
        } else if (exp instanceof LetExpression) {
            op = (LetExpression)exp;
            body = new ISyntaxElement[]{op.getVarExpression(), op.getTargetExpression()};
        } else if (exp instanceof Cast) {
            op = (Cast)exp;
            body = new ISyntaxElement[]{op.getTarget()};
        }
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        ISyntaxElement[] iSyntaxElementArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            ISyntaxElement element = iSyntaxElementArray[n2];
            if (element != null) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    protected boolean isValidReturnElement(ISyntaxElement se) {
        return se instanceof OperationCall && ((OperationCall)se).getName().getValue().length() > 2;
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/extensionfile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)XtendEditorPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {}
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

