/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.editor;

import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.openarchitectureware.core.builder.OawProblemHover;
import org.openarchitectureware.editor.AbstractOawSourceViewerConfiguration;
import org.openarchitectureware.xtend.editor.codeassist.XtendContentAssistProcessor;
import org.openarchitectureware.xtend.editor.scanning.CommentScanner;
import org.openarchitectureware.xtend.editor.scanning.ContentScanner;
import org.openarchitectureware.xtend.editor.scanning.StringLiteralScanner;

public class XtendSourceViewerConfiguration
extends AbstractOawSourceViewerConfiguration {
    private ContentScanner contentScanner;
    private CommentScanner commentScanner;
    private StringLiteralScanner stringLiteralScanner;

    public XtendSourceViewerConfiguration(IEditorPart editor) {
        super(editor);
    }

    public String[] getConfiguredContentTypes(ISourceViewer aSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__comment", "__stringlit"};
    }

    protected void createContentAssistProcessor(ContentAssistant contentAssistant) {
        XtendContentAssistProcessor processor = new XtendContentAssistProcessor(this.getEditor());
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
    }

    public String[] getIndentPrefixes(ISourceViewer aSourceViewer, String aContentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer aSourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringLiteralScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__stringlit");
        reconciler.setRepairer((IPresentationRepairer)dr, "__stringlit");
        dr = new DefaultDamagerRepairer(this.getContentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private CommentScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new CommentScanner();
        }
        return this.commentScanner;
    }

    private StringLiteralScanner getStringLiteralScanner() {
        if (this.stringLiteralScanner == null) {
            this.stringLiteralScanner = new StringLiteralScanner();
        }
        return this.stringLiteralScanner;
    }

    protected ITokenScanner getContentScanner() {
        if (this.contentScanner == null) {
            this.contentScanner = new ContentScanner();
        }
        return this.contentScanner;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new OawProblemHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new OawProblemHover(sourceViewer);
    }
}

