/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyCurrent;
import org.omg.CORBA.PolicyCurrentHelper;
import org.omg.CORBA.PolicyListHolder;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.dii.ContextList;
import org.openorb.CORBA.dii.Environment;
import org.openorb.CORBA.dii.ExceptionList;
import org.openorb.CORBA.dii.Request;
import org.openorb.PI.CurrentImpl;
import org.openorb.io.HexPrintStream;
import org.openorb.net.Address;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientRequest;
import org.openorb.net.LocalClientRequest;
import org.openorb.policy.ForceMarshalPolicy;
import org.openorb.policy.ORBPolicyManagerImpl;
import org.openorb.policy.PolicyReconciler;
import org.openorb.policy.PolicySetManager;
import org.openorb.util.ExceptionTool;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class Delegate
extends org.omg.CORBA_2_3.portable.Delegate {
    private final org.omg.CORBA.ORB m_orb;
    private final IOR m_ior;
    private final Logger m_logger;
    private final PolicyManagerOperations m_policyOver;
    private final PolicyCurrent m_policyCurr;
    private final PolicyReconciler m_orbReconciler;
    private final PolicyManager m_orbPolicyManager;
    private final PolicySetManager m_policySetManager;
    private final CurrentImpl m_piCurrent;
    private ClientManager m_clientManager;
    private long m_hash = -1L;
    private final java.lang.Object m_bindingSync = new byte[0];
    private IOR m_effectiveIor;
    private final Set m_bindings = new HashSet();
    private int m_bindingVersion = -1;
    private ClientBinding m_selectedBinding;

    public Delegate(org.omg.CORBA.ORB orb, IOR ior) {
        this(orb, ior, null);
    }

    protected Delegate(org.omg.CORBA.ORB orb) {
        this.m_orb = orb;
        this.m_ior = null;
        this.m_policyOver = null;
        this.m_policyCurr = null;
        this.m_orbReconciler = null;
        this.m_orbPolicyManager = null;
        this.m_policySetManager = null;
        this.m_piCurrent = null;
        this.m_logger = null;
    }

    protected Delegate(org.omg.CORBA.ORB orb, IOR ior, PolicyManagerOperations policyOverides) {
        if (ior == null || orb == null) {
            throw new NullPointerException();
        }
        this.m_ior = ior;
        this.m_effectiveIor = ior;
        this.m_orb = orb;
        this.m_policyOver = policyOverides;
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        this.m_piCurrent = ((ORB)this.m_orb).getPICurrent();
        this.m_clientManager = (ClientManager)((ORB)this.m_orb).getFeature("ClientCPCManager");
        if (null == this.m_clientManager) {
            throw Trace.signalIllegalCondition(this.m_logger, "ClientCPCManager unavailable");
        }
        this.m_orbReconciler = (PolicyReconciler)((ORB)this.m_orb).getFeature("PolicyReconciler");
        if (null == this.m_orbReconciler) {
            this.m_logger.warn("PolicyReconciler unavailable");
        }
        this.m_policySetManager = (PolicySetManager)((ORB)this.m_orb).getFeature("PolicySetManager");
        if (null == this.m_policySetManager) {
            this.m_logger.warn("PolicySetManager unavailable");
        }
        PolicyCurrent policyCurrent = null;
        try {
            policyCurrent = PolicyCurrentHelper.narrow(this.m_orb.resolve_initial_references("PolicyCurrent"));
        }
        catch (InvalidName e) {
            this.m_logger.warn("Unable to resolve PolicyCurrent.", e);
        }
        this.m_policyCurr = policyCurrent;
        ORBPolicyManagerImpl policyManager = null;
        try {
            policyManager = (ORBPolicyManagerImpl)this.m_orb.resolve_initial_references("ORBPolicyManager");
        }
        catch (InvalidName e) {
            this.m_logger.warn("Unable to resolve ORBPolicyManager.", e);
        }
        this.m_orbPolicyManager = policyManager;
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private CurrentImpl getPICurrent() {
        return this.m_piCurrent;
    }

    public final org.omg.CORBA.ORB _getORB() {
        return this.m_orb;
    }

    public final IOR _getIOR() {
        return this.m_ior;
    }

    public final PolicyManagerOperations _getPolicyManagerOperations() {
        return this.m_policyOver;
    }

    public InterfaceDef get_interface(Object self) {
        return InterfaceDefHelper.narrow(this.get_interface_def(self));
    }

    private UNKNOWN createUnexpectedException(ApplicationException e) {
        return (UNKNOWN)ExceptionTool.initCause(new UNKNOWN("Unexpected User Exception: " + e.getId() + " (" + e + ")", 1330446337, CompletionStatus.COMPLETED_YES), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get_interface_def(Object self) {
        RequestState state;
        while ((state = this.begin_invocation(self, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inStream = null;
                try {
                    OutputStream outStream = this.request(self, "_interface", true);
                    inStream = this.invoke(self, outStream);
                    Object object2 = inStream.read_Object();
                    java.lang.Object var7_14 = null;
                    this.releaseReply(self, inStream);
                    return object2;
                }
                catch (Throwable throwable) {
                    java.lang.Object var7_15 = null;
                    this.releaseReply(self, inStream);
                    throw throwable;
                }
            }
            catch (RemarshalException e) {
            }
            catch (ApplicationException e) {
                this.getLogger().error("Application exception", e);
                throw this.createUnexpectedException(e);
            }
        }
        boolean failed = true;
        state.incrementLocalLevel();
        try {
            boolean bl;
            Object object;
            try {
                Object ret = state.getBinding().get_interface_def();
                failed = false;
                object = ret;
                java.lang.Object var9_19 = null;
                bl = !failed;
            }
            catch (SystemException e) {
                state.receiveSystemException(self, e);
                failed = false;
                Object object3 = null;
                java.lang.Object var9_20 = null;
                state.completeInvocation(!failed);
                return object3;
            }
            catch (ForwardRequest e) {
                IOR fwd = ((Delegate)((ObjectImpl)e.forward)._get_delegate()).ior();
                state.receiveRedirect(self, fwd, false);
                failed = false;
                Object object4 = null;
                java.lang.Object var9_21 = null;
                state.completeInvocation(!failed);
                return object4;
            }
            state.completeInvocation(bl);
            return object;
        }
        catch (Throwable throwable) {
            java.lang.Object var9_22 = null;
            state.completeInvocation(!failed);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get_component(Object self) {
        RequestState state;
        while ((state = this.begin_invocation(self, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inStream = null;
                try {
                    OutputStream outStream = this.request(self, "_component", true);
                    inStream = this.invoke(self, outStream);
                    Object object2 = inStream.read_Object();
                    java.lang.Object var7_14 = null;
                    this.releaseReply(self, inStream);
                    return object2;
                }
                catch (Throwable throwable) {
                    java.lang.Object var7_15 = null;
                    this.releaseReply(self, inStream);
                    throw throwable;
                }
            }
            catch (RemarshalException e) {
            }
            catch (ApplicationException e) {
                this.getLogger().error("Application exception:", e);
                throw this.createUnexpectedException(e);
            }
        }
        boolean failed = true;
        state.incrementLocalLevel();
        try {
            boolean bl;
            Object object;
            try {
                Object ret = state.getBinding().get_component();
                failed = false;
                object = ret;
                java.lang.Object var9_19 = null;
                bl = !failed;
            }
            catch (SystemException e) {
                state.receiveSystemException(self, e);
                failed = false;
                Object object3 = null;
                java.lang.Object var9_20 = null;
                state.completeInvocation(!failed);
                return object3;
            }
            catch (ForwardRequest e) {
                IOR fwd = ((Delegate)((ObjectImpl)e.forward)._get_delegate()).ior();
                state.receiveRedirect(self, fwd, false);
                failed = false;
                Object object4 = null;
                java.lang.Object var9_21 = null;
                state.completeInvocation(!failed);
                return object4;
            }
            state.completeInvocation(bl);
            return object;
        }
        catch (Throwable throwable) {
            java.lang.Object var9_22 = null;
            state.completeInvocation(!failed);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean is_a(Object self, String id) {
        RequestState state;
        java.lang.Object test = RepoIDHelper.createIsATest(id);
        if (test.equals("IDL:omg.org/CORBA/Object:1.0")) {
            return true;
        }
        if (test.equals(this.m_ior.type_id)) {
            return true;
        }
        String[] ids = ((ObjectImpl)self)._ids();
        int i = 0;
        while (i < ids.length) {
            if (test.equals(ids[i])) {
                return true;
            }
            ++i;
        }
        while ((state = this.begin_invocation(self, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inStream = null;
                try {
                    OutputStream outStream = this.request(self, "_is_a", true);
                    outStream.write_string(id);
                    inStream = this.invoke(self, outStream);
                    boolean bl2 = inStream.read_boolean();
                    java.lang.Object var11_18 = null;
                    this.releaseReply(self, inStream);
                    return bl2;
                }
                catch (Throwable throwable) {
                    java.lang.Object var11_19 = null;
                    this.releaseReply(self, inStream);
                    throw throwable;
                }
            }
            catch (RemarshalException e) {
            }
            catch (ApplicationException e) {
                this.getLogger().error("Application exception:", e);
                throw this.createUnexpectedException(e);
            }
        }
        boolean failed = true;
        state.incrementLocalLevel();
        try {
            boolean bl;
            boolean bl2;
            try {
                boolean ret = state.getBinding().is_a(id);
                failed = false;
                bl2 = ret;
                java.lang.Object var13_23 = null;
                bl = !failed;
            }
            catch (SystemException e) {
                state.receiveSystemException(self, e);
                failed = false;
                boolean bl3 = false;
                java.lang.Object var13_24 = null;
                state.completeInvocation(!failed);
                return bl3;
            }
            catch (ForwardRequest e) {
                IOR fwd = ((Delegate)((ObjectImpl)e.forward)._get_delegate()).ior();
                state.receiveRedirect(self, fwd, false);
                failed = false;
                boolean bl4 = false;
                java.lang.Object var13_25 = null;
                state.completeInvocation(!failed);
                return bl4;
            }
            state.completeInvocation(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            java.lang.Object var13_26 = null;
            state.completeInvocation(!failed);
            throw throwable;
        }
    }

    public DomainManager[] get_domain_managers(Object self) {
        return this.get_domain_managers_and_policies(self, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DomainManager[] get_domain_managers_and_policies(Object self, int[] policy_types, PolicyListHolder policies) {
        RequestState state;
        while ((state = this.begin_invocation(self, false)).getBinding().getObjectAdapter() == null) {
            try {
                InputStream inStream = null;
                try {
                    OutputStream outStream = this.request(self, "_get_domain_managers", true);
                    inStream = this.invoke(self, outStream);
                    DomainManager[] ret2222 = DomainManagersListHelper.read(inStream);
                    if (policies != null) {
                        policies.value = state.getBinding().getAddress().get_target_policies(policy_types);
                    }
                    DomainManager[] domainManagerArray = ret2222;
                    java.lang.Object var10_18 = null;
                    this.releaseReply(self, inStream);
                    return domainManagerArray;
                }
                catch (Throwable throwable) {
                    java.lang.Object var10_19 = null;
                    this.releaseReply(self, inStream);
                    throw throwable;
                }
            }
            catch (RemarshalException e) {
            }
            catch (ApplicationException e) {
                this.getLogger().error("Application exception:", e);
                throw this.createUnexpectedException(e);
            }
        }
        boolean failed = true;
        state.incrementLocalLevel();
        try {
            boolean bl;
            DomainManager[] ret2222;
            try {
                DomainManager[] ret3 = state.getBinding().get_domain_managers();
                failed = false;
                ret2222 = ret3;
                java.lang.Object var12_22 = null;
                bl = !failed;
            }
            catch (SystemException e) {
                state.receiveSystemException(self, e);
                failed = false;
                DomainManager[] ret2222 = null;
                java.lang.Object var12_23 = null;
                state.completeInvocation(!failed);
                return ret2222;
            }
            catch (ForwardRequest e) {
                IOR fwd = ((Delegate)((ObjectImpl)e.forward)._get_delegate()).ior();
                state.receiveRedirect(self, fwd, false);
                failed = false;
                DomainManager[] domainManagerArray = null;
                java.lang.Object var12_24 = null;
                state.completeInvocation(!failed);
                return domainManagerArray;
            }
            state.completeInvocation(bl);
            return ret2222;
        }
        catch (Throwable throwable) {
            java.lang.Object var12_25 = null;
            state.completeInvocation(!failed);
            throw throwable;
        }
    }

    public boolean non_existent(Object self) {
        RequestState state = this.begin_invocation(self, false);
        return state.locateAndGetPolicies(self, null);
    }

    public Object duplicate(Object self) {
        return self;
    }

    public void release(Object self) {
    }

    public boolean is_equivalent(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        org.omg.CORBA.portable.Delegate portableDelegate2 = ((ObjectImpl)obj2)._get_delegate();
        if (!(portableDelegate2 instanceof Delegate)) {
            return false;
        }
        Delegate delegate2 = (Delegate)portableDelegate2;
        if (this == delegate2) {
            return true;
        }
        TaggedProfile[] profiles1 = this.m_ior.profiles;
        TaggedProfile[] profiles2 = delegate2.m_ior.profiles;
        if (profiles2.length != profiles2.length) {
            return false;
        }
        int i = 0;
        while (i < profiles1.length) {
            TaggedProfile profile1 = profiles1[i];
            TaggedProfile profile2 = profiles2[i];
            if (profile1.tag != profile2.tag || !Arrays.equals(profile1.profile_data, profile2.profile_data)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object self, java.lang.Object obj) {
        if (!(obj instanceof Object)) {
            return false;
        }
        return this.is_equivalent(self, (Object)obj);
    }

    public int hash(Object self, int max) {
        if (this.m_hash == -1L) {
            this.m_hash = 0L;
            TaggedProfile[] profiles = this.m_ior.profiles;
            int i = 0;
            while (i < profiles.length) {
                TaggedProfile profile = profiles[i];
                byte[] profileData = profile.profile_data;
                int j = 0;
                while (j < profileData.length) {
                    this.m_hash = 31L * this.m_hash + (long)profileData[j];
                    ++j;
                }
                this.m_hash = 31L * this.m_hash + (long)profile.tag;
                ++i;
            }
        }
        return (int)(this.m_hash % (long)(max + 1)) & Integer.MAX_VALUE;
    }

    public int hashCode(Object self) {
        return this.hash(self, Integer.MAX_VALUE);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result) {
        return new Request(self, operation, arg_list, result, new Environment(), new ExceptionList(), new ContextList(), this.m_orb);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result, org.omg.CORBA.ExceptionList excepts, org.omg.CORBA.ContextList contexts) {
        return new Request(self, operation, arg_list, result, new Environment(), excepts, contexts, this.m_orb);
    }

    public org.omg.CORBA.Request request(Object self, String operation) {
        return new Request(self, operation, this.m_orb);
    }

    public boolean is_local(Object self) {
        ForceMarshalPolicy pol = (ForceMarshalPolicy)this.client_policy(self, 1146057218);
        if (pol != null && pol.forceMarshal()) {
            return false;
        }
        RequestState state = this.begin_invocation(self, false);
        return state.getBinding().local_invoke();
    }

    public OutputStream request(Object self, String operation, boolean responseExpected) {
        RequestState state = this.begin_invocation(self, false);
        block6: while (true) {
            try {
                if (this.is_local(self)) {
                    state.setRequest(LocalClientRequest.createLocalClientRequest(this.m_orb, self, operation, responseExpected, state.getAddresses()));
                } else {
                    state.setRequest(state.getBinding().create_request(self, operation, responseExpected));
                }
            }
            catch (SystemException e) {
                state.receiveSystemException(self, e);
                continue;
            }
            ClientRequest request = state.getRequest();
            OutputStream ret = request.begin_marshal();
            if (ret != null) {
                return ret;
            }
            switch (request.reply_status()) {
                case 1: {
                    state.receiveSystemException(self, request.received_system_exception());
                    continue block6;
                }
                case 3: {
                    state.receiveRedirect(self, request.forward_reference_ior(), false);
                    continue block6;
                }
            }
            Trace.signalIllegalCondition(this.getLogger(), "Invalid reply_status.");
        }
    }

    public void invoke_deferred(Object self, OutputStream os) {
        if (self == null || os == null) {
            throw new BAD_PARAM();
        }
        RequestState state = this.locate_state();
        if (state == null || state.getRequest() == null) {
            throw new BAD_INV_ORDER(1146056707, CompletionStatus.COMPLETED_NO);
        }
        state.getRequest().send_request();
        CurrentImpl current = this.getPICurrent();
        current.store_invocation_ctx(os);
        current.set_invocation_ctx(state.getParentState());
        state.setParentState(null);
    }

    public boolean poll_response(Object self, OutputStream os) {
        if (self == null || os == null) {
            throw new BAD_PARAM();
        }
        CurrentImpl current = this.getPICurrent();
        RequestState state = (RequestState)current.retrieve_invocation_ctx(os, false);
        if (state == null) {
            throw new BAD_INV_ORDER("Operation not sent deferred", 1330446349, CompletionStatus.COMPLETED_MAYBE);
        }
        return state.pollResponse();
    }

    public InputStream invoke(Object self, OutputStream os) throws ApplicationException, RemarshalException {
        int request_state;
        CurrentImpl current = this.getPICurrent();
        if (self == null || os == null) {
            throw new BAD_PARAM();
        }
        RequestState state = (RequestState)current.retrieve_invocation_ctx(os, true);
        if (state != null) {
            state.setParentState(this.locate_state());
            current.set_invocation_ctx(state);
            request_state = state.getRequest().state();
        } else {
            state = this.locate_state();
            if (state == null || state.getRequest() == null) {
                throw new BAD_INV_ORDER(1146056707, CompletionStatus.COMPLETED_NO);
            }
            request_state = state.getRequest().send_request();
        }
        switch (request_state) {
            case 2: {
                request_state = state.waitForResponse();
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
            }
        }
        switch (request_state) {
            case 3: {
                switch (state.getRequest().reply_status()) {
                    case 0: {
                        return state.getRequest().receive_response();
                    }
                    case 2: {
                        throw new ApplicationException(state.getRequest().received_exception_id(), state.getRequest().receive_response());
                    }
                }
                throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
            }
            case 4: {
                switch (state.getRequest().reply_status()) {
                    case 0: {
                        return state.getRequest().receive_response();
                    }
                    case 2: {
                        throw new ApplicationException(state.getRequest().received_exception_id(), state.getRequest().receive_response());
                    }
                    case 1: {
                        state.receiveSystemException(self, state.getRequest().received_system_exception());
                        throw new RemarshalException();
                    }
                    case 3: {
                        state.receiveRedirect(self, state.getRequest().forward_reference_ior(), false);
                        throw new RemarshalException();
                    }
                    case 4: {
                        state.failoverTransient(self, true);
                        throw new RemarshalException();
                    }
                }
                throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
            }
            case 2: {
                TIMEOUT e = new TIMEOUT(0, CompletionStatus.COMPLETED_MAYBE);
                state.getRequest().cancel(e);
                state.completeInvocation(false);
                throw e;
            }
        }
        throw Trace.signalIllegalCondition(this.getLogger(), "Unexpected case");
    }

    public void releaseReply(Object self, InputStream is) {
        RequestState state = this.locate_state();
        if (null == state) {
            return;
        }
        ClientRequest request = state.getRequest();
        if (null == request) {
            return;
        }
        switch (request.state()) {
            case 1: {
                state.completeInvocation(false);
                MARSHAL e = new MARSHAL("Exception thrown during marshal", 1146056732, CompletionStatus.COMPLETED_NO);
                request.cancel(e);
                break;
            }
            case 3: {
                state.completeInvocation(false);
                MARSHAL e = new MARSHAL("Buffer Underread", 1146056733, CompletionStatus.COMPLETED_YES);
                request.cancel(e);
                throw e;
            }
            case 2: {
                TIMEOUT e = new TIMEOUT(0, CompletionStatus.COMPLETED_MAYBE);
                request.cancel(e);
                state.completeInvocation(false);
                break;
            }
            case 4: {
                state.completeInvocation(true);
            }
        }
    }

    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        return this.begin_invocation(self, false).servantPreInvoke(self, operation, expectedType);
    }

    public void servant_postinvoke(Object self, ServantObject servant) {
        this.locate_state().servantPostInvoke(self, servant);
    }

    public Policy get_policy(Object self, int policy_type) {
        Policy profile_policy;
        Policy client_policy = this.client_policy(self, policy_type);
        int[] pt = new int[]{policy_type};
        PolicyListHolder policies = new PolicyListHolder();
        DomainManager[] managers = this.get_domain_managers_and_policies(self, pt, policies);
        Policy policy = profile_policy = policies.value.length == 0 ? null : policies.value[0];
        if (null == this.m_orbReconciler) {
            INTERNAL e = new INTERNAL("PolicyReconciler unavailable");
            this.getLogger().error(e.getMessage(), e);
            throw e;
        }
        return this.m_orbReconciler.reconcile_policies(policy_type, client_policy, profile_policy, managers);
    }

    public Policy get_client_policy(Object self, int policy_type) {
        Policy policy = this.client_policy(self, policy_type);
        return policy;
    }

    private Policy client_policy(Object self, int policy_type) {
        INTERNAL e;
        Policy[] polices;
        RequestState state = this.locate_state();
        if (null == state || !state.isInIgnoreRebindMode() || policy_type == 23) {
            // empty if block
        }
        int[] policyTypes = new int[]{policy_type};
        if (null != this.m_policyOver && (polices = this.m_policyOver.get_policy_overrides(policyTypes)).length > 0) {
            return polices[0];
        }
        if (null == this.m_policyCurr) {
            e = new INTERNAL("Unable to resolve PolicyCurrent (" + null + ")");
            this.getLogger().error("Unable to resolve PolicyCurrent.", e);
            throw e;
        }
        polices = this.m_policyCurr.get_policy_overrides(policyTypes);
        if (polices.length > 0) {
            return polices[0];
        }
        if (null == this.m_orbPolicyManager) {
            e = new INTERNAL("Unable to resolve ORBPolicyManager (" + null + ")");
            this.getLogger().error("Unable to resolve ORBPolicyManager.", e);
            throw e;
        }
        polices = this.m_orbPolicyManager.get_policy_overrides(policyTypes);
        if (polices.length > 0) {
            return polices[0];
        }
        return null;
    }

    public Object set_policy_override(Object self, Policy[] policies, SetOverrideType set_add) {
        try {
            return this.set_policy_overrides(self, policies, set_add);
        }
        catch (InvalidPolicies e) {
            this.getLogger().error("Invalid policy passed to set_policy_overrides().", e);
            throw ExceptionTool.initCause(new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO), (Throwable)e);
        }
    }

    public Object set_policy_overrides(Object self, Policy[] policies, SetOverrideType set_add) throws InvalidPolicies {
        PolicyManagerOperations newPolices;
        if (null == this.m_policySetManager) {
            INTERNAL e = new INTERNAL("PolicySetManager unavailable");
            this.getLogger().error(e.getMessage(), e);
            throw e;
        }
        if (policies.length == 0) {
            if (this.m_policyOver == null || set_add == SetOverrideType.SET_OVERRIDE) {
                newPolices = null;
            } else {
                newPolices = this.m_policySetManager.create_policy_set(0);
                newPolices.set_policy_overrides(this.m_policyOver.get_policy_overrides(new int[0]), SetOverrideType.SET_OVERRIDE);
            }
        } else if (this.m_policyOver == null || set_add == SetOverrideType.SET_OVERRIDE) {
            newPolices = this.m_policySetManager.create_policy_set(0);
            newPolices.set_policy_overrides(policies, set_add);
        } else {
            newPolices = this.m_policySetManager.create_policy_set(0);
            newPolices.set_policy_overrides(this.m_policyOver.get_policy_overrides(new int[0]), SetOverrideType.SET_OVERRIDE);
            newPolices.set_policy_overrides(policies, set_add);
        }
        ObjectImpl obj = null;
        if (!(self instanceof ObjectStub)) {
            try {
                obj = (ObjectImpl)self.getClass().newInstance();
            }
            catch (Exception e) {
                this.getLogger().error("Failed to create instance of ObjectImpl class.", e);
            }
        }
        if (null == obj) {
            obj = new ObjectStub();
        }
        Delegate delegate = new Delegate(this.m_orb, this.ior(), newPolices);
        obj._set_delegate(delegate);
        return obj;
    }

    public Policy[] get_policy_overrides(int[] ts) {
        if (this.m_policyOver == null) {
            return new Policy[0];
        }
        return this.m_policyOver.get_policy_overrides(ts);
    }

    public boolean validate_connection(Object self, PolicyListHolder inconsistent_policies) {
        PolicyListHolder policies = new PolicyListHolder();
        RequestState state = this.begin_invocation(self, true);
        try {
            boolean ret = state.locateAndGetPolicies(self, policies);
            inconsistent_policies.value = new Policy[0];
            return ret;
        }
        catch (INV_POLICY e) {
            inconsistent_policies.value = new Policy[0];
            return false;
        }
    }

    public org.omg.CORBA.ORB orb(Object self) {
        return this.m_orb;
    }

    private boolean compareIORs(IOR ior1, IOR ior2) {
        if (ior1 == ior2) {
            return true;
        }
        if (!ior1.type_id.equals(ior2.type_id) || ior1.profiles.length != ior2.profiles.length) {
            return false;
        }
        int i = 0;
        while (i < ior1.profiles.length) {
            if (ior1.profiles[i].tag != ior2.profiles[i].tag || !Arrays.equals(ior1.profiles[i].profile_data, ior2.profiles[i].profile_data)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String get_codebase(Object self) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR ior() {
        java.lang.Object object = this.m_bindingSync;
        synchronized (object) {
            return this.m_effectiveIor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address[] getAddresses(Object self) {
        CurrentImpl current = this.getPICurrent();
        java.lang.Object oldCtx = current.get_invocation_ctx();
        current.set_invocation_ctx(null);
        try {
            Address[] addressArray = this.begin_invocation(self, false).getAddresses();
            java.lang.Object var6_5 = null;
            current.set_invocation_ctx(oldCtx);
            return addressArray;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            current.set_invocation_ctx(oldCtx);
            throw throwable;
        }
    }

    private RequestState begin_invocation(Object obj, boolean ignore_rebind_mode) {
        CurrentImpl current = this.getPICurrent();
        RequestState state = (RequestState)current.get_invocation_ctx();
        if (state == null) {
            state = this.createRequestState(null);
        } else {
            if (state.isTargetDelegate(this)) {
                if (state.getRequest() != null) {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state at begin_invocation");
                }
                if (ignore_rebind_mode) {
                    state.setIgnoreRebindMode(true);
                }
                return state;
            }
            state = state.getRequest() == null && state.isLocalLevelZero() ? this.createRequestState(null) : this.createRequestState(state);
        }
        state.beginInvocation(this, current, obj, ignore_rebind_mode);
        return state;
    }

    private RequestState locate_state() {
        CurrentImpl current = this.getPICurrent();
        RequestState state = (RequestState)current.get_invocation_ctx();
        while (state != null && !state.isTargetDelegate(this)) {
            if (state.getRequest() != null || state.isLocalLevelGreaterThanZero()) {
                return null;
            }
            state = state.getParentState();
        }
        return state;
    }

    private RequestState createRequestState(RequestState parent) {
        boolean discard_old = ((ORB)this.m_orb).getLoader().getBooleanProperty("openorb.client.bindings.discard_old", false);
        RequestState rs = new RequestState(this.getLogger(), parent);
        if (discard_old) {
            rs.discardOldBindings();
        }
        return rs;
    }

    private static void mergeSort(ClientBinding[] blstsrc, boolean[] usedsrc, ClientBinding[] blst, boolean[] used, int low, int high) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && Delegate.statecomp(blst[j - 1], used[j - 1], blst[j], used[j]) > 0) {
                    ClientBinding t = blst[j];
                    boolean ut = used[j];
                    blst[j] = blst[j - 1];
                    used[j] = used[j - 1];
                    blst[j - 1] = t;
                    used[j - 1] = ut;
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = (low + high) / 2;
        Delegate.mergeSort(blstsrc, usedsrc, blst, used, low, mid);
        Delegate.mergeSort(blstsrc, usedsrc, blst, used, mid, high);
        if (Delegate.statecomp(blstsrc[mid - 1], usedsrc[mid - 1], blstsrc[mid], usedsrc[mid]) <= 0) {
            System.arraycopy(blstsrc, low, blst, low, length);
            System.arraycopy(usedsrc, low, used, low, length);
            return;
        }
        int i = low;
        int p = low;
        int q = mid;
        while (i < high) {
            if (q >= high || p < mid && Delegate.statecomp(blstsrc[p], usedsrc[p], blstsrc[q], usedsrc[q]) <= 0) {
                blst[i] = blstsrc[p];
                used[i] = usedsrc[p];
                ++p;
            } else {
                blst[i] = blstsrc[q];
                used[i] = usedsrc[q];
                ++q;
            }
            ++i;
        }
    }

    private static int statecomp(ClientBinding b1, boolean u1, ClientBinding b2, boolean u2) {
        return u1 ? (u2 ? 0 : 1) : (u2 ? -1 : ClientBinding.PRIORITY_COMP.compare(b1, b2));
    }

    public String toString(Object self) {
        try {
            Address[] addrs = this.getAddresses(self);
            ArrayList<ArrayList[]> iorList = new ArrayList<ArrayList[]>();
            int i = 0;
            while (i < addrs.length) {
                if (addrs[i] != null) {
                    IORAddressingInfo info = addrs[i].getTargetAddress((short)2).ior();
                    ArrayList[] profs = new ArrayList[info.ior.profiles.length];
                    iorList.add(profs);
                    ArrayList<Address> prof = profs[info.selected_profile_index] = new ArrayList<Address>();
                    prof.add(addrs[i]);
                    int j = i + 1;
                    while (j < addrs.length) {
                        if (addrs[j] != null) {
                            IORAddressingInfo info2 = addrs[j].getTargetAddress((short)2).ior();
                            if (this.compareIORs(info.ior, info2.ior)) {
                                prof = profs[info2.selected_profile_index];
                                if (prof == null) {
                                    prof = profs[info2.selected_profile_index] = new ArrayList<Address>();
                                }
                                prof.add(addrs[j]);
                                addrs[j] = null;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            HexPrintStream hps = new HexPrintStream(os, 2);
            PrintStream ps = new PrintStream(os);
            ps.println("Binding information for object " + self.getClass() + ":" + Integer.toHexString(System.identityHashCode(self)));
            String[] ids = ((ObjectImpl)self)._ids();
            if (ids.length != 0) {
                ps.println("Repository IDs from Object: ");
                int i2 = 0;
                while (i2 < ids.length) {
                    ps.println("    " + ids[i2]);
                    ++i2;
                }
            }
            if (iorList.size() > 1) {
                ps.println("There have been " + (iorList.size() - 1) + " redirections of this object");
            }
            int i3 = 0;
            while (i3 < iorList.size()) {
                ArrayList[] profs = (ArrayList[])iorList.get(i3);
                int totProfs = 0;
                int profOne = -1;
                int j = profs.length - 1;
                while (j >= 0) {
                    if (profs[j] != null) {
                        ++totProfs;
                        profOne = j;
                    }
                    --j;
                }
                if (totProfs != 0) {
                    int total;
                    java.lang.Object data;
                    int k;
                    IOR ior = ((Address)profs[profOne].get((int)0)).getTargetAddress((short)2).ior().ior;
                    ps.print("IOR #" + i3);
                    if (this.compareIORs(ior, this.m_ior)) {
                        ps.println(" (orginal IOR)");
                    } else if (this.compareIORs(ior, this.ior())) {
                        ps.println(" (from latest permanent redirect)");
                    } else {
                        ps.println(" (from redirect)");
                    }
                    ps.println("Published RepoID: " + ior.type_id);
                    ps.println("Bound profiles: " + totProfs);
                    Address addr0 = null;
                    int j2 = 0;
                    while (j2 < profs.length) {
                        if (profs[j2] != null) {
                            ps.print("Profile #" + j2);
                            addr0 = (Address)profs[j2].get(0);
                            switch (profs[j2].size()) {
                                case 0: {
                                    ps.println(" no endpoints found");
                                    break;
                                }
                                case 1: {
                                    ps.println(" endpoint: " + addr0.getEndpointDescription());
                                    break;
                                }
                                default: {
                                    ps.println(" endpoints:");
                                    int k2 = 0;
                                    while (k2 < profs[j2].size()) {
                                        ps.println("    " + ((Address)profs[j2].get(k2)).getEndpointDescription());
                                        ++k2;
                                    }
                                    break block1;
                                }
                            }
                            ps.print(addr0.getObjectKeyDescription());
                            int profCpts = addr0.get_profile_components();
                            if (profCpts > 0) {
                                ps.println("Components:");
                                k = 0;
                                while (k < profCpts) {
                                    data = addr0.get_component_data(k);
                                    if (data == null) {
                                        ps.println("Unknown Component. Tag: " + addr0.get_component((int)k).tag + " Data:");
                                        ps.flush();
                                        hps.write(addr0.get_component((int)k).component_data);
                                        hps.flush();
                                        ps.println();
                                    } else {
                                        ps.println(data.toString());
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j2;
                    }
                    int profCpts = addr0.get_profile_components();
                    if (profCpts < (total = addr0.get_components().length)) {
                        ps.println("Components from Multi-Component Profile:");
                        k = profCpts;
                        while (k < total) {
                            data = addr0.get_component_data(k);
                            if (data == null) {
                                ps.println("Unknown Component. Tag: " + addr0.get_component((int)k).tag + " Data:");
                                ps.flush();
                                hps.write(addr0.get_component((int)k).component_data);
                                hps.flush();
                                ps.println();
                            } else {
                                ps.println(data.toString());
                            }
                            ++k;
                        }
                    }
                }
                ++i3;
            }
            return os.toString();
        }
        catch (IOException e) {
            this.getLogger().error("Unexpected IOException.", e);
            throw ExceptionTool.initCause(new RuntimeException("Unexpected Exception (" + e + ")"), (Throwable)e);
        }
    }

    private static class RequestState {
        private static final long NO_DEADLINE = -1L;
        private boolean m_discard_old = false;
        private final Logger m_logger;
        private ClientBinding m_binding;
        private ClientRequest m_request;
        private boolean m_ignoreRebindMode;
        private int m_version;
        private int m_idx;
        private ClientBinding[] m_bindings;
        private boolean[] m_used;
        private int m_unusedBindingsCount;
        private int m_exceptionLevel = -1;
        private SystemException m_exception;
        private long m_roundtripDeadline = -1L;
        private Delegate m_targetDelegate;
        private int m_localLevel = 0;
        private RequestState m_parentState;

        protected RequestState(Logger logger, RequestState parentState) {
            if (logger == null) {
                throw new NullPointerException("RequestState requires a logger");
            }
            this.m_logger = logger;
            this.m_parentState = parentState;
        }

        public Logger getLogger() {
            return this.m_logger;
        }

        public void incrementLocalLevel() {
            ++this.m_localLevel;
        }

        public void decrementLocalLevel() {
            --this.m_localLevel;
        }

        public boolean isLocalLevelZero() {
            return this.m_localLevel == 0;
        }

        public boolean isLocalLevelGreaterThanZero() {
            return 0 > this.m_localLevel;
        }

        public boolean isLocalStateLessThanOrEqualToZero() {
            return this.m_localLevel <= 0;
        }

        public int getExceptionLevel() {
            return this.m_exceptionLevel;
        }

        public void setExceptionLevel(int level) {
            this.m_exceptionLevel = level;
        }

        public SystemException getException() {
            return this.m_exception;
        }

        public void setException(SystemException e) {
            this.m_exception = e;
        }

        public void discardOldBindings() {
            this.m_discard_old = true;
        }

        public boolean isTargetDelegate(Delegate delegate) {
            return this.m_targetDelegate == delegate;
        }

        public void setTargetDelegate(Delegate delegate) {
            this.m_targetDelegate = delegate;
        }

        public int getVersion() {
            return this.m_version;
        }

        public void setVersion(int version) {
            this.m_version = version;
        }

        public int getIdx() {
            return this.m_idx;
        }

        public void setIdx(int value) {
            this.m_idx = value;
        }

        public ClientBinding[] getBindings() {
            return this.m_bindings;
        }

        public void setBindings(ClientBinding[] bindings) {
            this.m_bindings = bindings;
        }

        public boolean isMoreThanOneUnusedBinding() {
            return 1 < this.m_unusedBindingsCount;
        }

        public void setUnusedBindingsCount(int value) {
            this.m_unusedBindingsCount = value;
        }

        public void decrementUnusedBindingsCount() {
            --this.m_unusedBindingsCount;
        }

        public boolean areUnusedBindings() {
            return 0 != this.m_unusedBindingsCount;
        }

        public boolean[] getUsed() {
            return this.m_used;
        }

        public void setUsed(boolean[] used) {
            this.m_used = used;
        }

        public void setRelativeRoundtripTimeout(long timeout100ns) {
            this.setRelativeRoundtripTimeout(timeout100ns, System.currentTimeMillis());
        }

        public void setRelativeRoundtripTimeout(long timeout100ns, long currentTime1ms) {
            if (timeout100ns < 0L) {
                this.m_roundtripDeadline = -1L;
                if (Trace.isHigh()) {
                    this.m_logger.debug("RoundtripDeadline=[NO_DEADLINE]");
                }
            } else {
                this.m_roundtripDeadline = currentTime1ms + timeout100ns / 10000L;
                if (Trace.isHigh() && this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("RoundtripDeadline=[" + this.m_roundtripDeadline + "]");
                }
            }
        }

        public boolean isRoundtripDeadlineSet() {
            return -1L != this.m_roundtripDeadline;
        }

        public long calculateTimeToDeadline() {
            return this.m_roundtripDeadline - System.currentTimeMillis();
        }

        public int waitForResponse() {
            if (this.isRoundtripDeadlineSet()) {
                long timeToDeadline = this.calculateTimeToDeadline();
                return timeToDeadline < 1L ? 2 : this.m_request.wait_for_response(timeToDeadline);
            }
            return this.m_request.wait_for_response(0L);
        }

        public boolean pollResponse() {
            return this.isRoundtripDeadlineSet() ? this.calculateTimeToDeadline() <= 0L : this.m_request.poll_response();
        }

        public ClientBinding getBinding() {
            return this.m_binding;
        }

        public void setBinding(ClientBinding binding) {
            this.m_binding = binding;
        }

        public ClientRequest getRequest() {
            return this.m_request;
        }

        public void setRequest(ClientRequest request) {
            this.m_request = request;
        }

        public boolean isInIgnoreRebindMode() {
            return this.m_ignoreRebindMode;
        }

        public void setIgnoreRebindMode(boolean ignoreRebindMode) {
            this.m_ignoreRebindMode = ignoreRebindMode;
        }

        public RequestState getParentState() {
            return this.m_parentState;
        }

        public void setParentState(RequestState state) {
            this.m_parentState = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ServantObject servantPreInvoke(Object self, String operation, Class expectedType) {
            this.incrementLocalLevel();
            boolean failed = true;
            try {
                ServantObject servantObject;
                try {
                    ServantObject ret = this.getBinding().servant_preinvoke(operation, expectedType);
                    failed = false;
                    servantObject = ret;
                    java.lang.Object var10_10 = null;
                    if (!failed) return servantObject;
                }
                catch (SystemException e) {
                    this.receiveSystemException(self, e);
                    failed = false;
                    ServantObject servantObject2 = null;
                    java.lang.Object var10_11 = null;
                    if (!failed) return servantObject2;
                    this.completeInvocation(false);
                    return servantObject2;
                }
                catch (ForwardRequest e) {
                    IOR fwd = ((Delegate)((ObjectImpl)e.forward)._get_delegate()).ior();
                    this.receiveRedirect(self, fwd, false);
                    failed = false;
                    ServantObject servantObject3 = null;
                    java.lang.Object var10_12 = null;
                    if (!failed) return servantObject3;
                    this.completeInvocation(false);
                    return servantObject3;
                }
                this.completeInvocation(false);
                return servantObject;
            }
            catch (Throwable throwable) {
                java.lang.Object var10_13 = null;
                if (!failed) throw throwable;
                this.completeInvocation(false);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void servantPostInvoke(Object self, ServantObject servant) {
            try {
                block4: {
                    try {
                        if (null == this.getBinding()) break block4;
                        this.getBinding().servant_postinvoke(servant);
                    }
                    catch (Exception e) {
                        this.m_logger.error("Delegate.servant_postinvoke()", e);
                        java.lang.Object var5_4 = null;
                        this.completeInvocation(true);
                    }
                }
                java.lang.Object var5_3 = null;
                this.completeInvocation(true);
            }
            catch (Throwable throwable) {
                java.lang.Object var5_5 = null;
                this.completeInvocation(true);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completeInvocation(boolean success) {
            java.lang.Object object = this.m_targetDelegate.m_bindingSync;
            synchronized (object) {
                if (success == (this.m_targetDelegate.m_selectedBinding == null)) {
                    if (success) {
                        if (this.m_targetDelegate.m_selectedBinding == null) {
                            this.m_targetDelegate.m_selectedBinding = this.getBinding();
                        }
                    } else if (this.m_targetDelegate.m_selectedBinding == this.getBinding()) {
                        this.m_targetDelegate.m_selectedBinding = null;
                    }
                }
            }
            this.decrementLocalLevel();
            if (this.isLocalStateLessThanOrEqualToZero()) {
                this.m_targetDelegate.getPICurrent().set_invocation_ctx(this.getParentState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginInvocation(Delegate delegate, CurrentImpl current, Object obj, boolean ignoreRebindMode) {
            ClientBinding[] blst;
            this.setTargetDelegate(delegate);
            RelativeRoundtripTimeoutPolicy pol = (RelativeRoundtripTimeoutPolicy)this.m_targetDelegate.get_client_policy(obj, 32);
            if (pol != null) {
                this.setRelativeRoundtripTimeout(pol.relative_expiry());
            }
            current.set_invocation_ctx(this);
            java.lang.Object object = this.m_targetDelegate.m_bindingSync;
            synchronized (object) {
                this.setIgnoreRebindMode(ignoreRebindMode);
                this.setVersion(this.m_targetDelegate.m_bindingVersion);
                this.setIdx(-1);
                if (this.m_targetDelegate.m_bindingVersion < 0) {
                    this.setIgnoreRebindMode(true);
                    this.receiveRedirect(obj, this.m_targetDelegate.m_ior, true);
                    return;
                }
                if (this.m_targetDelegate.m_selectedBinding != null) {
                    this.setBinding(this.m_targetDelegate.m_selectedBinding);
                    if (this.m_targetDelegate.m_selectedBinding.local_invoke() || this.m_targetDelegate.m_selectedBinding.getClientChannel().state() != 0x13000000) {
                        return;
                    }
                    this.m_targetDelegate.m_selectedBinding = null;
                }
                blst = this.m_targetDelegate.m_bindings.toArray(new ClientBinding[this.m_targetDelegate.m_bindings.size()]);
            }
            this.refreshBindingList(blst);
            this.findNextBinding();
        }

        public boolean locateAndGetPolicies(Object self, PolicyListHolder policies) {
            int[] policyTypes = new int[]{};
            try {
                block17: while (true) {
                    if (policies != null) {
                        policies.value = this.getBinding().getAddress().get_target_policies(policyTypes);
                    }
                    if (this.getBinding().getObjectAdapter() == null) {
                        try {
                            this.setRequest(this.getBinding().create_locate_request(self));
                        }
                        catch (SystemException e) {
                            this.receiveSystemException(self, e);
                            continue;
                        }
                        this.m_request.begin_marshal();
                        int request_state = this.m_request.state();
                        if (request_state == 1 && (request_state = this.m_request.send_request()) == 2 && (request_state = this.waitForResponse()) == 2) {
                            TIMEOUT e = new TIMEOUT(0, CompletionStatus.COMPLETED_MAYBE);
                            this.m_request.cancel(e);
                            throw e;
                        }
                        if (request_state != 4) {
                            Trace.signalIllegalCondition(this.m_logger, "Unexpected request_state");
                        }
                        switch (this.m_request.reply_status()) {
                            case -1: {
                                this.completeInvocation(true);
                                return false;
                            }
                            case -2: {
                                this.failoverPermanent(self, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                                continue block17;
                            }
                            case 1: {
                                this.receiveSystemException(self, this.m_request.received_system_exception());
                                continue block17;
                            }
                            case 3: {
                                this.receiveRedirect(self, this.m_request.forward_reference_ior(), false);
                                continue block17;
                            }
                            case 4: {
                                this.failoverTransient(self, true);
                                continue block17;
                            }
                        }
                        throw Trace.signalIllegalCondition(this.m_logger, "Unexpected reply_status");
                    }
                    try {
                        if (this.getBinding().locate()) {
                            this.completeInvocation(true);
                            return false;
                        }
                        this.failoverPermanent(self, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                    }
                    catch (ForwardRequest e) {
                        IOR fwd = ((Delegate)((ObjectImpl)e.forward)._get_delegate()).ior();
                        this.receiveRedirect(self, fwd, false);
                    }
                }
            }
            catch (NO_RESPONSE e) {
                return true;
            }
            catch (COMM_FAILURE e) {
                return true;
            }
            catch (NO_IMPLEMENT e) {
                return true;
            }
            catch (OBJ_ADAPTER e) {
                return true;
            }
            catch (OBJECT_NOT_EXIST e) {
                return true;
            }
        }

        public Address[] getAddresses() {
            if (null == this.m_bindings) {
                this.setBinding(null);
                this.refreshBindingList(null);
            }
            Address[] addresses = new Address[this.m_bindings.length];
            int i = 0;
            while (i < addresses.length) {
                addresses[i] = this.m_bindings[i].getAddress();
                ++i;
            }
            return addresses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshBindingList(ClientBinding[] bindingList) {
            ClientBinding[] blst;
            if (bindingList == null) {
                java.lang.Object object = this.m_targetDelegate.m_bindingSync;
                synchronized (object) {
                    if (this.getBindings() != null && this.getVersion() >= this.m_targetDelegate.m_bindingVersion) {
                        return;
                    }
                    blst = this.m_targetDelegate.m_bindings.toArray(new ClientBinding[this.m_targetDelegate.m_bindings.size()]);
                    this.setVersion(this.m_targetDelegate.m_bindingVersion);
                }
            } else {
                blst = bindingList;
            }
            boolean[] newUsedBindings = new boolean[blst.length];
            this.setUnusedBindingsCount(blst.length);
            if (this.m_bindings != null) {
                int i = 0;
                while (i < this.m_bindings.length) {
                    if (this.m_used[i]) {
                        int j = 0;
                        while (j < blst.length) {
                            if (blst[j].equals(this.m_bindings[i])) {
                                newUsedBindings[j] = true;
                                this.decrementUnusedBindingsCount();
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else if (null != this.m_binding) {
                int j = 0;
                while (j < blst.length) {
                    if (blst[j].equals(this.m_binding)) {
                        newUsedBindings[j] = true;
                        this.decrementUnusedBindingsCount();
                        break;
                    }
                    ++j;
                }
            }
            this.setBindings(blst);
            this.setUsed(newUsedBindings);
            if (this.isMoreThanOneUnusedBinding()) {
                ClientBinding[] blstsrc = (ClientBinding[])blst.clone();
                boolean[] usedsrc = (boolean[])this.m_used.clone();
                Delegate.mergeSort(blstsrc, usedsrc, blst, this.m_used, 0, blst.length);
            }
            this.setIdx(0);
        }

        public void findNextBinding() {
            int j = 0;
            int i = this.getIdx();
            while (j < this.m_used.length) {
                if (!this.m_used[i] && (this.m_bindings[i].local_invoke() || this.m_bindings[i].getClientChannel().state() == 0x11000000)) {
                    this.setBinding(this.m_bindings[i]);
                    this.setIdx(i);
                    return;
                }
                ++j;
                i = (i + 1) % this.m_used.length;
            }
            int j2 = 0;
            int i2 = this.getIdx();
            while (j2 < this.m_used.length) {
                if (!this.m_used[i2]) {
                    if (this.m_bindings[i2].getClientChannel().state() != 0x13000000) {
                        this.setBinding(this.m_bindings[i2]);
                        this.setIdx(i2);
                        return;
                    }
                    this.m_used[i2] = true;
                    this.decrementUnusedBindingsCount();
                }
                ++j2;
                i2 = (i2 + 1) % this.m_used.length;
            }
            if (this.areUnusedBindings()) {
                Trace.signalIllegalCondition(this.m_logger, "There are still bindings available.");
            }
            this.completeInvocation(false);
            if (this.getExceptionLevel() < 0) {
                throw ExceptionTool.initCause(new TRANSIENT(2, CompletionStatus.COMPLETED_NO), (Throwable)this.getException());
            }
            try {
                throw this.getException();
            }
            catch (COMM_FAILURE e) {
                throw this.isConnectException(e) ? ExceptionTool.initCause(new TRANSIENT(2, CompletionStatus.COMPLETED_NO), (Throwable)e) : e;
            }
        }

        private boolean isConnectException(COMM_FAILURE e) {
            return CompletionStatus.COMPLETED_NO.equals(e.completed) && (1146056972 == e.minor || 1146056969 == e.minor || 1146056970 == e.minor);
        }

        public void failoverTransient(Object self, boolean transportRetry) {
            this.setRequest(null);
            ClientBinding oldBinding = this.getBinding();
            if (this.m_bindings == null) {
                this.setBinding(null);
            }
            this.refreshBindingList(null);
            this.setIdx(1);
            if (transportRetry) {
                this.setBinding(oldBinding);
                int i = 0;
                while (i < this.m_bindings.length) {
                    if (oldBinding == this.m_bindings[i]) {
                        this.setIdx(i);
                        return;
                    }
                    ++i;
                }
                Trace.signalIllegalCondition(this.m_logger, "Old binding not found.");
            } else {
                this.setIdx((this.getIdx() + 1) % this.m_bindings.length);
                this.findNextBinding();
            }
        }

        public void failoverFatal(Object self, SystemException exception) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            if (this.m_bindings != null) {
                this.m_used[this.getIdx()] = true;
                this.decrementUnusedBindingsCount();
            }
            this.refreshBindingList(null);
            if (this.getExceptionLevel() <= 1) {
                this.setExceptionLevel(1);
                this.setException(exception);
            }
            this.findNextBinding();
        }

        public void failoverPermanent(Object self, SystemException exception) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            this.getBinding().setPriority(this.getBinding().getPriority() & 0xFFFF | 0xFB0000);
            if (this.m_bindings != null) {
                this.m_used[this.getIdx()] = true;
                this.decrementUnusedBindingsCount();
            }
            this.refreshBindingList(null);
            if (this.getExceptionLevel() <= 3) {
                this.setExceptionLevel(3);
                this.setException(exception);
            }
            this.findNextBinding();
        }

        private void receiveSystemException(Object self, SystemException exception) {
            if (exception.completed == CompletionStatus.COMPLETED_NO) {
                if (exception instanceof TRANSIENT) {
                    this.failoverTransient(self, false);
                    return;
                }
                if (exception instanceof NO_RESPONSE || exception instanceof COMM_FAILURE || exception instanceof NO_IMPLEMENT || exception instanceof INV_POLICY || exception instanceof NO_PERMISSION) {
                    this.failoverFatal(self, exception);
                    return;
                }
                if (exception instanceof OBJ_ADAPTER) {
                    this.failoverPermanent(self, exception);
                    return;
                }
            }
            this.completeInvocation(exception.completed == CompletionStatus.COMPLETED_YES);
            throw exception;
        }

        private void receiveRedirect(Object self, IOR ior, boolean permanent) {
            if (this.m_discard_old) {
                this.receiveRedirectNew(self, ior, permanent);
            } else {
                this.receiveRedirectOld(self, ior, permanent);
            }
        }

        private void receiveRedirectNew(Object self, IOR ior, boolean permanent) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            if (this.m_bindings != null) {
                this.setUnusedBindingsCount(0);
                this.m_bindings = null;
            }
            ClientBinding[] new_binding_list = this.m_targetDelegate.m_clientManager.create_bindings(self, ior);
            this.m_targetDelegate.m_bindings.clear();
            this.m_targetDelegate.m_bindingVersion = 1;
            this.m_targetDelegate.m_effectiveIor = ior;
            this.setVersion(this.m_targetDelegate.m_bindingVersion);
            boolean[] usedBindings = new boolean[new_binding_list.length];
            int i = 0;
            while (i < usedBindings.length) {
                usedBindings[i] = false;
                this.m_targetDelegate.m_bindings.add(new_binding_list[i]);
                ++i;
            }
            this.setBindings(new_binding_list);
            this.setUsed(usedBindings);
            this.setUnusedBindingsCount(this.m_bindings.length);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Delegate<" + this + ">: " + "Set new bindings (" + this.m_targetDelegate.m_bindings.size() + "):");
                Iterator it = this.m_targetDelegate.m_bindings.iterator();
                while (it.hasNext()) {
                    ClientBinding cb = (ClientBinding)it.next();
                    Address clientAddress = cb.getAddress();
                    this.getLogger().debug("Delegate<" + this + ">: " + "New binding : " + clientAddress.getEndpointString());
                }
            }
            this.setBinding(this.m_bindings[0]);
            this.setIdx(0);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Delegate<" + this + ">: " + "Use binding with index " + this.getIdx());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveRedirectOld(Object self, IOR ior, boolean permanent) {
            this.setRequest(null);
            if (!this.isInIgnoreRebindMode()) {
                // empty if block
            }
            if (this.m_bindings != null) {
                this.m_used[this.getIdx()] = true;
                this.decrementUnusedBindingsCount();
            }
            ClientBinding[] new_binding_list = this.m_targetDelegate.m_clientManager.create_bindings(self, ior);
            java.lang.Object object = this.m_targetDelegate.m_bindingSync;
            synchronized (object) {
                if (permanent) {
                    this.m_targetDelegate.m_effectiveIor = ior;
                }
                int new_binding_list_len = new_binding_list.length;
                int i = 0;
                while (i < new_binding_list.length) {
                    if (this.m_targetDelegate.m_bindings.contains(new_binding_list[i])) {
                        new_binding_list[i] = null;
                        --new_binding_list_len;
                    }
                    ++i;
                }
                if (new_binding_list_len > 0) {
                    this.m_targetDelegate.m_bindingVersion++;
                    if (this.m_targetDelegate.m_bindingVersion < 250) {
                        int i2 = 0;
                        while (i2 < new_binding_list.length) {
                            int pri;
                            if (new_binding_list[i2] != null && (pri = new_binding_list[i2].getPriority()) >= 0) {
                                int newpri = 250 - this.m_targetDelegate.m_bindingVersion << 16;
                                pri = pri & 0xFFFF | newpri;
                                new_binding_list[i2].setPriority(pri);
                                this.m_targetDelegate.m_bindings.add(new_binding_list[i2]);
                            }
                            ++i2;
                        }
                    } else {
                        Iterator it = this.m_targetDelegate.m_bindings.iterator();
                        while (it.hasNext()) {
                            ClientBinding cb = (ClientBinding)it.next();
                            int pri = cb.getPriority();
                            if (pri < 0) continue;
                            int newpri = (pri & 0xFF0000) + 65536;
                            pri = pri & 0xFFFF | (newpri > 0xFA0000 ? 0xFA0000 : newpri);
                            cb.setPriority(pri);
                        }
                        int i3 = 0;
                        while (i3 < new_binding_list.length) {
                            this.m_targetDelegate.m_bindings.add(new_binding_list[i3]);
                            ++i3;
                        }
                    }
                    new_binding_list = this.m_targetDelegate.m_bindings.toArray(new_binding_list);
                }
            }
            if (this.m_targetDelegate.m_bindingVersion >= 0) {
                this.refreshBindingList(new_binding_list);
                this.setVersion(this.m_targetDelegate.m_bindingVersion);
            }
            this.findNextBinding();
        }
    }
}

