/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.dynany;

import java.io.Serializable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.dynany.DynBasicImpl;
import org.openorb.CORBA.dynany.DynEnumImpl;
import org.openorb.CORBA.dynany.DynFixedImpl;
import org.openorb.CORBA.typecode.TypeCodeBase;

abstract class DynAnyImpl
extends LocalObject
implements DynAny {
    protected static long s_dany_count = 0L;
    protected ORB m_orb;
    protected DynAnyFactory m_factory;
    protected TypeCode m_type;
    protected TypeCode m_tc;
    protected Any m_any;
    protected long m_count;
    private Logger m_logger;

    public DynAnyImpl(DynAnyFactory factory, ORB orb) {
        this.m_orb = orb;
        this.m_factory = factory;
        this.m_count = s_dany_count++;
    }

    public TypeCode type() {
        return this.m_type;
    }

    public abstract void assign(DynAny var1) throws TypeMismatch;

    public abstract void from_any(org.omg.CORBA.Any var1) throws InvalidValue, TypeMismatch;

    public abstract org.omg.CORBA.Any to_any();

    public abstract void destroy();

    public abstract DynAny copy();

    public boolean equal(DynAny dyn_any) {
        org.omg.CORBA.Any a2;
        if (!dyn_any.type().equivalent(this.m_type)) {
            return false;
        }
        org.omg.CORBA.Any a1 = this.to_any();
        return a1.equal(a2 = dyn_any.to_any());
    }

    public void insert_boolean(boolean value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_boolean);
        this.verifyInsertionTypes();
        this.m_any.insert_boolean(value);
    }

    public void insert_octet(byte value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_octet);
        this.verifyInsertionTypes();
        this.m_any.insert_octet(value);
    }

    public void insert_char(char value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_char);
        this.verifyInsertionTypes();
        this.m_any.insert_char(value);
    }

    public void insert_short(short value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_short);
        this.verifyInsertionTypes();
        this.m_any.insert_short(value);
    }

    public void insert_ushort(short value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ushort);
        this.verifyInsertionTypes();
        this.m_any.insert_ushort(value);
    }

    public void insert_long(int value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_long);
        this.verifyInsertionTypes();
        this.m_any.insert_long(value);
    }

    public void insert_ulong(int value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulong);
        this.verifyInsertionTypes();
        this.m_any.insert_ulong(value);
    }

    public void insert_float(float value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_float);
        this.verifyInsertionTypes();
        this.m_any.insert_float(value);
    }

    public void insert_double(double value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_double);
        this.verifyInsertionTypes();
        this.m_any.insert_double(value);
    }

    public void insert_string(String value) throws InvalidValue, TypeMismatch {
        int length;
        if (this.m_any == null) {
            throw new InvalidValue();
        }
        TypeCodeBase anyBaseType = ((TypeCodeBase)this.m_any.type())._base_type();
        if (anyBaseType.kind() != TCKind.tk_string) {
            throw new TypeMismatch();
        }
        try {
            length = anyBaseType.length();
        }
        catch (BadKind e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("BadKind", e);
            }
            throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
        }
        if (length > 0 && length < value.length()) {
            throw new InvalidValue();
        }
        TypeCode tc = this.m_any.type();
        this.m_any.insert_string(value);
        this.m_any.type(tc);
    }

    public void insert_reference(Object value) throws InvalidValue, TypeMismatch {
        if (((TypeCodeBase)this.m_any.type())._base_type().kind() != TCKind.tk_objref) {
            throw new TypeMismatch();
        }
        this.m_any.insert_Object(value);
    }

    public void insert_typecode(TypeCode value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_TypeCode);
        this.verifyInsertionTypes();
        this.m_any.insert_TypeCode(value);
    }

    public void insert_longlong(long value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_longlong);
        this.verifyInsertionTypes();
        this.m_any.insert_longlong(value);
    }

    public void insert_ulonglong(long value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulonglong);
        this.verifyInsertionTypes();
        this.m_any.insert_ulonglong(value);
    }

    public void insert_wchar(char value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wchar);
        this.verifyInsertionTypes();
        this.m_any.insert_wchar(value);
    }

    public void insert_wstring(String value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wstring);
        try {
            this.verifyInsertionTypes();
        }
        catch (TypeMismatch ex) {
            this.m_tc = this.m_orb.create_wstring_tc(value.length());
            this.verifyInsertionTypes();
        }
        this.m_any.insert_wstring(value);
        this.m_any.type(this.m_tc);
    }

    public void insert_any(org.omg.CORBA.Any value) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_any);
        this.verifyInsertionTypes();
        this.m_any.insert_any(value);
    }

    public void insert_dyn_any(DynAny value) throws InvalidValue, TypeMismatch {
        org.omg.CORBA.Any a = value.to_any();
        this.m_tc = a.type();
        this.verifyInsertionTypes();
        this.m_any = (Any)a;
    }

    public void insert_val(Serializable value) throws InvalidValue, TypeMismatch {
        this.m_tc = value instanceof StreamableValue ? this.m_orb.get_primitive_tc(TCKind.tk_value) : this.m_orb.get_primitive_tc(TCKind.tk_value_box);
        this.verifyInsertionTypes();
        this.m_any.insert_Value(value);
    }

    public void insert_abstract(java.lang.Object value) throws TypeMismatch, InvalidValue {
        if (this.m_type.kind().value() != 32) {
            throw new TypeMismatch();
        }
        if (!(value instanceof Serializable)) {
            throw new InvalidValue();
        }
        this.m_any.insert_Value((Serializable)value, this.m_type);
    }

    public boolean get_boolean() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_boolean);
        this.verifyExtractionTypes();
        boolean b = this.m_any.extract_boolean();
        return b;
    }

    public byte get_octet() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_octet);
        this.verifyExtractionTypes();
        byte b = this.m_any.extract_octet();
        return b;
    }

    public char get_char() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_char);
        this.verifyExtractionTypes();
        char c = this.m_any.extract_char();
        return c;
    }

    public short get_short() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_short);
        this.verifyExtractionTypes();
        short s = this.m_any.extract_short();
        return s;
    }

    public short get_ushort() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ushort);
        this.verifyExtractionTypes();
        short s = this.m_any.extract_ushort();
        return s;
    }

    public int get_long() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_long);
        this.verifyExtractionTypes();
        int l = this.m_any.extract_long();
        return l;
    }

    public int get_ulong() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulong);
        this.verifyExtractionTypes();
        int l = this.m_any.extract_ulong();
        return l;
    }

    public float get_float() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_float);
        this.verifyExtractionTypes();
        float f = this.m_any.extract_float();
        return f;
    }

    public double get_double() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_double);
        this.verifyExtractionTypes();
        double d = this.m_any.extract_double();
        return d;
    }

    public String get_string() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_string);
        this.verifyExtractionTypes();
        String s = this.m_any.extract_string();
        return s;
    }

    public Object get_reference() throws InvalidValue, TypeMismatch {
        if (((TypeCodeBase)this.m_any.type())._base_type().kind() != TCKind.tk_objref) {
            throw new TypeMismatch();
        }
        Object obj = this.m_any.extract_Object();
        return obj;
    }

    public TypeCode get_typecode() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_TypeCode);
        this.verifyExtractionTypes();
        TypeCode tc = this.m_any.extract_TypeCode();
        return tc;
    }

    public long get_longlong() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_longlong);
        this.verifyExtractionTypes();
        long ll = this.m_any.extract_longlong();
        return ll;
    }

    public long get_ulonglong() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulonglong);
        this.verifyExtractionTypes();
        long ll = this.m_any.extract_ulonglong();
        return ll;
    }

    public char get_wchar() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wchar);
        this.verifyExtractionTypes();
        char wc = this.m_any.extract_wchar();
        return wc;
    }

    public String get_wstring() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wstring);
        this.verifyExtractionTypes();
        String ws = this.m_any.extract_wstring();
        return ws;
    }

    public org.omg.CORBA.Any get_any() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_any);
        this.verifyExtractionTypes();
        org.omg.CORBA.Any any = this.m_any.extract_any();
        return any;
    }

    public DynAny get_dyn_any() throws InvalidValue, TypeMismatch {
        DynAnyFactory factory = null;
        try {
            Object obj = this.m_orb.resolve_initial_references("DynAnyFactory");
            factory = DynAnyFactoryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            // empty catch block
        }
        DynAny dany = null;
        try {
            dany = factory.create_dyn_any(this.m_any);
        }
        catch (InconsistentTypeCode ex) {}
        return dany;
    }

    public Serializable get_val() throws InvalidValue, TypeMismatch {
        try {
            this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_value);
            this.verifyExtractionTypes();
        }
        catch (TypeMismatch ex) {
            this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_value_box);
            this.verifyExtractionTypes();
        }
        Serializable ser = this.m_any.extract_Value();
        return ser;
    }

    public java.lang.Object get_abstract() throws TypeMismatch, InvalidValue {
        if (this.m_any.type().kind().value() != 32) {
            throw new TypeMismatch();
        }
        return this.m_any.extract_Object();
    }

    public abstract DynAny current_component() throws TypeMismatch;

    public abstract int component_count();

    public abstract boolean next();

    public abstract boolean seek(int var1);

    public abstract void rewind();

    protected void verifyInsertionTypes() throws TypeMismatch, InvalidValue {
        if (this.m_any == null) {
            throw new InvalidValue();
        }
        if (!((TypeCodeBase)this.m_tc)._base_type().equivalent(((TypeCodeBase)this.m_any.type())._base_type())) {
            throw new TypeMismatch();
        }
    }

    protected void verifyExtractionTypes() throws TypeMismatch, InvalidValue {
        if (this.m_any == null) {
            throw new InvalidValue();
        }
        if (!((TypeCodeBase)this.m_tc)._base_type().equal(((TypeCodeBase)this.m_any.type())._base_type())) {
            throw new TypeMismatch();
        }
    }

    protected DynAny create_dyn_any(TypeCode tc) {
        try {
            return this.m_factory.create_dyn_any_from_type_code(tc);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected DynAny[] create_dyn_any_graph(TypeCode tc) {
        DynAny[] result = null;
        switch (((TypeCodeBase)tc)._base_type().kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                result = new DynAny[]{new DynBasicImpl(this.m_factory, this.m_orb, tc, this.m_orb.create_any())};
                break;
            }
            case 16: {
                try {
                    result = new DynAny[]{this.create_dyn_any(((TypeCodeBase)tc)._base_type().discriminator_type()), null};
                }
                catch (BadKind ex) {}
                break;
            }
            case 15: 
            case 22: {
                try {
                    result = new DynAny[((TypeCodeBase)tc)._base_type().member_count()];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = this.create_dyn_any(((TypeCodeBase)tc)._base_type().member_type(i));
                        ++i;
                    }
                }
                catch (BadKind ex) {
                }
                catch (Bounds ex) {}
                break;
            }
            case 17: {
                result = new DynAny[]{new DynEnumImpl(this.m_factory, this.m_orb, tc, 0)};
                break;
            }
            case 20: {
                try {
                    result = new DynAny[((TypeCodeBase)tc)._base_type().length()];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = this.create_dyn_any(((TypeCodeBase)tc)._base_type().content_type());
                        ++i;
                    }
                }
                catch (BadKind ex) {}
                break;
            }
            case 19: {
                result = new DynAny[]{};
                break;
            }
            case 28: {
                result = new DynAny[]{new DynFixedImpl(this.m_factory, this.m_orb, tc)};
                break;
            }
            case 29: {
                TypeCode[] member_list = this.getValueMember(tc);
                result = new DynAny[member_list.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = this.create_dyn_any(member_list[i]);
                    ++i;
                }
                break;
            }
            case 30: {
                result = new DynAny[1];
                try {
                    result[0] = this.create_dyn_any(((TypeCodeBase)tc)._base_type().content_type());
                }
                catch (BadKind ex) {}
                break;
            }
        }
        return result;
    }

    protected DynAny[] copy_dyn_any_graph(DynAny[] src) {
        DynAny[] result = new DynAny[src.length];
        int i = 0;
        while (i < src.length) {
            result[i] = src[i].copy();
            ++i;
        }
        return result;
    }

    protected void dyn_any_to_stream(TypeCode tc, OutputStream stream) {
        switch (((TypeCodeBase)tc)._base_type().kind().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_short(this.m_any.extract_short());
                    break;
                }
                stream.write_short((short)0);
                break;
            }
            case 3: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_long(this.m_any.extract_long());
                    break;
                }
                stream.write_long(0);
                break;
            }
            case 23: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_longlong(this.m_any.extract_longlong());
                    break;
                }
                stream.write_longlong(0L);
                break;
            }
            case 4: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_ushort(this.m_any.extract_ushort());
                    break;
                }
                stream.write_ushort((short)0);
                break;
            }
            case 5: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_ulong(this.m_any.extract_ulong());
                    break;
                }
                stream.write_ulong(0);
                break;
            }
            case 24: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_ulonglong(this.m_any.extract_ulonglong());
                    break;
                }
                stream.write_ulonglong(0L);
                break;
            }
            case 6: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_float(this.m_any.extract_float());
                    break;
                }
                stream.write_float(0.0f);
                break;
            }
            case 7: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_double(this.m_any.extract_double());
                    break;
                }
                stream.write_double(0.0);
                break;
            }
            case 8: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_boolean(this.m_any.extract_boolean());
                    break;
                }
                stream.write_boolean(false);
                break;
            }
            case 9: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_char(this.m_any.extract_char());
                    break;
                }
                stream.write_char('\u0000');
                break;
            }
            case 26: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_wchar(this.m_any.extract_wchar());
                    break;
                }
                stream.write_wchar('\u0000');
                break;
            }
            case 10: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_octet(this.m_any.extract_octet());
                    break;
                }
                stream.write_octet((byte)0);
                break;
            }
            case 11: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_any(this.m_any.extract_any());
                    break;
                }
                stream.write_any(this.m_orb.create_any());
                break;
            }
            case 12: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_TypeCode(this.m_any.extract_TypeCode());
                    break;
                }
                stream.write_TypeCode(this.m_orb.get_primitive_tc(TCKind.tk_null));
                break;
            }
            case 14: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_Object(this.m_any.extract_Object());
                    break;
                }
                stream.write_Object(null);
                break;
            }
            case 18: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_string(this.m_any.extract_string());
                    break;
                }
                stream.write_string("");
                break;
            }
            case 27: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    stream.write_wstring(this.m_any.extract_wstring());
                    break;
                }
                stream.write_wstring("");
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                org.omg.CORBA.Any a = this.to_any();
                a.write_value(stream);
            }
        }
    }

    protected void dyn_any_graph_to_stream(DynAny[] src, OutputStream stream) {
        try {
            switch (((TypeCodeBase)this.m_type)._base_type().kind().value()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 18: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    ((DynBasicImpl)src[0]).dyn_any_to_stream(this.m_type, stream);
                    break;
                }
                case 16: {
                    ((DynAnyImpl)src[0]).dyn_any_to_stream(src[0].type(), stream);
                    ((DynAnyImpl)src[1]).dyn_any_to_stream(src[1].type(), stream);
                    break;
                }
                case 22: {
                    try {
                        stream.write_string(((TypeCodeBase)this.m_type)._base_type().id());
                    }
                    catch (BadKind ex) {
                        // empty catch block
                    }
                    int i = 0;
                    while (i < src.length) {
                        ((DynAnyImpl)src[i]).dyn_any_to_stream(src[i].type(), stream);
                        ++i;
                    }
                    break;
                }
                case 15: {
                    int i = 0;
                    while (i < src.length) {
                        ((DynAnyImpl)src[i]).dyn_any_to_stream(src[i].type(), stream);
                        ++i;
                    }
                    break;
                }
                case 17: {
                    ((DynEnumImpl)src[0]).dyn_any_to_stream(this.m_type, stream);
                    break;
                }
                case 28: {
                    ((DynFixedImpl)src[0]).dyn_any_to_stream(this.m_type, stream);
                    break;
                }
                case 20: {
                    int i = 0;
                    while (i < src.length) {
                        ((DynAnyImpl)src[i]).dyn_any_to_stream(src[i].type(), stream);
                        ++i;
                    }
                    break;
                }
                case 19: {
                    stream.write_ulong(src.length);
                    int i = 0;
                    while (i < src.length) {
                        ((DynAnyImpl)src[i]).dyn_any_to_stream(src[i].type(), stream);
                        ++i;
                    }
                    break;
                }
                case 29: {
                    int i = 0;
                    while (i < src.length) {
                        ((DynAnyImpl)src[i]).dyn_any_to_stream(src[i].type(), stream);
                        ++i;
                    }
                    break;
                }
                case 30: {
                    ((DynAnyImpl)src[0]).dyn_any_to_stream(src[0].type(), stream);
                }
            }
        }
        catch (Exception ex) {}
    }

    protected void stream_to_dyn_any(TypeCode tc, InputStream stream) {
        switch (((TypeCodeBase)tc)._base_type().kind().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.m_any.insert_short(stream.read_short());
                break;
            }
            case 3: {
                this.m_any.insert_long(stream.read_long());
                break;
            }
            case 23: {
                this.m_any.insert_longlong(stream.read_longlong());
                break;
            }
            case 4: {
                this.m_any.insert_ushort(stream.read_ushort());
                break;
            }
            case 5: {
                this.m_any.insert_ulong(stream.read_ulong());
                break;
            }
            case 24: {
                this.m_any.insert_ulonglong(stream.read_ulonglong());
                break;
            }
            case 6: {
                this.m_any.insert_float(stream.read_float());
                break;
            }
            case 7: {
                this.m_any.insert_double(stream.read_double());
                break;
            }
            case 8: {
                this.m_any.insert_boolean(stream.read_boolean());
                break;
            }
            case 9: {
                this.m_any.insert_char(stream.read_char());
                break;
            }
            case 26: {
                this.m_any.insert_wchar(stream.read_wchar());
                break;
            }
            case 10: {
                this.m_any.insert_octet(stream.read_octet());
                break;
            }
            case 11: {
                this.m_any.insert_any(stream.read_any());
                break;
            }
            case 12: {
                this.m_any.insert_TypeCode(stream.read_TypeCode());
                break;
            }
            case 14: {
                this.m_any.insert_Object(stream.read_Object());
                break;
            }
            case 18: {
                this.m_any.insert_string(stream.read_string());
                break;
            }
            case 27: {
                this.m_any.insert_wstring(stream.read_wstring());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                try {
                    this.m_any = (Any)this.m_orb.create_any();
                    this.m_any.read_value(stream, ((TypeCodeBase)tc)._base_type());
                    this.from_any(this.m_any);
                }
                catch (InvalidValue ex) {
                    this.getLogger().warn("read value from stream", ex);
                }
                catch (TypeMismatch ex) {
                    this.getLogger().warn("read value from stream", ex);
                }
                break;
            }
        }
        this.m_any.type(tc);
    }

    protected void stream_to_dyn_any_graph(DynAny[] src, InputStream stream) {
        switch (((TypeCodeBase)this.m_type)._base_type().kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                ((DynBasicImpl)src[0]).stream_to_dyn_any(this.m_type, stream);
                break;
            }
            case 16: {
                ((DynAnyImpl)src[0]).stream_to_dyn_any(src[0].type(), stream);
                org.omg.CORBA.Any an = ((DynAnyImpl)src[0]).to_any();
                TypeCodeBase t = ((TypeCodeBase)this.m_type)._base_type();
                boolean found = false;
                try {
                    int ll = 0;
                    while (ll < t.member_count()) {
                        if (an.equal(t.member_label(ll))) {
                            found = true;
                            if (src[1] != null && src[1].type().equals(t.member_type(ll))) break;
                            src[1] = this.create_dyn_any(t.member_type(ll));
                        }
                        ++ll;
                    }
                    if (!found) {
                        if (t.default_index() == -1) {
                            throw new MARSHAL();
                        }
                        src[1] = this.create_dyn_any(t.member_type(t.default_index()));
                    }
                }
                catch (BadKind ex) {
                }
                catch (Bounds ex) {
                    // empty catch block
                }
                ((DynAnyImpl)src[1]).stream_to_dyn_any(src[1].type(), stream);
                break;
            }
            case 22: {
                stream.read_string();
                int i = 0;
                while (i < src.length) {
                    ((DynAnyImpl)src[i]).stream_to_dyn_any(src[i].type(), stream);
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < src.length) {
                    ((DynAnyImpl)src[i]).stream_to_dyn_any(src[i].type(), stream);
                    ++i;
                }
                break;
            }
            case 28: {
                ((DynAnyImpl)src[0]).stream_to_dyn_any(this.m_type, stream);
                break;
            }
            case 17: {
                ((DynAnyImpl)src[0]).stream_to_dyn_any(this.m_type, stream);
                break;
            }
            case 20: {
                try {
                    this.read_array_from_stream(src, stream, src.length);
                }
                catch (InvalidValue ex) {
                    this.getLogger().warn("read_array_from_stream", ex);
                }
                catch (TypeMismatch ex) {
                    this.getLogger().warn("read_array_from_stream", ex);
                }
                break;
            }
            case 19: {
                int max = stream.read_ulong();
                try {
                    this.read_array_from_stream(src, stream, max);
                }
                catch (InvalidValue ex) {
                    this.getLogger().warn("read_array_from_stream", ex);
                }
                catch (TypeMismatch ex) {
                    this.getLogger().warn("read_array_from_stream", ex);
                }
                break;
            }
            case 29: {
                int i = 0;
                while (i < src.length) {
                    ((DynAnyImpl)src[i]).stream_to_dyn_any(src[i].type(), stream);
                    ++i;
                }
                break;
            }
            case 30: {
                ((DynAnyImpl)src[0]).stream_to_dyn_any(src[0].type(), stream);
            }
        }
    }

    public TypeCode[] getValueMember(TypeCode m_tc) {
        TypeCode[] ret = null;
        TypeCode[] tmp = null;
        try {
            if (m_tc.kind() == TCKind.tk_value) {
                if (m_tc.concrete_base_type().kind() != TCKind.tk_null) {
                    tmp = this.getValueMember(m_tc.concrete_base_type());
                    ret = new TypeCode[tmp.length + m_tc.member_count()];
                    int i = 0;
                    while (i < tmp.length) {
                        ret[i] = tmp[i];
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < m_tc.member_count()) {
                        ret[i2 + tmp.length] = m_tc.member_type(i2);
                        ++i2;
                    }
                } else {
                    ret = new TypeCode[m_tc.member_count()];
                    int i = 0;
                    while (i < m_tc.member_count()) {
                        ret[i] = m_tc.member_type(i);
                        ++i;
                    }
                }
            } else {
                ret = new TypeCode[]{m_tc.content_type()};
            }
        }
        catch (BadKind ex) {
        }
        catch (Bounds ex) {}
        return ret;
    }

    protected Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    private void read_array_from_stream(DynAny[] src, InputStream stream, int len) throws TypeMismatch, InvalidValue {
        if (len == 0) {
            return;
        }
        TypeCode tc = src[0].type();
        switch (((TypeCodeBase)tc)._base_type().kind().value()) {
            case 8: {
                boolean[] array = new boolean[len];
                stream.read_boolean_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_boolean(array[ii]);
                    ++ii;
                }
                break;
            }
            case 10: {
                byte[] array = new byte[len];
                stream.read_octet_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_octet(array[ii]);
                    ++ii;
                }
                break;
            }
            case 9: {
                char[] array = new char[len];
                stream.read_char_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_char(array[ii]);
                    ++ii;
                }
                break;
            }
            case 26: {
                char[] array = new char[len];
                stream.read_wchar_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_wchar(array[ii]);
                    ++ii;
                }
                break;
            }
            case 2: {
                short[] array = new short[len];
                stream.read_short_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_short(array[ii]);
                    ++ii;
                }
                break;
            }
            case 4: {
                short[] array = new short[len];
                stream.read_ushort_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_ushort(array[ii]);
                    ++ii;
                }
                break;
            }
            case 6: {
                float[] array = new float[len];
                stream.read_float_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_float(array[ii]);
                    ++ii;
                }
                break;
            }
            case 7: {
                double[] array = new double[len];
                stream.read_double_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_double(array[ii]);
                    ++ii;
                }
                break;
            }
            case 3: {
                int[] array = new int[len];
                stream.read_long_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_long(array[ii]);
                    ++ii;
                }
                break;
            }
            case 5: {
                int[] array = new int[len];
                stream.read_ulong_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_ulong(array[ii]);
                    ++ii;
                }
                break;
            }
            case 23: {
                long[] array = new long[len];
                stream.read_longlong_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_longlong(array[ii]);
                    ++ii;
                }
                break;
            }
            case 24: {
                long[] array = new long[len];
                stream.read_ulonglong_array(array, 0, len);
                int ii = 0;
                while (ii < len) {
                    src[ii].insert_ulonglong(array[ii]);
                    ++ii;
                }
                break;
            }
            default: {
                int ii = 0;
                while (ii < len) {
                    ((DynAnyImpl)src[ii]).stream_to_dyn_any(src[ii].type(), stream);
                    ++ii;
                }
                break block0;
            }
        }
    }
}

