/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.dynany;

import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynFixed;
import org.openorb.CORBA.dynany.DynAnyImpl;

public class DynFixedImpl
extends DynAnyImpl
implements DynFixed {
    private BigDecimal m_value;

    public DynFixedImpl(DynAnyFactory factory, ORB orb, TypeCode type) {
        super(factory, orb);
        this.m_type = type;
    }

    public void assign(DynAny dyn_any) throws TypeMismatch {
        if (!dyn_any.type().equivalent(this.m_type)) {
            throw new TypeMismatch();
        }
        this.m_value = ((DynFixedImpl)dyn_any).m_value;
    }

    public void from_any(Any value) throws InvalidValue, TypeMismatch {
        if (!value.type().equal(this.m_type)) {
            throw new TypeMismatch();
        }
        InputStream input = value.create_input_stream();
        this.m_value = input.read_fixed();
    }

    public Any to_any() {
        Any any = this.m_orb.create_any();
        any.type(this.m_type);
        OutputStream value = any.create_output_stream();
        value.write_fixed(this.m_value);
        return any;
    }

    public void destroy() {
    }

    public DynAny copy() {
        DynFixedImpl fixed = new DynFixedImpl(this.m_factory, this.m_orb, this.m_type);
        fixed.m_value = new BigDecimal(this.get_value());
        return fixed;
    }

    public DynAny current_component() {
        return this;
    }

    public boolean next() {
        return false;
    }

    public boolean seek(int index) {
        return index == 0;
    }

    public void rewind() {
    }

    public int component_count() {
        return 0;
    }

    public String get_value() {
        return this.m_value.toString();
    }

    public boolean set_value(String val) throws TypeMismatch, InvalidValue {
        boolean truncated = false;
        if (val.endsWith("D") || val.endsWith("d")) {
            val = val.substring(0, val.length() - 1);
        }
        String scale = val.substring(val.lastIndexOf("."), val.length());
        String digits = val.substring(0, val.lastIndexOf("."));
        try {
            if (scale.length() > this.m_type.fixed_scale()) {
                int delta = scale.length() - this.m_type.fixed_scale();
                val = val.substring(0, scale.length() - delta);
                truncated = true;
            }
            if (digits.length() > this.m_type.fixed_digits()) {
                throw new InvalidValue();
            }
            this.m_value = new BigDecimal(val);
        }
        catch (BadKind ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Trying to overwrite any value with String failed.", ex);
            }
            throw new TypeMismatch();
        }
        return !truncated;
    }
}

