/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.boa;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Contained;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ServantObject;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.PI.ComponentSet;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.IORUtil;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.adapter.TargetInfo;
import org.openorb.corbaloc.CorbalocService;
import org.openorb.corbaloc.CorbalocServiceHelper;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.util.RepoIDHelper;

public class BOA
extends org.omg.CORBA.BOA
implements ObjectAdapter {
    private static final byte[] PREFIX = "BOA".getBytes();
    private static short s_next_adapter = 0;
    private static final Policy[] NO_POLICIES = new Policy[0];
    private ServerManager m_server_manager;
    private ORB m_orb;
    private byte[][] m_aid_parts;
    private byte[] m_aid;
    private int m_next_target;
    private CorbalocService m_corbaloc_service;
    private ComponentSet m_comp_set;
    private Map m_targets = new HashMap();
    private Logger m_logger;
    static /* synthetic */ Class class$org$openorb$adapter$boa$BOA;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOA(ServerManager server_manager) {
        this.m_server_manager = server_manager;
        this.m_orb = server_manager.orb();
        this.m_aid_parts = new byte[2][];
        this.m_aid_parts[0] = PREFIX;
        Class clazz = class$org$openorb$adapter$boa$BOA == null ? (class$org$openorb$adapter$boa$BOA = BOA.class$("org.openorb.adapter.boa.BOA")) : class$org$openorb$adapter$boa$BOA;
        synchronized (clazz) {
            this.m_aid_parts[1] = new byte[2];
            this.m_aid_parts[1][0] = (byte)(s_next_adapter >>> 8);
            this.m_aid_parts[1][0] = (byte)s_next_adapter;
            s_next_adapter = (short)(s_next_adapter + 1);
        }
        byte[][] tmp_parts = new byte[this.m_aid_parts.length + 1][];
        System.arraycopy(this.m_aid_parts, 0, tmp_parts, 0, this.m_aid_parts.length);
        tmp_parts[this.m_aid_parts.length] = new byte[0];
        this.m_aid = server_manager.create_cacheable_object_key(true, tmp_parts);
        server_manager.register_adapter(this.m_aid, this);
    }

    public void connect(ObjectImpl obj) {
        this.connect(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ObjectImpl obj, boolean activate) {
        try {
            if (obj._get_delegate() != null) {
                return;
            }
        }
        catch (BAD_OPERATION ex) {
            // empty catch block
        }
        byte[] byArray = this.m_aid;
        synchronized (this.m_aid) {
            BOAEntry entry = new BOAEntry(this.m_aid, this.m_next_target++);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            entry.setState(activate);
            entry.setTarget(obj);
            byte[][] oid_parts = new byte[][]{this.m_aid_parts[0], this.m_aid_parts[1], new byte[4]};
            int hc = entry.getId();
            oid_parts[2] = entry.getObjectID();
            byte[] object_key = this.m_server_manager.create_cacheable_object_key(false, oid_parts);
            if (this.m_comp_set == null) {
                this.m_comp_set = new ComponentSet(this.m_orb, null, null);
                this.m_comp_set.interception_point();
            }
            IOR ior = IORUtil.construct_ior(obj._ids()[0], object_key, this.m_comp_set, this.m_server_manager.get_protocol_ids(), this.m_orb);
            Delegate deleg = new Delegate(this.m_orb, ior);
            obj._set_delegate(deleg);
            Map map = this.m_targets;
            synchronized (map) {
                this.m_targets.put(new Integer(entry.getId()), entry);
            }
            return;
        }
    }

    public void connect(ObjectImpl obj, String name) {
        if (this.m_corbaloc_service == null) {
            try {
                this.m_corbaloc_service = CorbalocServiceHelper.narrow(this.m_orb.resolve_initial_references("CorbalocService"));
            }
            catch (InvalidName ex) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Could not resolve CorbalocService.", ex);
                }
                throw new INITIALIZE("Could not resolve CorbalocService (" + ex + ")");
            }
        }
        this.connect(obj);
        this.m_corbaloc_service.put(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ObjectImpl objOld, ObjectImpl objNew) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry key = this.find_entry(objOld);
            if (key != null) {
                objOld._set_delegate(objNew._get_delegate());
                key.setTarget(objNew);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(ObjectImpl obj) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry entry = this.find_entry(obj);
            if (entry != null) {
                this.m_targets.remove(new Integer(entry.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obj_is_ready(ObjectImpl obj) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry entry = this.find_entry(obj);
            if (entry != null) {
                entry.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate_obj(ObjectImpl obj) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry entry = this.find_entry(obj);
            if (entry != null) {
                entry.deactivate();
            }
        }
    }

    public void impl_is_ready() {
        this.m_server_manager.register_adapter(this.m_aid, this);
        this.m_orb.run();
    }

    public void deactivate_impl() {
        this.m_server_manager.unregister_adapter(this.m_aid);
    }

    public int cache_priority() {
        return 0;
    }

    public boolean single_threaded() {
        return false;
    }

    public void etherealize(boolean cleanup_in_progress) {
    }

    public ServerManager.AdapterManager getAdapterManager() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter find_adapter(byte[] object_key) throws AdapterDestroyedException {
        Map map = this.m_targets;
        synchronized (map) {
            if (this.find_entry(object_key) == null) {
                return null;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] adapter_id(byte[] object_key) {
        Map map = this.m_targets;
        synchronized (map) {
            if (this.find_entry(object_key) == null) {
                return null;
            }
        }
        return this.m_aid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] object_id(byte[] object_key) {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry entry = this.find_entry(object_key);
            if (entry == null) {
                return null;
            }
            return entry.getObjectID();
        }
    }

    public Policy[] get_server_policies(int[] ts) {
        return NO_POLICIES;
    }

    public boolean forced_marshal(byte[] object_key) throws AdapterDestroyedException {
        return false;
    }

    public ServantObject servant_preinvoke(byte[] object_key, String operation, Class expectedType) throws ForwardRequest, AdapterDestroyedException {
        ServantObject ret = new ServantObject();
        ret.servant = this.find_target(object_key);
        return ret;
    }

    public void servant_postinvoke(byte[] object_key, ServantObject srvObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locate(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        Map map = this.m_targets;
        synchronized (map) {
            BOAEntry entry = this.find_entry(object_key);
            return entry != null && entry.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is_a(byte[] object_key, String repository_id) throws ForwardRequest, AdapterDestroyedException {
        BOAEntry entry;
        Map map = this.m_targets;
        synchronized (map) {
            entry = this.find_entry(object_key);
            if (entry == null) {
                this.find_target(object_key);
            }
        }
        return entry.targetIsA(repository_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get_interface_def(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        String repo_id;
        Map map = this.m_targets;
        synchronized (map) {
            repo_id = this.find_target(object_key)._ids()[0];
        }
        return this.get_interface_def(repo_id);
    }

    private Object get_interface_def(String repository_id) {
        Repository rep;
        Object obj;
        try {
            obj = this.m_orb.resolve_initial_references("InterfaceRepository");
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Could not resolve InterfaceRepository.", ex);
            }
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        if (obj == null) {
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        try {
            rep = RepositoryHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Could not narrow obj to type Repository.", ex);
            }
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        Contained interface_def = rep.lookup_id(repository_id);
        if (interface_def == null) {
            throw new INTF_REPOS(1146056720, CompletionStatus.COMPLETED_NO);
        }
        return interface_def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainManager[] get_domain_managers(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        BOAEntry entry;
        Map map = this.m_targets;
        synchronized (map) {
            entry = this.find_entry(object_key);
            if (entry == null) {
                this.find_target(object_key);
            }
        }
        return this.lookup_domain_managers(entry);
    }

    private DomainManager[] lookup_domain_managers(BOAEntry entry) {
        return new DomainManager[0];
    }

    public Object get_component(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        return this.target_get_component(this.find_target(object_key));
    }

    private Object target_get_component(ObjectImpl target) {
        throw new NO_IMPLEMENT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetInfo predispatch(ServerRequest req) throws ForwardRequest, AdapterDestroyedException {
        BOAEntry entry;
        Map map = this.m_targets;
        synchronized (map) {
            entry = this.find_entry(req.object_key());
            if (entry == null) {
                this.find_target(req.object_key());
            }
        }
        return entry;
    }

    public void dispatch(ServerRequest req, TargetInfo target) {
        ObjectImpl impl;
        if (req.is_locate()) {
            return;
        }
        String operation = req.operation();
        if (operation.charAt(0) == '_') {
            if (operation.equals("_is_a")) {
                String repo_id = req.argument_stream().read_string();
                req.createReply().write_boolean(target.targetIsA(repo_id));
                return;
            }
            if (operation.equals("_get_domain_managers")) {
                req.argument_stream();
                DomainManagersListHelper.write(req.createReply(), this.lookup_domain_managers((BOAEntry)target));
                return;
            }
            if (operation.equals("_interface")) {
                req.argument_stream();
                req.createReply().write_Object(this.get_interface_def(target.getRepositoryID()));
                return;
            }
            if (operation.equals("_non_existent") || operation.equals("_not_existent")) {
                req.argument_stream();
                req.createReply().write_boolean(false);
            } else if (operation.equals("_component")) {
                req.argument_stream();
                req.createReply().write_Object(this.target_get_component(((BOAEntry)target).getTarget()));
                return;
            }
        }
        if ((impl = ((BOAEntry)target).getTarget()) instanceof InvokeHandler) {
            ((InvokeHandler)((java.lang.Object)impl))._invoke(operation, req.argument_stream(), req);
        } else if (impl instanceof DynamicImplementation) {
            org.openorb.CORBA.dsi.ServerRequest dsr = new org.openorb.CORBA.dsi.ServerRequest(req);
            ((DynamicImplementation)impl).invoke(dsr);
            if (req.state() == 3) {
                dsr.set_result(this.m_orb.create_any());
            }
        }
    }

    public void cancel_dispatch(ServerRequest req, TargetInfo target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectImpl find_target(byte[] object_key) {
        Map map = this.m_targets;
        synchronized (map) {
            byte[][] parts = this.m_server_manager.extract_cacheable_object_key(object_key);
            if (this.m_aid_parts.length != parts.length - 1) {
                throw new OBJ_ADAPTER(0, CompletionStatus.COMPLETED_NO);
            }
            int i = 0;
            while (i < this.m_aid_parts.length) {
                if (!Arrays.equals(this.m_aid_parts[i], parts[i])) {
                    throw new OBJ_ADAPTER(0, CompletionStatus.COMPLETED_NO);
                }
                ++i;
            }
            byte[] object_id = parts[parts.length - 1];
            Integer key = new Integer((object_id[0] & 0xFF) << 24 | (object_id[1] & 0xFF) << 16 | (object_id[2] & 0xFF) << 8 | object_id[3] & 0xFF);
            BOAEntry entry = (BOAEntry)this.m_targets.get(key);
            if (entry == null || !entry.getState()) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            return entry.getTarget();
        }
    }

    private BOAEntry find_entry(byte[] object_key) {
        byte[][] parts = this.m_server_manager.extract_cacheable_object_key(object_key);
        if (parts.length != this.m_aid_parts.length + 1) {
            return null;
        }
        int i = 0;
        while (i < this.m_aid_parts.length) {
            if (!Arrays.equals(this.m_aid_parts[i], parts[i])) {
                return null;
            }
            ++i;
        }
        byte[] object_id = parts[this.m_aid_parts.length];
        Integer key = new Integer((object_id[0] & 0xFF) << 24 | (object_id[1] & 0xFF) << 16 | (object_id[2] & 0xFF) << 8 | object_id[3] & 0xFF);
        return (BOAEntry)this.m_targets.get(key);
    }

    private BOAEntry find_entry(ObjectImpl obj) {
        Iterator itt = this.m_targets.values().iterator();
        while (itt.hasNext()) {
            BOAEntry entry = (BOAEntry)itt.next();
            if (entry.getTarget() != obj) continue;
            return entry;
        }
        return null;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BOAEntry
    implements TargetInfo {
        private byte[] m_adapter_id;
        private byte[] m_object_id;
        private int m_id;
        private boolean m_active;
        private ObjectImpl m_target;

        BOAEntry(byte[] adapter_id, int id) {
            this.m_id = id;
            this.m_object_id = new byte[4];
            this.m_object_id[0] = (byte)(id >>> 24);
            this.m_object_id[1] = (byte)(id >>> 16);
            this.m_object_id[2] = (byte)(id >>> 8);
            this.m_object_id[3] = (byte)id;
            this.m_adapter_id = adapter_id;
        }

        public int getId() {
            return this.m_id;
        }

        public boolean getState() {
            return this.m_active;
        }

        public void setState(boolean active) {
            this.m_active = active;
        }

        public void activate() {
            this.m_active = true;
        }

        public void deactivate() {
            this.m_active = false;
        }

        public ObjectImpl getTarget() {
            return this.m_target;
        }

        public void setTarget(ObjectImpl target) {
            this.m_target = target;
        }

        public String getRepositoryID() {
            return this.m_target._ids()[0];
        }

        public boolean targetIsA(String id) {
            java.lang.Object test = RepoIDHelper.createIsATest(id);
            if (test.equals("IDL:omg.org/CORBA/Object:1.0")) {
                return true;
            }
            String[] ids = this.m_target._ids();
            int i = 0;
            while (i < ids.length) {
                if (test.equals(ids[i])) {
                    return true;
                }
                ++i;
            }
            return this.m_target._is_a(id);
        }

        public byte[] getAdapterID() {
            return this.m_adapter_id;
        }

        public byte[] getObjectID() {
            return this.m_object_id;
        }
    }
}

