/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Contained;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.adapter.poa.CurrentImpl;
import org.openorb.adapter.poa.DispatchState;
import org.openorb.util.ExceptionTool;
import org.openorb.util.JREVersion;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

class DelegateImpl
implements Delegate {
    private ORB m_orb;
    private CurrentImpl m_curr;
    private POA m_rootPOA;
    private Logger m_logger;

    public DelegateImpl(ORB orb) {
        this.m_orb = orb;
    }

    public void init() {
        try {
            this.m_curr = (CurrentImpl)this.m_orb.resolve_initial_references("POACurrent");
            this.m_rootPOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName ex) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Unable to initialize POA delegate.", ex);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize POA delegate (" + ex + ")"), (Throwable)ex);
        }
        catch (ClassCastException ex) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Unable to initialize POA delegate.", ex);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize POA delegate (" + ex + ")"), (Throwable)ex);
        }
    }

    public ORB orb(Servant self) {
        return this.m_orb;
    }

    public Object this_object(Servant self) {
        byte[] object_id;
        POA poa;
        block10: {
            poa = null;
            object_id = null;
            try {
                DispatchState state = this.m_curr.peek();
                if (state.getServant() == self) {
                    poa = state.getPoa();
                    object_id = state.getObjectID();
                }
            }
            catch (NoContext ex) {
                if (JREVersion.V1_4 || !this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block10;
                this.getLogger().debug("No context available.", ex);
            }
        }
        if (poa == null) {
            poa = self._default_POA();
            if (poa == null) {
                throw new OBJ_ADAPTER();
            }
            try {
                object_id = poa.servant_to_id(self);
            }
            catch (ServantNotActive ex) {
                if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("The servant is not active yet.", ex);
                }
                throw ExceptionTool.initCause(new OBJ_ADAPTER(), (Throwable)ex);
            }
            catch (WrongPolicy ex) {
                if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("The servant has a wrong policy.", ex);
                }
                throw ExceptionTool.initCause(new OBJ_ADAPTER(), (Throwable)ex);
            }
        }
        String[] ids = self._all_interfaces(poa, object_id);
        return poa.create_reference_with_id(object_id, ids[0]);
    }

    public POA poa(Servant self) {
        block3: {
            try {
                DispatchState state = this.m_curr.peek();
                if (state.getServant() == self) {
                    return state.getPoa();
                }
                Trace.signalIllegalCondition(this.getLogger(), "No Context, i.e. state.getServant() != self");
            }
            catch (NoContext ex) {
                if (JREVersion.V1_4 || !this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block3;
                this.getLogger().debug("No context available for servant " + self, ex);
            }
        }
        throw new OBJ_ADAPTER("No Context");
    }

    public byte[] object_id(Servant self) {
        block3: {
            try {
                DispatchState state = this.m_curr.peek();
                if (state.getServant() == self) {
                    return state.getObjectID();
                }
                Trace.signalIllegalCondition(this.getLogger(), "No Context, i.e. state.getServant() != self");
            }
            catch (NoContext ex) {
                if (JREVersion.V1_4 || !this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block3;
                this.getLogger().debug("No context available.", ex);
            }
        }
        throw new OBJ_ADAPTER("No Context");
    }

    public POA default_POA(Servant self) {
        return this.m_rootPOA;
    }

    public boolean is_a(Servant self, String id) {
        java.lang.Object test = RepoIDHelper.createIsATest(id);
        if (test.equals("IDL:omg.org/CORBA/Object:1.0")) {
            return true;
        }
        String[] ids = self._all_interfaces(this.poa(self), this.object_id(self));
        int i = 0;
        while (i < ids.length) {
            if (test.equals(ids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean non_existent(Servant self) {
        return false;
    }

    public InterfaceDef get_interface(Servant self) {
        try {
            return InterfaceDefHelper.narrow(this.get_interface_def(self));
        }
        catch (BAD_PARAM ex) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Could not narrow obj to type InterfaceDef.", ex);
            }
            throw ExceptionTool.initCause(new INTF_REPOS(1146056721, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
    }

    public Object get_interface_def(Servant self) {
        Repository rep;
        Object obj;
        String repository_id = self._all_interfaces(this.poa(self), this.object_id(self))[0];
        try {
            obj = this.m_orb.resolve_initial_references("InterfaceRepository");
        }
        catch (InvalidName ex) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Could not resolve InterfaceRepository.", ex);
            }
            throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        if (obj._non_existent()) {
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        try {
            rep = RepositoryHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Could not narrow obj to type Repository.", ex);
            }
            throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        Contained interface_def = rep.lookup_id(repository_id);
        if (interface_def == null) {
            throw new INTF_REPOS(1146056720, CompletionStatus.COMPLETED_NO);
        }
        return interface_def;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

