/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.HexPrintStream;

public final class CodeSet {
    private final int m_id;
    private final String m_canonical;
    private final String m_name;
    private final String m_description;
    private final short[] m_charsets;
    private final int m_maxSize;
    private final int m_alignment;
    private final boolean m_server;

    public CodeSet(String description, int id, short[] charsets, int maxSize, String canonical, String name, int alignment, boolean server) {
        this.m_description = description;
        this.m_id = id;
        this.m_charsets = charsets;
        this.m_maxSize = maxSize;
        this.m_canonical = canonical;
        this.m_name = name;
        this.m_alignment = alignment;
        this.m_server = server;
    }

    public int getId() {
        return this.m_id;
    }

    public String getCanonicalName() {
        return this.m_canonical;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public short[] getCharsets() {
        return this.m_charsets;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public int getAlignment() {
        return this.m_alignment;
    }

    public boolean forServer() {
        return this.m_server;
    }

    public String toString() {
        String ret = "\"" + this.m_description + "\", 0x" + HexPrintStream.toHex(this.m_id) + ", new short [] { ";
        int i = 0;
        while (i < this.m_charsets.length) {
            ret = ret + "0x" + HexPrintStream.toHex(this.m_charsets[i]);
            if (i < this.m_charsets.length - 1) {
                ret = ret + ", ";
            }
            ++i;
        }
        ret = ret + " } ," + this.m_maxSize + ", \"" + this.m_canonical + "\", \"" + this.m_name + "\", " + this.m_alignment + ", " + this.m_server;
        return ret;
    }

    public boolean isCompatibleTo(CodeSet to_comp) {
        return CodeSet.compatible(this, to_comp);
    }

    public static boolean compatible(int csA, int csB) {
        CodeSet entryA = CodeSetDatabase.getCodeSetFromId(csA);
        CodeSet entryB = CodeSetDatabase.getCodeSetFromId(csB);
        if (entryA == null || entryB == null) {
            return false;
        }
        return CodeSet.compatible(entryA, entryB);
    }

    public static boolean compatible(CodeSet entryA, CodeSet entryB) {
        if (entryA.getCharsets().length >= 1) {
            return entryB.getCharsets().length == 1 && entryA.getCharsets()[0] == entryB.getCharsets()[0];
        }
        if (entryB.getCharsets().length == 1) {
            return false;
        }
        boolean found = false;
        int i = 0;
        int j = 0;
        while (i < entryA.getCharsets().length && j < entryB.getCharsets().length) {
            if (entryA.getCharsets()[i] == entryB.getCharsets()[j]) {
                if (found) {
                    return true;
                }
                found = true;
                ++i;
                ++j;
                continue;
            }
            if (entryA.getCharsets()[i] < entryB.getCharsets()[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return false;
    }
}

