/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.DataInputStream;
import org.openorb.CORBA.DataOutputStream;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.ListOutputStream;
import org.openorb.io.TypeCodeValueBoxHelper;
import org.openorb.util.ExceptionTool;
import org.openorb.util.RepoIDHelper;

public class ListInputStream
extends InputStream
implements ExtendedInputStream {
    private List m_source;
    private ListIterator m_iter = null;
    private int m_iter_pos = 0;
    private int m_mark_pos = 0;
    private ORB m_orb;
    private Logger m_logger = null;

    public ListInputStream(ORB orb, List source) {
        this.m_source = source;
        this.m_orb = orb;
    }

    public ORB orb() {
        return this.m_orb;
    }

    public String get_codebase() {
        return null;
    }

    private List getSource() {
        return this.m_source;
    }

    private List getSourceTail() {
        return this.m_source.subList(this.m_iter_pos, this.m_source.size());
    }

    private int getIndex() {
        return this.m_iter_pos;
    }

    private void setIndex(int index) {
        if (index > this.m_source.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m_iter_pos = index;
        this.m_iter = null;
    }

    public int getSourceSize() {
        return this.m_source.size();
    }

    public int skip() {
        throw new NO_IMPLEMENT();
    }

    public int available() {
        throw new NO_IMPLEMENT();
    }

    public boolean markAvailable() {
        return true;
    }

    public void mark(int ign) {
        this.m_mark_pos = this.m_iter_pos;
    }

    public void reset() {
        this.m_iter_pos = this.m_mark_pos;
        this.m_iter = null;
    }

    private SystemException reportBufferPositionOfFormatProblem(Throwable cause) {
        this.getLogger().error("Buffer position or format problem.", cause);
        return ExceptionTool.initCause(new MARSHAL("Buffer position or format problem (" + cause + ")", 1146056728, CompletionStatus.COMPLETED_MAYBE), cause);
    }

    private SystemException reportOverreadListStream(Throwable cause) {
        this.getLogger().warn("Overread on list stream.", cause);
        return ExceptionTool.initCause(new MARSHAL("Overread on list stream (" + cause + ")", 1146056726, CompletionStatus.COMPLETED_MAYBE), cause);
    }

    /*
     * Loose catch block
     */
    private java.lang.Object next() {
        while (true) {
            try {
                if (this.m_iter == null) {
                    this.m_iter = this.m_source.listIterator(this.m_iter_pos);
                }
                java.lang.Object n = this.m_iter.next();
                ++this.m_iter_pos;
                return n;
            }
            catch (ConcurrentModificationException ex) {
                this.getLogger().warn("error in next()", ex);
                this.m_iter = null;
                continue;
            }
            catch (NoSuchElementException ex) {
                throw this.reportOverreadListStream(ex);
            }
            break;
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.reportOverreadListStream(ex);
        }
    }

    private java.lang.Object peek() {
        try {
            return this.m_source.get(this.m_iter_pos);
        }
        catch (NoSuchElementException ex) {
            throw this.reportOverreadListStream(ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw this.reportOverreadListStream(ex);
        }
    }

    TypeCodeValueBoxHelper read_value_box() {
        try {
            if ((TCKind)this.next() != TCKind.tk_value_box) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            return (TypeCodeValueBoxHelper)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    private void read_array(java.lang.Object dest, int off, int len, TCKind typecode) {
        try {
            if ((TCKind)this.next() != TCKind.tk_array) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            ListOutputStream.ArrayBlock src = (ListOutputStream.ArrayBlock)this.next();
            if (src.getContentKind() != typecode) {
                throw new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
            }
            if (src.getLength() != len) {
                throw new MARSHAL("Bounds mismatch", 1146056725, CompletionStatus.COMPLETED_MAYBE);
            }
            System.arraycopy(src.getContents(), src.getOffset(), dest, off, len);
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
        catch (ArrayStoreException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    private SystemException reportTypeMismatch() {
        return new MARSHAL("Type mismatch", 1146056724, CompletionStatus.COMPLETED_MAYBE);
    }

    public boolean read_boolean() {
        try {
            if ((TCKind)this.next() != TCKind.tk_boolean) {
                throw this.reportTypeMismatch();
            }
            return (Boolean)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_boolean_array(boolean[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_boolean);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_boolean();
                ++ii;
            }
        }
    }

    public byte read_octet() {
        try {
            if ((TCKind)this.next() != TCKind.tk_octet) {
                throw this.reportTypeMismatch();
            }
            return (Byte)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_octet_array(byte[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_octet);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_octet();
                ++ii;
            }
        }
    }

    public short read_short() {
        try {
            if ((TCKind)this.next() != TCKind.tk_short) {
                throw this.reportTypeMismatch();
            }
            return (Short)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_short_array(short[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_short);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_short();
                ++ii;
            }
        }
    }

    public short read_ushort() {
        try {
            if ((TCKind)this.next() != TCKind.tk_ushort) {
                throw this.reportTypeMismatch();
            }
            return (Short)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_ushort_array(short[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_ushort);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_ushort();
                ++ii;
            }
        }
    }

    public int read_long() {
        try {
            TCKind next = (TCKind)this.next();
            if (next != TCKind.tk_ulong) {
                throw this.reportTypeMismatch();
            }
            return (Integer)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_long_array(int[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_long);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_long();
                ++ii;
            }
        }
    }

    public int read_ulong() {
        try {
            TCKind next = (TCKind)this.next();
            if (next != TCKind.tk_ulong) {
                throw this.reportTypeMismatch();
            }
            return (Integer)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_ulong_array(int[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_ulong);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_ulong();
                ++ii;
            }
        }
    }

    public long read_longlong() {
        try {
            if ((TCKind)this.next() != TCKind.tk_longlong) {
                throw this.reportTypeMismatch();
            }
            return (Long)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_longlong_array(long[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_longlong);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_longlong();
                ++ii;
            }
        }
    }

    public long read_ulonglong() {
        try {
            if ((TCKind)this.next() != TCKind.tk_ulonglong) {
                throw this.reportTypeMismatch();
            }
            return (Long)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_ulonglong_array(long[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_ulonglong);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_ulonglong();
                ++ii;
            }
        }
    }

    public char read_char() {
        try {
            if ((TCKind)this.next() != TCKind.tk_char) {
                throw this.reportTypeMismatch();
            }
            return ((Character)this.next()).charValue();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_char_array(char[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_char);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_char();
                ++ii;
            }
        }
    }

    public char read_wchar() {
        try {
            if ((TCKind)this.next() != TCKind.tk_wchar) {
                throw this.reportTypeMismatch();
            }
            return ((Character)this.next()).charValue();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_wchar_array(char[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_wchar);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_wchar();
                ++ii;
            }
        }
    }

    public float read_float() {
        try {
            if ((TCKind)this.next() != TCKind.tk_float) {
                throw this.reportTypeMismatch();
            }
            return ((Float)this.next()).floatValue();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_float_array(float[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_float);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_float();
                ++ii;
            }
        }
    }

    public double read_double() {
        try {
            if ((TCKind)this.next() != TCKind.tk_double) {
                throw this.reportTypeMismatch();
            }
            return (Double)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public void read_double_array(double[] dest, int off, int len) {
        if (this.peek() == TCKind.tk_array) {
            this.read_array(dest, off, len, TCKind.tk_double);
        } else {
            int ii = 0;
            while (ii < len) {
                dest[off + ii] = this.read_double();
                ++ii;
            }
        }
    }

    public String read_string() {
        try {
            if ((TCKind)this.next() != TCKind.tk_string) {
                throw this.reportTypeMismatch();
            }
            return (String)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public String read_wstring() {
        try {
            if ((TCKind)this.next() != TCKind.tk_wstring) {
                throw this.reportTypeMismatch();
            }
            return (String)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public Object read_Object() {
        try {
            if ((TCKind)this.next() != TCKind.tk_objref) {
                throw this.reportTypeMismatch();
            }
            return (Object)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public Object read_Object(Class clz) {
        ObjectImpl ret;
        ObjectImpl src;
        try {
            if ((TCKind)this.next() != TCKind.tk_objref) {
                throw this.reportTypeMismatch();
            }
            java.lang.Object n = this.next();
            if (n == null || clz.isInstance(n)) {
                return (Object)n;
            }
            src = (ObjectImpl)n;
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
        try {
            ret = (ObjectImpl)clz.newInstance();
        }
        catch (Exception ex) {
            this.getLogger().error("Bad object type.", ex);
            throw ExceptionTool.initCause(new BAD_PARAM("Bad object type (" + ex + ")", 1146056711, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
        ret._set_delegate(src._get_delegate());
        return ret;
    }

    public TypeCode read_TypeCode() {
        try {
            if ((TCKind)this.next() != TCKind.tk_TypeCode) {
                throw this.reportTypeMismatch();
            }
            return (TypeCode)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public Any read_any() {
        try {
            TCKind tc = (TCKind)this.next();
            if (tc == TCKind.tk_any) {
                return (Any)this.next();
            }
            if (tc == TCKind.tk_TypeCode) {
                Any any = this.m_orb.create_any();
                any.read_value(this, (TypeCode)this.next());
                return any;
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public Context read_Context() {
        NVList nv = this.m_orb.create_list(0);
        int max = this.read_ulong() / 2;
        int i = 0;
        while (i < max) {
            Any a = this.m_orb.create_any();
            String name = this.read_string();
            a.insert_string(this.read_string());
            nv.add_value(name, a, 0);
            ++i;
        }
        org.openorb.CORBA.dii.Context context = new org.openorb.CORBA.dii.Context("", null, this.m_orb);
        ((Context)context).set_values(nv);
        return context;
    }

    public Principal read_Principal() {
        try {
            if ((TCKind)this.next() != TCKind.tk_Principal) {
                throw this.reportTypeMismatch();
            }
            return (Principal)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public BigDecimal read_fixed() {
        try {
            if ((TCKind)this.next() != TCKind.tk_fixed) {
                throw this.reportTypeMismatch();
            }
            return (BigDecimal)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public BigDecimal read_fixed(TypeCode type) {
        try {
            return this.read_fixed(type.fixed_digits(), type.fixed_scale());
        }
        catch (BadKind ex) {
            this.getLogger().error("Type mismatch with fixed type.", ex);
            throw ExceptionTool.initCause(new BAD_PARAM("Type mismatch with fixed type (" + ex + ")", 1146056712, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
    }

    public BigDecimal read_fixed(short digits, short scale) {
        BigDecimal ret;
        try {
            if ((TCKind)this.next() != TCKind.tk_fixed) {
                throw this.reportTypeMismatch();
            }
            ret = (BigDecimal)this.next();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
        String strrep = ret.toString();
        int strlen = strrep.length();
        if (strrep.charAt(0) == '-') {
            --strlen;
        }
        if (strrep.indexOf(46) >= 0) {
            --strlen;
        }
        if (strlen > digits) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
        if (ret.scale() != scale) {
            throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
        }
        return ret;
    }

    public Serializable read_value() {
        try {
            TCKind type = (TCKind)this.next();
            if (type == TCKind.tk_value) {
                return (Serializable)this.next();
            }
            if (type == TCKind.tk_value_box) {
                BoxedValueHelper boxhelp = (BoxedValueHelper)this.next();
                return boxhelp.read_value(this);
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    private SystemException reportBadObjectType() {
        return new BAD_PARAM("Bad object type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
    }

    public Serializable read_value(String rep_id) {
        try {
            TCKind type = (TCKind)this.next();
            if (type == TCKind.tk_value) {
                Serializable val = (Serializable)this.next();
                if (val != null) {
                    Class<?> clz = null;
                    try {
                        clz = Thread.currentThread().getContextClassLoader().loadClass(RepoIDHelper.idToClass(rep_id));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (clz != null && !clz.isInstance(val)) {
                        throw this.reportBadObjectType();
                    }
                }
                return val;
            }
            if (type == TCKind.tk_value_box) {
                BoxedValueHelper boxhelp = (BoxedValueHelper)this.next();
                if (!boxhelp.get_id().equals(rep_id)) {
                    throw this.reportBadObjectType();
                }
                return boxhelp.read_value(this);
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public Serializable read_value(Class clz) {
        Serializable val;
        block5: {
            try {
                TCKind type = (TCKind)this.next();
                if (type == TCKind.tk_value) {
                    val = (Serializable)this.next();
                    break block5;
                }
                if (type == TCKind.tk_value_box) {
                    BoxedValueHelper boxhelp = (BoxedValueHelper)this.next();
                    val = boxhelp.read_value(this);
                    break block5;
                }
                throw this.reportTypeMismatch();
            }
            catch (ClassCastException ex) {
                throw this.reportBufferPositionOfFormatProblem(ex);
            }
        }
        if (clz != null && val != null && !clz.isInstance(val)) {
            throw this.reportBadObjectType();
        }
        return val;
    }

    public Serializable read_value(BoxedValueHelper factory) {
        try {
            if ((TCKind)this.next() != TCKind.tk_value_box) {
                throw this.reportTypeMismatch();
            }
            BoxedValueHelper boxhelp = (BoxedValueHelper)this.next();
            if (!boxhelp.get_id().equals(factory.get_id())) {
                throw new BAD_PARAM("Bad factory type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
            }
            return factory.read_value(this);
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public Serializable read_value(Serializable value) {
        try {
            if ((TCKind)this.next() != TCKind.tk_value) {
                throw this.reportTypeMismatch();
            }
            if (value instanceof CustomValue) {
                CustomValue src = (CustomValue)this.next();
                CustomValue dst = (CustomValue)value;
                if (!src._truncatable_ids()[0].equals(dst._truncatable_ids()[0])) {
                    throw new BAD_PARAM("Bad target type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                OutputStream os = (OutputStream)this.m_orb.create_output_stream();
                src.marshal(new DataOutputStream(os));
                dst.unmarshal(new DataInputStream(os.create_input_stream()));
                return dst;
            }
            if (value instanceof StreamableValue) {
                StreamableValue src = (StreamableValue)this.next();
                StreamableValue dst = (StreamableValue)value;
                String[] srcids = src._truncatable_ids();
                String dstid = dst._truncatable_ids()[0];
                int i = 0;
                while (i < srcids.length) {
                    if (srcids[i].equals(dstid)) {
                        srcids = null;
                        break;
                    }
                    ++i;
                }
                if (srcids != null) {
                    throw new BAD_PARAM("Bad target type", 1146056713, CompletionStatus.COMPLETED_MAYBE);
                }
                OutputStream os = (OutputStream)this.m_orb.create_output_stream();
                src._write(os);
                dst._read(os.create_input_stream());
                return dst;
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public java.lang.Object read_abstract_interface() {
        try {
            if ((TCKind)this.next() != TCKind.tk_abstract_interface) {
                throw this.reportTypeMismatch();
            }
            TCKind type = (TCKind)this.peek();
            if (type == TCKind.tk_objref) {
                return this.read_Object();
            }
            if (type == TCKind.tk_value) {
                return this.read_value();
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    public java.lang.Object read_abstract_interface(Class clz) {
        try {
            if ((TCKind)this.next() != TCKind.tk_abstract_interface) {
                throw this.reportTypeMismatch();
            }
            TCKind type = (TCKind)this.peek();
            if (type == TCKind.tk_objref) {
                return this.read_Object(clz);
            }
            if (type == TCKind.tk_value) {
                return this.read_value(clz);
            }
            throw this.reportTypeMismatch();
        }
        catch (ClassCastException ex) {
            throw this.reportBufferPositionOfFormatProblem(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(java.lang.Object obj) {
        boolean bl;
        ListInputStream lis2;
        block25: {
            boolean bl2;
            block16: {
                boolean bl3;
                block24: {
                    boolean bl4;
                    block23: {
                        boolean bl5;
                        block22: {
                            boolean bl6;
                            block21: {
                                boolean bl7;
                                block20: {
                                    boolean bl8;
                                    block19: {
                                        boolean bl9;
                                        block18: {
                                            boolean bl10;
                                            block17: {
                                                if (obj instanceof OutputStream) {
                                                    return this.equals(((OutputStream)obj).create_input_stream());
                                                }
                                                if (!(obj instanceof ListInputStream)) {
                                                    return false;
                                                }
                                                lis2 = (ListInputStream)obj;
                                                if (this.m_source.size() - this.m_iter_pos != lis2.m_source.size() - lis2.m_iter_pos) {
                                                    return false;
                                                }
                                                this.mark(0);
                                                lis2.mark(0);
                                                try {
                                                    block15: {
                                                        while (true) {
                                                            ListOutputStream os2;
                                                            ListOutputStream os1;
                                                            java.lang.Object o2;
                                                            if (this.m_iter_pos >= this.m_source.size()) {
                                                                if (!lis2.m_iter.hasNext()) break block15;
                                                                bl2 = false;
                                                                break block16;
                                                            }
                                                            java.lang.Object o1 = this.next();
                                                            if (o1 == null != ((o2 = lis2.next()) == null)) {
                                                                boolean bl11 = false;
                                                                java.lang.Object var12_10 = null;
                                                                this.reset();
                                                                lis2.reset();
                                                                return bl11;
                                                            }
                                                            if (o1 == null || o1 == o2) continue;
                                                            if (o1 instanceof Object) {
                                                                if (!(o2 instanceof Object)) {
                                                                    bl10 = false;
                                                                    break block17;
                                                                }
                                                                if (((Object)o1)._is_equivalent((Object)o2)) continue;
                                                                bl9 = false;
                                                                break block18;
                                                            }
                                                            if (!o1.getClass().isInstance(o2)) {
                                                                bl8 = false;
                                                                break block19;
                                                            }
                                                            if (o1 instanceof BoxedValueHelper) continue;
                                                            if (o1 instanceof StreamableValue) {
                                                                if (!(o2 instanceof StreamableValue)) {
                                                                    bl7 = false;
                                                                    break block20;
                                                                }
                                                                os1 = new ListOutputStream(this.m_orb);
                                                                os2 = new ListOutputStream(this.m_orb);
                                                                ((StreamableValue)o1)._write(os1);
                                                                ((StreamableValue)o2)._write(os2);
                                                                if (os1.create_input_stream().equals(os2.create_input_stream())) continue;
                                                                bl6 = false;
                                                                break block21;
                                                            }
                                                            if (o1 instanceof CustomValue) {
                                                                if (!(o2 instanceof CustomValue)) {
                                                                    bl5 = false;
                                                                    break block22;
                                                                }
                                                                os1 = new ListOutputStream(this.m_orb);
                                                                os2 = new ListOutputStream(this.m_orb);
                                                                ((CustomValue)o1).marshal(new DataOutputStream(os1));
                                                                ((CustomValue)o2).marshal(new DataOutputStream(os2));
                                                                if (os1.create_input_stream().equals(os2.create_input_stream())) continue;
                                                                bl4 = false;
                                                                break block23;
                                                            }
                                                            if (!o1.equals(o2)) break;
                                                        }
                                                        bl3 = false;
                                                        break block24;
                                                    }
                                                    bl = true;
                                                    break block25;
                                                }
                                                catch (Throwable throwable) {
                                                    java.lang.Object var12_21 = null;
                                                    this.reset();
                                                    lis2.reset();
                                                    throw throwable;
                                                }
                                            }
                                            java.lang.Object var12_11 = null;
                                            this.reset();
                                            lis2.reset();
                                            return bl10;
                                        }
                                        java.lang.Object var12_12 = null;
                                        this.reset();
                                        lis2.reset();
                                        return bl9;
                                    }
                                    java.lang.Object var12_13 = null;
                                    this.reset();
                                    lis2.reset();
                                    return bl8;
                                }
                                java.lang.Object var12_14 = null;
                                this.reset();
                                lis2.reset();
                                return bl7;
                            }
                            java.lang.Object var12_15 = null;
                            this.reset();
                            lis2.reset();
                            return bl6;
                        }
                        java.lang.Object var12_16 = null;
                        this.reset();
                        lis2.reset();
                        return bl5;
                    }
                    java.lang.Object var12_17 = null;
                    this.reset();
                    lis2.reset();
                    return bl4;
                }
                java.lang.Object var12_18 = null;
                this.reset();
                lis2.reset();
                return bl3;
            }
            java.lang.Object var12_19 = null;
            this.reset();
            lis2.reset();
            return bl2;
        }
        java.lang.Object var12_20 = null;
        this.reset();
        lis2.reset();
        return bl;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

