/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.ListInputStream;
import org.openorb.io.TypeCodeValueBoxHelper;
import org.openorb.util.CharacterCache;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class ListOutputStream
extends OutputStream
implements ExtendedOutputStream {
    private final List m_contents;
    private final ORB m_orb;
    private Logger m_logger;

    public ListOutputStream(ORB orb) {
        this.m_orb = orb;
        this.m_contents = new ArrayList();
    }

    public ListOutputStream(ORB orb, List contents) {
        this.m_orb = orb;
        this.m_contents = contents;
    }

    public ORB orb() {
        return this.m_orb;
    }

    public InputStream create_input_stream() {
        return new ListInputStream(this.m_orb, this.m_contents);
    }

    private List getContents() {
        return this.m_contents;
    }

    private int getIndex() {
        return this.m_contents.size();
    }

    void write_value_box(TypeCodeValueBoxHelper box) {
        this.m_contents.add(TCKind.tk_value_box);
        this.m_contents.add(box);
    }

    public void write_boolean(boolean i) {
        this.m_contents.add(TCKind.tk_boolean);
        this.m_contents.add(i ? Boolean.TRUE : Boolean.FALSE);
    }

    public void write_boolean_array(boolean[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_boolean, this.getLogger()));
    }

    public void write_octet(byte i) {
        this.m_contents.add(TCKind.tk_octet);
        this.m_contents.add(NumberCache.getByte(i));
    }

    public void write_octet_array(byte[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_octet, this.getLogger()));
    }

    public void write_short(short i) {
        this.m_contents.add(TCKind.tk_short);
        this.m_contents.add(NumberCache.getShort(i));
    }

    public void write_short_array(short[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_short, this.getLogger()));
    }

    public void write_ushort(short i) {
        this.m_contents.add(TCKind.tk_ushort);
        this.m_contents.add(NumberCache.getShort(i));
    }

    public void write_ushort_array(short[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_ushort, this.getLogger()));
    }

    public void write_long(int i) {
        this.m_contents.add(TCKind.tk_ulong);
        this.m_contents.add(NumberCache.getInteger(i));
    }

    public void write_long_array(int[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_long, this.getLogger()));
    }

    public void write_ulong(int i) {
        this.m_contents.add(TCKind.tk_ulong);
        this.m_contents.add(NumberCache.getInteger(i));
    }

    public void write_ulong_array(int[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_ulong, this.getLogger()));
    }

    public void write_longlong(long i) {
        this.m_contents.add(TCKind.tk_longlong);
        this.m_contents.add(NumberCache.getLong(i));
    }

    public void write_longlong_array(long[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_longlong, this.getLogger()));
    }

    public void write_ulonglong(long i) {
        this.m_contents.add(TCKind.tk_ulonglong);
        this.m_contents.add(NumberCache.getLong(i));
    }

    public void write_ulonglong_array(long[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_ulonglong, this.getLogger()));
    }

    public void write_float(float i) {
        this.m_contents.add(TCKind.tk_float);
        this.m_contents.add(NumberCache.getFloat(i));
    }

    public void write_float_array(float[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_float, this.getLogger()));
    }

    public void write_double(double i) {
        this.m_contents.add(TCKind.tk_double);
        this.m_contents.add(NumberCache.getDouble(i));
    }

    public void write_double_array(double[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_double, this.getLogger()));
    }

    public void write_char(char i) {
        this.m_contents.add(TCKind.tk_char);
        this.m_contents.add(CharacterCache.getCharacter(i));
    }

    public void write_char_array(char[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_char, this.getLogger()));
    }

    public void write_wchar(char i) {
        this.m_contents.add(TCKind.tk_wchar);
        this.m_contents.add(CharacterCache.getCharacter(i));
    }

    public void write_wchar_array(char[] val, int off, int len) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(val, off, len, TCKind.tk_wchar, this.getLogger()));
    }

    public void write_string(String i) {
        this.m_contents.add(TCKind.tk_string);
        this.m_contents.add(i);
    }

    public void write_wstring(String i) {
        this.m_contents.add(TCKind.tk_wstring);
        this.m_contents.add(i);
    }

    public void write_Object(Object value) {
        this.m_contents.add(TCKind.tk_objref);
        this.m_contents.add(value);
    }

    public void write_TypeCode(TypeCode value) {
        this.m_contents.add(TCKind.tk_TypeCode);
        this.m_contents.add(value);
    }

    public void write_any(Any value) {
        this.m_contents.add(TCKind.tk_any);
        this.m_contents.add(value);
    }

    public void write_Context(Context ctx, ContextList contexts) {
        ArrayList<String> allCtx = new ArrayList<String>();
        int i = 0;
        while (i < contexts.count()) {
            try {
                NVList list = ctx.get_values("", 0, contexts.item(i));
                int j = 0;
                while (j < list.count()) {
                    allCtx.add(list.item(j).name());
                    allCtx.add(list.item(j).value().extract_string());
                    ++j;
                }
            }
            catch (Bounds e) {
                // empty catch block
            }
            ++i;
        }
        if (allCtx.size() != 0) {
            this.write_ulong(allCtx.size());
            int j = 0;
            while (j < allCtx.size()) {
                this.write_string((String)allCtx.get(j));
                ++j;
            }
        } else if (contexts.count() != 0) {
            this.write_ulong(0);
        }
    }

    public void write_Principal(Principal value) {
        this.m_contents.add(TCKind.tk_Principal);
        this.m_contents.add(value);
    }

    public void write_fixed(BigDecimal value) {
        this.m_contents.add(TCKind.tk_fixed);
        this.m_contents.add(value);
    }

    public void write_fixed(BigDecimal val, TypeCode tc) {
        try {
            this.write_fixed(val, tc.fixed_digits(), tc.fixed_scale());
        }
        catch (BadKind ex) {
            this.getLogger().error("Type mismatch with fixed type.", ex);
            throw ExceptionTool.initCause(new BAD_PARAM("Type mismatch with fixed type (" + ex + ")", 1146056712, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
    }

    public void write_fixed(BigDecimal val, short digits, short scale) {
        if (scale >= 0 && val.scale() != scale) {
            val = val.setScale((int)scale, 6);
        }
        if (digits >= 0) {
            String strrep = val.toString();
            int strlen = strrep.length();
            if (strrep.charAt(0) == '-') {
                --strlen;
            }
            if (strrep.indexOf(46) != -1) {
                --strlen;
            }
            if (strlen > digits) {
                throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        this.m_contents.add(TCKind.tk_fixed);
        this.m_contents.add(val);
    }

    public void write_value(Serializable value) {
        if (null == value) {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(value);
            return;
        }
        if (value instanceof StreamableValue || value instanceof CustomValue) {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(value);
            return;
        }
        if (value instanceof ValueBase) {
            String repositoryId = ((ValueBase)value)._truncatable_ids()[0];
            BoxedValueHelper boxhelp = this.locateBoxedValueHelper(repositoryId);
            this.m_contents.add(TCKind.tk_value_box);
            this.m_contents.add(boxhelp);
            return;
        }
        if (value.getClass().isArray()) {
            throw new MARSHAL("Unable to locate valuebox helper", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.m_contents.add(TCKind.tk_value);
        this.m_contents.add(value);
    }

    public void write_value(Serializable value, String repositoryId) {
        if (value instanceof StreamableValue || value instanceof CustomValue) {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(value);
        } else if (value instanceof ValueBase || value.getClass().isArray()) {
            BoxedValueHelper boxhelp = this.locateBoxedValueHelper(repositoryId);
            this.m_contents.add(TCKind.tk_value_box);
            this.m_contents.add(boxhelp);
            boxhelp.write_value(this, value);
        } else {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(value);
        }
    }

    public void write_value(Serializable value, Class clz) {
        this.write_value(value);
    }

    private BoxedValueHelper locateBoxedValueHelper(String repositoryId) {
        String boxName = RepoIDHelper.idToClass(repositoryId, 2);
        try {
            return (BoxedValueHelper)this.loadClass(boxName).newInstance();
        }
        catch (Exception e) {
            this.getLogger().error("Unable to locate valuebox helper.", e);
            throw ExceptionTool.initCause(new MARSHAL("Unable to locate valuebox helper (" + e + ")", 1330446337, CompletionStatus.COMPLETED_NO), (Throwable)e);
        }
    }

    public void write_value(Serializable value, BoxedValueHelper boxhelp) {
        this.m_contents.add(TCKind.tk_value_box);
        this.m_contents.add(boxhelp);
        boxhelp.write_value(this, value);
    }

    public void write_abstract_interface(java.lang.Object object) {
        this.m_contents.add(TCKind.tk_abstract_interface);
        if (null == object) {
            this.write_Object(null);
            return;
        }
        if (object instanceof Object) {
            this.write_Object((Object)object);
            return;
        }
        if (object instanceof Serializable) {
            this.write_value((Serializable)object);
            return;
        }
        throw new BAD_PARAM("Attempt to marshal unknown interface type", 1146056716, CompletionStatus.COMPLETED_MAYBE);
    }

    public boolean equals(java.lang.Object obj) {
        return this.create_input_stream().equals(obj);
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.orb()).getLogger();
        }
        return this.m_logger;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    static class ArrayBlock {
        private final Logger m_logger;
        private final TCKind m_kind;
        private final int m_length;
        private java.lang.Object m_array;
        private int m_offset;

        ArrayBlock(java.lang.Object array, int off, int len, TCKind kind, Logger logger) {
            this.m_logger = logger;
            this.m_array = array;
            this.m_offset = off;
            this.m_length = len;
            this.m_kind = kind;
        }

        public int getLength() {
            return this.m_length;
        }

        public int getOffset() {
            return this.m_offset;
        }

        public TCKind getContentKind() {
            return this.m_kind;
        }

        public java.lang.Object getContents() {
            if (this.m_offset != 0) {
                java.lang.Object tmp = Array.newInstance(this.m_array.getClass().getSuperclass(), this.m_length);
                System.arraycopy(this.m_array, this.m_offset, tmp, 0, this.m_length);
                this.m_array = tmp;
                this.m_offset = 0;
            }
            return this.m_array;
        }

        public boolean equals(java.lang.Object o2) {
            if (!(o2 instanceof ArrayBlock)) {
                return false;
            }
            ArrayBlock ab2 = (ArrayBlock)o2;
            if (this.m_length != ab2.m_length || this.m_kind != ab2.m_kind) {
                return false;
            }
            switch (this.m_kind.value()) {
                case 8: {
                    boolean[] a1 = (boolean[])this.m_array;
                    boolean[] a2 = (boolean[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 10: {
                    byte[] a1 = (byte[])this.m_array;
                    byte[] a2 = (byte[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 2: 
                case 4: {
                    short[] a1 = (short[])this.m_array;
                    short[] a2 = (short[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 3: 
                case 5: {
                    int[] a1 = (int[])this.m_array;
                    int[] a2 = (int[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 23: 
                case 24: {
                    long[] a1 = (long[])this.m_array;
                    long[] a2 = (long[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 6: {
                    float[] a1 = (float[])this.m_array;
                    float[] a2 = (float[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 7: {
                    double[] a1 = (double[])this.m_array;
                    double[] a2 = (double[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 9: 
                case 26: {
                    char[] a1 = (char[])this.m_array;
                    char[] a2 = (char[])ab2.m_array;
                    int i = 0;
                    while (i < this.m_length) {
                        if (a1[this.m_offset + i] != a2[ab2.m_offset + i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            throw Trace.signalIllegalCondition(this.m_logger, "Unexpected case kind.value()==" + this.m_kind.value() + ".");
        }
    }
}

