/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.OutputStream;
import java.util.Properties;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.Priority;
import org.apache.log.output.io.StreamTarget;
import org.omg.CORBA.ORB;

public class ORBFactory {
    public static ORB createORB(String[] args, Properties props) {
        return ORBFactory.createORB(args, props, null, null, null, null);
    }

    public static ORB createORB(String[] args, Properties props, String id) {
        return ORBFactory.createORB(args, props, id, null, null, null);
    }

    public static ORB createORB(String[] args, Properties props, String id, String prio) {
        return ORBFactory.createORB(args, props, id, prio, null, null);
    }

    public static ORB createORB(String[] args, Properties props, String id, String prio, String fmt) {
        return ORBFactory.createORB(args, props, id, prio, fmt, null);
    }

    public static ORB createORB(String[] args, Properties props, String id, String prio, String fmt, OutputStream ostream) {
        OutputStream os;
        String format;
        String orbid;
        if (props == null) {
            props = (Properties)System.getProperties().clone();
        }
        if (props.get("org.omg.CORBA.ORBClass") == null) {
            props.put("org.omg.CORBA.ORBClass", "org.openorb.CORBA.ORB");
        }
        if (props.get("org.omg.CORBA.ORBSingletonClass") == null) {
            props.put("org.omg.CORBA.ORBSingletonClass", "org.openorb.CORBA.ORBSingleton");
        }
        if ((orbid = id) == null || orbid.length() == 0) {
            orbid = "orb";
        }
        Priority priority = Priority.ERROR;
        if (prio != null) {
            if (prio.equals("FATAL_EROR")) {
                priority = Priority.FATAL_ERROR;
            }
            if (prio.equals("WARN")) {
                priority = Priority.WARN;
            }
            if (prio.equals("INFO")) {
                priority = Priority.INFO;
            }
            if (prio.equals("DEBUG")) {
                priority = Priority.DEBUG;
            }
        }
        if ((format = fmt) == null || format.length() == 0) {
            format = "[%7.7{priority}] (%{category}): %{message}\\n%{throwable}";
        }
        if ((os = ostream) == null) {
            os = System.out;
        }
        Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
        StreamTarget target = new StreamTarget(os, new AvalonFormatter(format));
        hierarchy.setDefaultLogTarget(target);
        hierarchy.setDefaultPriority(priority);
        LogKitLogger logger = new LogKitLogger(hierarchy.getLoggerFor(orbid));
        props.put("LOGGER", logger);
        props.put("openorb.ORBLoader", "org.apache.orb.CORBA.kernel.DefaultLoader");
        return ORB.init(args, props);
    }
}

