/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing;

import java.io.IOException;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.RegisterPacket;
import org.openarchitectureware.debug.processing.DebugMonitor;
import org.openarchitectureware.debug.processing.IElementAdapter;
import org.openarchitectureware.debug.processing.IRuntimeHandler;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;

public class RuntimeHandlerManager
implements Runnable {
    private Connection connection;
    private DebugMonitor monitor;

    public RuntimeHandlerManager(DebugMonitor monitor) {
        this.monitor = monitor;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            while (true) {
                this.listenAndRegisterClasses();
            }
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void listenAndRegisterClasses() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        RegisterPacket packet = (RegisterPacket)this.connection.listenForPacket(RegisterPacket.class);
        String msg = null;
        if (packet.type == 1) {
            IRuntimeHandler handler = null;
            for (String className : packet.classNames) {
                Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(className);
                if (clazz == null) {
                    msg = "Couldn't find " + className + " in the class path.";
                    System.err.println(msg);
                    throw new ClassNotFoundException(msg);
                }
                handler = (IRuntimeHandler)clazz.newInstance();
                handler.init(this.monitor, this.connection);
                handler.startListener();
            }
        } else {
            IElementAdapter adapter = null;
            for (String className : packet.classNames) {
                Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(className);
                if (clazz == null) {
                    msg = "Couldn't find " + className + " in the class path.";
                    System.err.println(msg);
                    throw new ClassNotFoundException(msg);
                }
                adapter = (IElementAdapter)clazz.newInstance();
                this.monitor.addAdapter(adapter);
            }
        }
    }
}

