/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.BreakpointPacket;
import org.openarchitectureware.debug.model.SyntaxElementTO;
import org.openarchitectureware.debug.processing.DebugMonitor;
import org.openarchitectureware.debug.processing.IElementAdapter;
import org.openarchitectureware.debug.processing.IProcessHandler;
import org.openarchitectureware.debug.processing.IRuntimeHandler;

public class BreakpointRuntimeHandler
implements IRuntimeHandler,
IProcessHandler,
Runnable {
    public static final int SET = 1;
    public static final int REMOVE = 2;
    protected Connection connection;
    protected DebugMonitor monitor;
    private List<Object> breakpoints = new ArrayList<Object>();
    private List<SyntaxElementTO> breakpointTOs = new ArrayList<SyntaxElementTO>();
    private List<SyntaxElementTO> toBeRemovedTOs = new ArrayList<SyntaxElementTO>();

    public void init(DebugMonitor monitor, Connection connection) {
        this.monitor = monitor;
        this.connection = connection;
        if (monitor != null) {
            monitor.addProcessHandler(this);
        }
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            while (true) {
                this.listenAndDispatchCommand();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void listenAndDispatchCommand() throws IOException {
        this.handle((BreakpointPacket)this.connection.listenForPacket(BreakpointPacket.class));
    }

    private void handle(BreakpointPacket packet) {
        switch (packet.type) {
            case 1: {
                this.doSet(packet.se, null, 0);
                break;
            }
            case 2: {
                this.doRemove(packet.se, null, 0);
                break;
            }
        }
    }

    private void doSet(SyntaxElementTO se, Object actual, int flag) {
        IElementAdapter adapter = this.monitor.getAdapter(se);
        if (adapter == null) {
            return;
        }
        Object element = adapter.findElement(se, actual, flag);
        if (element == null) {
            this.breakpointTOs.add(se);
            for (SyntaxElementTO cand : this.toBeRemovedTOs) {
                if (!se.equalsBP(cand)) continue;
                this.toBeRemovedTOs.remove(cand);
                break;
            }
        } else {
            this.breakpoints.add(element);
        }
    }

    private void doRemove(SyntaxElementTO se, Object actual, int flag) {
        IElementAdapter adapter = this.monitor.getAdapter(se);
        if (adapter == null) {
            return;
        }
        Object element = adapter.findElement(se, actual, flag);
        if (element == null) {
            this.toBeRemovedTOs.add(se);
            for (SyntaxElementTO cand : this.breakpointTOs) {
                if (!se.equalsBP(cand)) continue;
                this.breakpointTOs.remove(cand);
                break;
            }
        } else {
            this.breakpoints.remove(element);
        }
    }

    public boolean isLastCall() {
        return false;
    }

    public boolean shallSuspend(boolean lastState, Object element, int flag) {
        ArrayList<SyntaxElementTO> temp;
        if (!this.toBeRemovedTOs.isEmpty()) {
            temp = new ArrayList<SyntaxElementTO>();
            temp.addAll(this.toBeRemovedTOs);
            this.toBeRemovedTOs.clear();
            for (SyntaxElementTO se : temp) {
                this.doRemove(se, element, flag);
            }
        }
        if (!this.breakpointTOs.isEmpty()) {
            temp = new ArrayList();
            temp.addAll(this.breakpointTOs);
            this.breakpointTOs.clear();
            for (SyntaxElementTO se : temp) {
                this.doSet(se, element, flag);
            }
        }
        return lastState || this.breakpoints.contains(element);
    }

    public boolean shallHandle(boolean lastState, Object element, int flag) {
        return lastState;
    }

    public boolean shallInterrupt(boolean lastState) {
        return lastState;
    }
}

