/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing.handlers;

import java.io.IOException;
import java.util.Stack;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.CommandPacket;
import org.openarchitectureware.debug.processing.DebugMonitor;
import org.openarchitectureware.debug.processing.ICommandListener;
import org.openarchitectureware.debug.processing.IEventHandler;
import org.openarchitectureware.debug.processing.IProcessHandler;
import org.openarchitectureware.debug.processing.IRuntimeHandler;

public class CommandRuntimeHandler
implements IRuntimeHandler,
ICommandListener,
IProcessHandler,
IEventHandler,
Runnable {
    public static final int STEP_INTO = 1;
    public static final int STEP_OVER = 2;
    public static final int STEP_RETURN = 3;
    public static final int RESUME = 4;
    public static final int SUSPEND = 5;
    public static final int TERMINATE = 6;
    private Connection connection;
    private DebugMonitor monitor;
    private boolean stepping = false;
    private boolean forceSuspend = false;
    private boolean interrupt = false;
    private Stack<Boolean> stackFrames = new Stack();
    private int iterationLevel = 0;
    private int suspendBaseLevel = 1;
    private boolean continueOperation = false;
    private Object[] syncObject = new Object[0];

    public void init(DebugMonitor monitor, Connection connection) {
        this.monitor = monitor;
        this.connection = connection;
        if (monitor != null) {
            monitor.setCommandListener(this);
            monitor.addProcessHandler(this);
            monitor.addEventHandler(this);
        }
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            while (true) {
                this.listenAndDispatchCommand();
            }
        }
        catch (IOException iOException) {
            this.doTerminate();
            return;
        }
    }

    private void listenAndDispatchCommand() throws IOException {
        this.dispatch(((CommandPacket)this.connection.listenForPacket(CommandPacket.class)).command);
    }

    private void dispatch(int cmd) {
        switch (cmd) {
            case 1: 
            case 2: 
            case 3: {
                this.doStep(cmd);
                break;
            }
            case 4: {
                this.doResume();
                break;
            }
            case 6: {
                this.doTerminate();
                break;
            }
            case 5: {
                this.doSuspend();
                break;
            }
        }
    }

    private void doStep(int cmd) {
        this.stepping = true;
        switch (cmd) {
            case 1: {
                this.suspendBaseLevel = this.iterationLevel + 1;
                break;
            }
            case 2: {
                this.suspendBaseLevel = this.iterationLevel;
                break;
            }
            case 3: {
                this.suspendBaseLevel = this.iterationLevel - 1;
            }
        }
        this.continueDebugger();
    }

    private void doResume() {
        this.stepping = false;
        this.continueDebugger();
    }

    private void doSuspend() {
        this.forceSuspend = true;
    }

    private void doTerminate() {
        this.interrupt = true;
        this.continueDebugger();
    }

    public boolean isLastCall() {
        return true;
    }

    public boolean shallHandle(boolean lastState, Object element, int flag) {
        boolean result;
        if (flag == 1) {
            result = this.monitor.getAdapter(element).shallHandle(element);
            this.stackFrames.push(result);
        } else {
            result = this.stackFrames.pop();
        }
        return lastState || result;
    }

    public boolean shallSuspend(boolean lastState, Object element, int flag) {
        boolean shallSuspend;
        boolean bl = !lastState && !this.forceSuspend && (!this.stepping || this.suspendBaseLevel - (flag == 1 ? 0 : 1) < this.iterationLevel) ? false : (shallSuspend = true);
        if (!this.monitor.getAdapter(element).shallSuspend(element, flag) && shallSuspend) {
            ++this.suspendBaseLevel;
            return false;
        }
        return shallSuspend;
    }

    public boolean shallInterrupt(boolean lastState) {
        return lastState || this.interrupt || !this.connection.isConnected();
    }

    public void started() {
    }

    public void preTask(Object element, Object context, int state) {
        ++this.iterationLevel;
    }

    public void postTask(Object context) {
        --this.iterationLevel;
    }

    public void suspended() {
        this.forceSuspend = false;
    }

    public void resumed() {
    }

    public void terminated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void listenCommand() {
        if (!this.continueOperation) {
            Object[] objectArray = this.syncObject;
            // MONITORENTER : this.syncObject
            try {
                this.syncObject.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.continueOperation = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continueDebugger() {
        this.continueOperation = true;
        Object[] objectArray = this.syncObject;
        synchronized (this.syncObject) {
            this.syncObject.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

