/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.workflow.ConfigurationException;
import org.openarchitectureware.workflow.Workflow;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.WorkflowContextDefaultImpl;
import org.openarchitectureware.workflow.ast.util.WorkflowFactory;
import org.openarchitectureware.workflow.ast.util.converter.Converter;
import org.openarchitectureware.workflow.customizer.WorkflowCustomization;
import org.openarchitectureware.workflow.issues.Issue;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.issues.IssuesImpl;
import org.openarchitectureware.workflow.monitor.NullProgressMonitor;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowRunner {
    private static final String PARAM = "p";
    private static final String MONITOR = "m";
    private static final String ANT = "a";
    private static final String CMDL = "c";
    private WorkflowContextDefaultImpl wfContext = new WorkflowContextDefaultImpl();
    private ProgressMonitor monitor;
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, String> params;
    private Workflow workflow;

    public static void main(String ... args) {
        URL wfUrl;
        Method method;
        new Object();
        Options options = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"className,moreArgs");
        OptionBuilder.withDescription((String)"the name of a class that implements ProgressMonitor. More arguments can be appended that will be injected to the monitor, if it has a init(String[] args) method.");
        OptionBuilder.withLongOpt((String)"monitorClass");
        OptionBuilder.withValueSeparator((char)',');
        options.addOption(OptionBuilder.create((String)MONITOR));
        OptionBuilder.withLongOpt((String)"ant");
        OptionBuilder.withDescription((String)"must be set when using in Ant context");
        options.addOption(OptionBuilder.create((String)ANT));
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withDescription((String)"external property that is handled as workflow property");
        OptionBuilder.hasArgs();
        Option paramOption = OptionBuilder.create((String)PARAM);
        paramOption.setLongOpt("param");
        options.addOption(paramOption);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"className");
        OptionBuilder.withDescription((String)"the name of a class that implements a public method 'public void processCmdLine(String[] cmdLineArgs, Map paramsToUseInWorkflow, WorkflowContext ctx)'.");
        OptionBuilder.withLongOpt((String)"cmdLineProcessor");
        options.addOption(OptionBuilder.create((String)CMDL));
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Parsing arguments failed.  Reason: " + exp.getMessage());
            WorkflowRunner.wrongCall(options);
            return;
        }
        WorkflowRunner runner = new WorkflowRunner();
        HashMap<String, String> params = new HashMap();
        String wfFile = null;
        String[] monitorOptValues = line.getOptionValues(MONITOR);
        if (line.hasOption(CMDL)) {
            try {
                ArrayList<String> unprocessedArgs = new ArrayList<String>();
                int i = 0;
                while (i < args.length) {
                    String arg = args[i];
                    if (arg.equals("-c") || arg.equals("--cmdLineProcessor")) {
                        ++i;
                    } else if (arg.equals("-m") || arg.equals("--monitorClass")) {
                        i += monitorOptValues.length;
                    } else if (arg.endsWith(".oaw")) {
                        if (wfFile != null) {
                            System.err.println("Workflowfile already defined!");
                            System.exit(1);
                        }
                        wfFile = arg;
                    } else {
                        unprocessedArgs.add(arg);
                    }
                    ++i;
                }
                Class<?> cmdLineProcessor = ResourceLoaderFactory.createResourceLoader().loadClass(line.getOptionValue(CMDL));
                if (cmdLineProcessor == null) {
                    System.err.println("cannot find class '" + line.getOptionValue(CMDL) + "' for command line processing.");
                    System.exit(1);
                }
                method = cmdLineProcessor.getMethod("processCmdLine", String[].class, Map.class, WorkflowContext.class);
                method.invoke(cmdLineProcessor.newInstance(), unprocessedArgs.toArray(new String[0]), params, runner.getContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            params = WorkflowRunner.resolveParams(line.getOptionValues(PARAM));
            wfFile = line.getArgs()[0];
        }
        if (wfFile == null || !wfFile.endsWith(".oaw")) {
            WorkflowRunner.wrongCall(options);
        }
        ProgressMonitor monitor = null;
        if (monitorOptValues != null) {
            try {
                Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(monitorOptValues[0]);
                if (clazz == null) {
                    throw new ClassNotFoundException("Didn't find class " + monitorOptValues[0]);
                }
                monitor = (ProgressMonitor)clazz.newInstance();
                method = monitor.getClass().getMethod("init", String[].class);
                if (method != null) {
                    method.invoke((Object)monitor, new Object[]{monitorOptValues});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (line.hasOption(ANT)) {
                    System.exit(1);
                }
                return;
            }
        }
        int index = 0;
        do {
            if ((wfUrl = Thread.currentThread().getContextClassLoader().getResource(wfFile)) != null || (index = wfFile.indexOf(47)) < 0) continue;
            wfFile = wfFile.substring(index + 1);
        } while (wfUrl == null && index >= 0);
        if (wfUrl == null) {
            runner.logger.error((Object)("can't find the workflow file '" + line.getArgs()[0] + "' in the current class path"));
            if (line.hasOption(ANT)) {
                System.exit(1);
            }
            return;
        }
        boolean success = runner.run(wfFile, monitor, params, null);
        if (!success && line.hasOption(ANT)) {
            System.exit(1);
        }
    }

    private static Map<String, String> resolveParams(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (args == null) {
            return params;
        }
        int i = 0;
        while (i < args.length) {
            String[] string = args[i].split("=");
            if (string.length != 2) {
                throw new IllegalArgumentException("wrong param syntax (-pkey=value). was : " + args[i]);
            }
            params.put(string[0], string[1]);
            ++i;
        }
        return params;
    }

    private static void wrongCall(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + WorkflowRunner.class.getName() + " some_workflow_file.oaw [options]", options);
        System.exit(0);
    }

    public boolean run(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams, Map<String, ?> externalSlotContents) {
        boolean configOK = this.prepare(workFlowFile, theMonitor, theParams);
        IssuesImpl issues = new IssuesImpl();
        if (configOK) {
            return this.executeWorkflow(externalSlotContents, issues);
        }
        return false;
    }

    public boolean prepare(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams) {
        IssuesImpl issues;
        block10: {
            if (workFlowFile == null) {
                throw new NullPointerException("workflowFile is null");
            }
            this.monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
            this.params = theParams;
            this.logger.info((Object)"--------------------------------------------------------------------------------------");
            this.logger.info((Object)("openArchitectureWare " + this.getVersion()));
            this.logger.info((Object)"(c) 2005-2008 openarchitectureware.org and contributors");
            this.logger.info((Object)"--------------------------------------------------------------------------------------");
            this.logger.info((Object)("running workflow: " + workFlowFile));
            this.logger.info((Object)"");
            this.mapDefaultKeywords();
            if (this.logger.isDebugEnabled() && !this.params.isEmpty()) {
                this.logger.debug((Object)("Params:" + this.params.toString()));
            }
            issues = new IssuesImpl();
            try {
                WorkflowFactory factory = new WorkflowFactory();
                try {
                    this.workflow = factory.parseInitAndCreate(workFlowFile, this.params, this.getConverters(), issues);
                }
                catch (IllegalArgumentException illegalArg) {
                    if (illegalArg.getMessage().startsWith("Couldn't load file")) {
                        throw new ConfigurationException(illegalArg.getMessage());
                    }
                    throw illegalArg;
                }
                this.logIssues(this.logger, issues);
                if (!issues.hasErrors()) break block10;
                this.logger.error((Object)"Workflow interrupted because of configuration errors.");
                return false;
            }
            catch (ConfigurationException ex) {
                this.logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                this.logIssues(this.logger, issues);
                return false;
            }
        }
        if (this.workflow != null) {
            this.workflow.checkConfiguration(issues);
        }
        this.logIssues(this.logger, issues);
        if (issues.hasErrors()) {
            this.logger.error((Object)"Workflow interrupted because of configuration errors.");
            return false;
        }
        return true;
    }

    private Map<Class<?>, Converter> getConverters() {
        Map<Class<?>, Converter> result = this.getCustomConverters();
        Map<Class<?>, Converter> defaults = WorkflowFactory.getDefaultConverter();
        if (result == null) {
            result = defaults;
        } else {
            for (Map.Entry<Class<?>, Converter> record : defaults.entrySet()) {
                if (result.containsKey(record.getKey())) continue;
                result.put(record.getKey(), record.getValue());
            }
        }
        return result;
    }

    protected Map<Class<?>, Converter> getCustomConverters() {
        return null;
    }

    private void mapDefaultKeywords() {
        WorkflowCustomization.registerKeywordMapping("xpand", "org.openarchitectureware.xpand2.Generator");
        WorkflowCustomization.registerKeywordMapping("generate", "org.openarchitectureware.xpand2.Generator");
        WorkflowCustomization.registerKeywordMapping("read", "org.eclipse.mwe.emf.Reader");
        WorkflowCustomization.registerKeywordMapping("write", "org.eclipse.mwe.emf.Writer");
        WorkflowCustomization.registerKeywordMapping("trafo", "org.openarchitectureware.xtend.XtendComponent");
        WorkflowCustomization.registerKeywordMapping("transform", "org.openarchitectureware.xtend.XtendComponent");
        WorkflowCustomization.registerKeywordMapping("generatorAspect", "org.openarchitectureware.xpand2.GeneratorAdvice");
        WorkflowCustomization.registerKeywordMapping("transformationAspect", "org.openarchitectureware.xtend.XtendAdvice");
        WorkflowCustomization.registerKeywordMapping("cleanDir", "org.openarchitectureware.workflow.common.DirectoryCleaner");
        WorkflowCustomization.registerKeywordMapping("checkConstraints", "org.openarchitectureware.check.CheckComponent");
    }

    public boolean executeWorkflow(Map<?, ?> externalSlotContents, Issues issues) {
        try {
            this.addExternalSlotContents(externalSlotContents);
            long time = System.currentTimeMillis();
            this.monitor.started(this.workflow, this.wfContext);
            this.workflow.invoke(this.wfContext, this.monitor, issues);
            this.monitor.finished(this.workflow, this.wfContext);
            long duration = System.currentTimeMillis() - time;
            this.logger.info((Object)("workflow completed in " + duration + "ms!"));
            return issues.getErrors().length <= 0;
            {
            }
        }
        catch (Exception e) {
            if (e.getClass().getName().indexOf("Interrupt") > -1) {
                this.logger.error((Object)("Workflow interrupted. Reason: " + e.getMessage()));
            } else {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.logIssues(this.logger, issues);
        }
        return false;
    }

    private void addExternalSlotContents(Map<?, ?> slotContents) {
        if (slotContents == null) {
            return;
        }
        for (String key : slotContents.keySet()) {
            this.wfContext.set(key, slotContents.get(key));
        }
    }

    private void logIssues(Log logger, Issues issues) {
        Issue issue;
        Issue[] issueArray = issues.getWarnings();
        int i = 0;
        while (i < issueArray.length) {
            issue = issueArray[i];
            logger.warn((Object)issue.toString());
            ++i;
        }
        if (issues.hasErrors()) {
            issueArray = issues.getErrors();
            i = 0;
            while (i < issueArray.length) {
                issue = issueArray[i];
                logger.error((Object)issue.toString());
                ++i;
            }
        }
    }

    public WorkflowContext getContext() {
        return this.wfContext;
    }

    /*
     * Unable to fully structure code
     */
    private String getVersion() {
        version = null;
        manifestURLs = null;
        try {
            manifestURLs = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            if (true) ** GOTO lbl19
        }
        catch (IOException v0) {
            throw new IllegalStateException("Failed to load Manifest");
        }
        do {
            url = manifestURLs.nextElement();
            try {
                if (url.toString().contains("core.workflow") && "org.openarchitectureware.core.workflow".equals((manifest = new Manifest(url.openStream())).getMainAttributes().getValue("Bundle-SymbolicName"))) {
                    version = manifest.getMainAttributes().getValue("Bundle-Version");
                    lastPoint = version.lastIndexOf(46);
                    version = String.valueOf(version.substring(0, lastPoint)) + ", Build " + version.substring(lastPoint + 1);
                    return version;
                }
            }
            catch (IOException v1) {
                this.logger.debug((Object)("Failed to read Manifest file: " + url));
            }
lbl19:
            // 3 sources

        } while (manifestURLs.hasMoreElements());
        return "4.x Development";
    }
}

