/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.ast.parser;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.workflow.ast.AbstractASTBase;
import org.openarchitectureware.workflow.ast.ComponentAST;
import org.openarchitectureware.workflow.ast.DeclaredPropertyAST;
import org.openarchitectureware.workflow.ast.DeclaredPropertyFileAST;
import org.openarchitectureware.workflow.ast.InclusionAST;
import org.openarchitectureware.workflow.ast.ReferenceAST;
import org.openarchitectureware.workflow.ast.SimpleParamAST;
import org.openarchitectureware.workflow.ast.parser.Location;
import org.openarchitectureware.workflow.issues.Issues;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class WorkflowParser
extends DefaultHandler
implements ContentHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String PROPERTY = "property";
    public static final String CLASS = "class";
    public static final String FILE = "file";
    public static final String ID = "id";
    public static final String IDREF = "idRef";
    public static final String VALUE = "value";
    public static final String NAME = "name";
    private static final String INHERITALL = "inheritAll";
    private final Stack<Object> eleStack = new Stack();
    private AbstractASTBase root = null;
    private Locator locator = null;
    private String resource = "unknown";
    private Issues issues = null;

    public AbstractASTBase parse(InputStream in, String resourceName, Issues issues) {
        this.resource = resourceName;
        this.issues = issues;
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(in, (DefaultHandler)this);
        }
        catch (Exception e) {
            this.root = null;
            this.log.error((Object)e.getMessage(), (Throwable)e);
            issues.addError(e.getMessage(), (Object)resourceName);
        }
        return this.root;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (PROPERTY.equals(qName)) {
            AbstractASTBase prop = this.handleProperty(qName, attributes);
            this.connectAndPush(prop);
        } else {
            AbstractASTBase ele = this.handleComp(qName, attributes);
            this.connectAndPush(ele);
        }
    }

    private void connectAndPush(AbstractASTBase prop) {
        if (this.eleStack.isEmpty()) {
            this.eleStack.push(prop);
        } else if (this.eleStack.peek() instanceof ComponentAST) {
            ((ComponentAST)this.eleStack.peek()).getChildren().add(prop);
            this.eleStack.push(prop);
        } else {
            this.issues.addError("The element " + this.eleStack.peek() + " cannot contain any child elements!", prop);
            this.eleStack.push("DUMMY");
        }
    }

    protected AbstractASTBase handleComp(String name, Attributes attributes) {
        if (attributes.getValue(FILE) != null) {
            boolean inheritAll = attributes.getValue(INHERITALL) != null;
            InclusionAST c = new InclusionAST(this.getLocation(), name, attributes.getValue(FILE), attributes.getValue(ID), inheritAll);
            if (attributes.getValue(CLASS) != null) {
                this.issues.addError("Attribute 'class' not allowed for inclusions : property", c);
            }
            int i = 0;
            while (i < attributes.getLength()) {
                String temp = attributes.getQName(i);
                if (!("".equals(temp) || FILE.equals(temp) || ID.equals(temp))) {
                    c.addChild(new SimpleParamAST(this.getLocation(), temp, attributes.getValue(temp)));
                }
                ++i;
            }
            return c;
        }
        if (attributes.getValue(IDREF) != null) {
            this.validateAttributes("reference " + name, attributes, new String[]{IDREF}, new String[0]);
            return new ReferenceAST(this.getLocation(), name, attributes.getValue(IDREF));
        }
        if (attributes.getValue(VALUE) != null && attributes.getValue(NAME) == null) {
            this.validateAttributes("simpleparam " + name, attributes, new String[]{VALUE}, new String[0]);
            return new SimpleParamAST(this.getLocation(), name, attributes.getValue(VALUE));
        }
        ComponentAST result = new ComponentAST(this.getLocation(), name, attributes.getValue(CLASS), attributes.getValue(ID));
        int i = 0;
        while (i < attributes.getLength()) {
            String temp = attributes.getQName(i);
            if (!("".equals(temp) || CLASS.equals(temp) || ID.equals(temp))) {
                result.addChild(new SimpleParamAST(this.getLocation(), temp, attributes.getValue(temp)));
            }
            ++i;
        }
        return result;
    }

    protected AbstractASTBase handleProperty(String localName, Attributes attributes) {
        if (attributes.getValue(NAME) != null) {
            this.validateAttributes(localName, attributes, new String[]{NAME}, new String[]{VALUE});
            return new DeclaredPropertyAST(this.getLocation(), attributes.getValue(NAME), attributes.getValue(VALUE));
        }
        if (attributes.getValue(FILE) != null) {
            this.validateAttributes(localName, attributes, new String[]{FILE}, new String[0]);
            return new DeclaredPropertyFileAST(this.getLocation(), attributes.getValue(FILE));
        }
        this.issues.addError("Either 'name' or 'file' attribute is mandatory for element property", this.getLocation());
        return new DeclaredPropertyAST(this.getLocation(), "__UNKNOWN__");
    }

    private void validateAttributes(String eleName, Attributes attributes, String[] mandatory, String[] optional) {
        HashSet mandatorySet = new HashSet(Arrays.asList(mandatory));
        HashSet optionalSet = new HashSet(Arrays.asList(optional));
        HashSet<String> mandatoryFound = new HashSet<String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getQName(i);
            if (!(name == null || name.trim().equals("") || mandatorySet.contains(name) || optionalSet.contains(name))) {
                this.issues.addError("Unknown attribute " + name + " for element " + eleName, this.getLocation());
            }
            if (mandatorySet.contains(name)) {
                mandatoryFound.add(name);
            }
            ++i;
        }
        mandatorySet.removeAll(mandatoryFound);
        if (!mandatorySet.isEmpty()) {
            for (String name : mandatorySet) {
                this.issues.addError("Attribute " + name + " is mandatory for element " + eleName, this.getLocation());
            }
        }
    }

    private Location getLocation() {
        return new Location(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.resource);
    }

    public void endElement(String uri, String name, String qName) {
        this.root = (AbstractASTBase)this.eleStack.pop();
    }
}

