/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.ast.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.ast.util.Injector;
import org.openarchitectureware.workflow.ast.util.InjectorList;
import org.openarchitectureware.workflow.ast.util.InjectorPut;
import org.openarchitectureware.workflow.ast.util.InjectorSimple;
import org.openarchitectureware.workflow.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorFactory {
    public static final Injector getInjector(Class<?> c, String name) {
        Injector inj = InjectorFactory.getInjector1(c, name);
        inj = inj == null ? InjectorFactory.getInjector2(c, name) : inj;
        inj = inj == null ? InjectorFactory.getInjector3(c, name) : inj;
        inj = inj == null ? InjectorFactory.getInjector4(c, name) : inj;
        inj = inj == null ? InjectorFactory.getInjector5(c, name) : inj;
        return inj;
    }

    private static final Injector getInjector1(Class<?> c, String name) {
        String adderName = "add" + StringHelper.firstUpper(name);
        Method[] ms = c.getMethods();
        int i = 0;
        while (i < ms.length) {
            String mn;
            Method method = ms[i];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getParameterTypes().length == 1 && (mn = method.getName()).equals(adderName)) {
                return new InjectorSimple(method, name);
            }
            ++i;
        }
        return null;
    }

    private static final Injector getInjector2(Class<?> c, String name) {
        String getterName = "get" + StringHelper.firstUpper(name);
        Method[] ms = c.getMethods();
        int i = 0;
        while (i < ms.length) {
            String mn;
            Method method = ms[i];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getParameterTypes().length == 0 && (mn = method.getName()).equals(getterName) && List.class.isAssignableFrom(method.getReturnType())) {
                return new InjectorList(method, name);
            }
            ++i;
        }
        return null;
    }

    private static final Injector getInjector3(Class<?> c, String name) {
        String setterName = "set" + StringHelper.firstUpper(name);
        Method[] ms = c.getMethods();
        int i = 0;
        while (i < ms.length) {
            String mn;
            Method method = ms[i];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getParameterTypes().length == 1 && (mn = method.getName()).equals(setterName) && !List.class.isAssignableFrom(method.getParameterTypes()[0])) {
                return new InjectorSimple(method, name);
            }
            ++i;
        }
        return null;
    }

    private static final Injector getInjector4(Class<?> c, String name) {
        Method[] ms = c.getMethods();
        int i = 0;
        while (i < ms.length) {
            String mn;
            Method method = ms[i];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getParameterTypes().length == 2 && (mn = method.getName()).equals("put") && method.getParameterTypes()[0].isAssignableFrom(String.class)) {
                return new InjectorPut(method, name);
            }
            ++i;
        }
        return null;
    }

    private static final Injector getInjector5(Class<?> c, String name) {
        Method[] ms = c.getMethods();
        int i = 0;
        while (i < ms.length) {
            String mn;
            Method method = ms[i];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getParameterTypes().length == 1 && (mn = method.getName()).equals("addComponent") && !WorkflowComponent.class.isAssignableFrom(method.getParameterTypes()[0])) {
                return new InjectorSimple(method, name);
            }
            ++i;
        }
        return null;
    }
}

