/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.ast.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openarchitectureware.workflow.ast.util.Injector;
import org.openarchitectureware.workflow.customizer.WorkflowCustomization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorPut
implements Injector {
    public Method putMethod;
    public String name = null;

    public InjectorPut(Method m, String n) {
        this.putMethod = m;
        this.name = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setValue(Object target, Object val) {
        try {
            this.putMethod.invoke(target, this.name, val);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> getRequiredType() {
        Class<?> defaultClass = this.putMethod.getParameterTypes()[1];
        Class<?> overriddenClass = WorkflowCustomization.getKeywordMapping(this.getName());
        if (overriddenClass != null) {
            if (!defaultClass.isAssignableFrom(overriddenClass)) {
                throw new RuntimeException("the customized class '" + overriddenClass.getName() + "' for the keyword '" + this.getName() + "' is not a subtype of the default class '" + defaultClass.getName() + "'; falling back to default.");
            }
            return overriddenClass;
        }
        return defaultClass;
    }
}

