/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.container;

import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.WorkflowInterruptedException;
import org.openarchitectureware.workflow.container.CompositeComponent;
import org.openarchitectureware.workflow.container.ConditionEvaluationException;
import org.openarchitectureware.workflow.container.WorkflowConditional;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.workflow.util.ComponentPrinter;

public abstract class ConditionalComponent
extends CompositeComponent
implements WorkflowConditional {
    private WorkflowComponent elseComp;

    public ConditionalComponent(String name) {
        super(name);
    }

    public void setElse(CompositeComponent comp) {
        this.elseComp = comp;
    }

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.internalInvoke(ctx, monitor, issues);
    }

    private void internalInvoke(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        block8: {
            try {
                if (this.evaluate()) {
                    for (WorkflowComponent comp : this.components) {
                        try {
                            this.log.info((Object)ComponentPrinter.getString(comp));
                        }
                        catch (WorkflowInterruptedException wfi) {
                            throw wfi;
                        }
                        catch (Throwable t) {
                            issues.addError(comp, "Error during execution: " + t.getMessage());
                            this.log.error((Object)"Exception occured: ", t);
                        }
                        comp.invoke(model, monitor, issues);
                    }
                    break block8;
                }
                if (this.elseComp != null) {
                    this.elseComp.invoke(model, monitor, issues);
                }
            }
            catch (ConditionEvaluationException ex) {
                issues.addError(this, "cannot evaluate condition: " + ex.getMessage());
            }
        }
    }
}

