/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.issues;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.issues.Issue;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.util.ComponentPrinter;

public class IssuesImpl
implements Issues {
    private final List<Issue> warnings = new ArrayList<Issue>();
    private final List<Issue> errors = new ArrayList<Issue>();

    public void addError(WorkflowComponent ctx, String msg, Object element) {
        this.addError(new Issue(ctx, msg, element));
    }

    private void addError(Issue issue) {
        this.errors.add(issue);
    }

    public void addWarning(WorkflowComponent ctx, String msg, Object element) {
        this.addWarning(new Issue(ctx, msg, element));
    }

    private void addWarning(Issue issue) {
        this.warnings.add(issue);
    }

    public void addError(WorkflowComponent ctx, String msg) {
        this.addError(ctx, msg, null);
    }

    public void addWarning(WorkflowComponent ctx, String msg) {
        this.addWarning(ctx, msg, null);
    }

    public void addWarning(String msg, Object element) {
        this.addWarning(new Issue(msg, element));
    }

    public void addError(String msg, Object element) {
        this.addError(new Issue(msg, element));
    }

    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    public void addError(String msg) {
        this.addError(msg, null);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Issue[] getErrors() {
        return this.errors.toArray(new Issue[this.errors.size()]);
    }

    public Issue[] getWarnings() {
        return this.warnings.toArray(new Issue[this.warnings.size()]);
    }

    public String toString() {
        Issue issue;
        StringBuffer buff = new StringBuffer();
        Issue[] issues = this.getWarnings();
        int i = 0;
        while (i < issues.length) {
            issue = issues[i];
            buff.append("\n[WARNING] : " + issue.getMessage());
            if (issue.getElement() != null) {
                buff.append(" - for " + this.getElementStringRep(issue));
            }
            if (issue.getContext() != null) {
                buff.append(" - reported by: " + ComponentPrinter.getString(issue.getContext()));
            }
            ++i;
        }
        issues = this.getErrors();
        i = 0;
        while (i < issues.length) {
            issue = issues[i];
            buff.append("\n[ERROR] : " + issue.getMessage());
            if (issue.getElement() != null) {
                buff.append(" - for " + this.getElementStringRep(issue));
            }
            if (issue.getContext() != null) {
                buff.append(" - reported by: " + ComponentPrinter.getString(issue.getContext()));
            }
            ++i;
        }
        return buff.toString();
    }

    private String getElementStringRep(Issue issue) {
        Object element = issue.getElement();
        if (element instanceof EObject) {
            EObject eo = (EObject)element;
            String name = this.getEName(eo);
            if (name == null) {
                return eo.toString();
            }
            StringBuffer qfn = new StringBuffer();
            qfn.append(name);
            while (eo.eContainer() != null) {
                name = this.getEName(eo = eo.eContainer());
                if (name == null) continue;
                qfn.insert(0, String.valueOf(name) + ".");
            }
            return qfn.toString();
        }
        return element.toString();
    }

    private String getEName(EObject eo) {
        EStructuralFeature f = eo.eClass().getEStructuralFeature("name");
        if (f == null) {
            return null;
        }
        return (String)eo.eGet(f);
    }

    public void clear() {
        this.errors.clear();
        this.warnings.clear();
    }
}

