/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public abstract class AbstractWorkflowComponent2
extends AbstractWorkflowComponent {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean skipOnErrors = false;

    public void setSkipOnErrors(boolean skip) {
        this.skipOnErrors = skip;
    }

    public final void checkConfiguration(Issues issues) {
        this.checkConfigurationInternal(issues);
    }

    public final void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask("Running " + this.getComponentName() + "...", -1);
        }
        if (this.skipOnErrors && issues.hasErrors()) {
            this.log.info((Object)"execution skipped, since there are errors and skipOnErrors is set.");
            return;
        }
        this.invokeInternal(ctx, monitor, issues);
        if (monitor != null) {
            monitor.done();
        }
    }

    protected abstract void invokeInternal(WorkflowContext var1, ProgressMonitor var2, Issues var3);

    protected abstract void checkConfigurationInternal(Issues var1);
}

