/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.lib;

import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public abstract class SimpleJavaTransformationComponent
extends AbstractWorkflowComponent {
    private String inputSlot;
    private String outputSlot;

    public void setInputSlot(String slotName) {
        this.inputSlot = slotName;
    }

    public void setOutputSlot(String slotName) {
        this.outputSlot = slotName;
    }

    public void checkConfiguration(Issues issues) {
        if (this.inputSlot == null) {
            issues.addError(this, "inputSlot not specified");
        }
        if (this.outputSlot == null) {
            issues.addError(this, "outputSlot not specified");
        }
    }

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Object in = ctx.get(this.inputSlot);
        if (in == null) {
            issues.addError(this, "inputSlot empty!");
            return;
        }
        Object out = ctx.get(this.outputSlot);
        if (out != null) {
            issues.addWarning(this, "outputSlot not empty");
        }
        Object result = this.doTransformation(in, ctx, monitor, issues);
        ctx.set(this.outputSlot, result);
    }

    protected abstract Object doTransformation(Object var1, WorkflowContext var2, ProgressMonitor var3, Issues var4);
}

