/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.util;

import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowComponentWithID;
import org.openarchitectureware.workflow.container.CompositeComponent;

public class ComponentPrinter {
    public static String getString(WorkflowComponent comp) {
        if (comp instanceof CompositeComponent) {
            CompositeComponent cc = (CompositeComponent)comp;
            String nameAndLocation = String.valueOf(ComponentPrinter.getShortName(cc)) + ": executing ";
            if (cc.getName() != null && !"".equals(cc.getName())) {
                nameAndLocation = String.valueOf(nameAndLocation) + cc.getName();
            }
            if (cc.getResource() != null) {
                nameAndLocation = String.valueOf(nameAndLocation) + " " + cc.getResource();
            }
            if (cc.getLocation() != null) {
                nameAndLocation = String.valueOf(nameAndLocation) + " " + cc.getLocation();
            }
            if (!"".equals(nameAndLocation)) {
                return nameAndLocation;
            }
        }
        if (comp instanceof WorkflowComponentWithID) {
            WorkflowComponentWithID wid = (WorkflowComponentWithID)comp;
            String logMessage = wid.getLogMessage();
            if (wid.getId() != null && !"".equals(wid.getId())) {
                return String.valueOf(ComponentPrinter.getShortName(wid)) + "(" + wid.getId() + ")" + (logMessage == null ? "" : ": " + logMessage);
            }
            return String.valueOf(ComponentPrinter.getShortName(wid)) + (logMessage == null ? "" : ": " + logMessage);
        }
        return comp.getClass().getName();
    }

    private static String getShortName(WorkflowComponentWithID wid) {
        return wid.getClass().getSimpleName();
    }

    public static String getShortString(WorkflowComponent comp) {
        WorkflowComponentWithID wid;
        if (comp == null) {
            return "no Name";
        }
        if (comp instanceof WorkflowComponentWithID && (wid = (WorkflowComponentWithID)comp).getId() != null && !"".equals(wid.getId())) {
            return wid.getId();
        }
        if (comp instanceof CompositeComponent) {
            CompositeComponent cc = (CompositeComponent)comp;
            String nameAndLocation = "";
            if (cc.getName() != null && !"".equals(cc.getName())) {
                nameAndLocation = String.valueOf(nameAndLocation) + cc.getName();
            }
            if (cc.getResource() != null) {
                int pos = cc.getResource().lastIndexOf("/");
                nameAndLocation = String.valueOf(nameAndLocation) + " " + cc.getResource().substring(pos + 1);
            }
            if (!"".equals(nameAndLocation)) {
                return nameAndLocation;
            }
        }
        return comp.getClass().getName();
    }

    public static String getContainerName(WorkflowComponent comp) {
        CompositeComponent cc = comp.getContainer();
        if (cc != null && cc.getResource() != null) {
            int pos = cc.getResource().lastIndexOf("/");
            return cc.getResource().substring(pos + 1);
        }
        return "no container";
    }

    public static String getElementName(WorkflowComponent comp) {
        CompositeComponent cc;
        WorkflowComponentWithID wid;
        if (comp instanceof WorkflowComponentWithID && (wid = (WorkflowComponentWithID)comp).getId() != null && !"".equals(wid.getId())) {
            return wid.getId();
        }
        if (comp instanceof CompositeComponent && (cc = (CompositeComponent)comp).getResource() != null) {
            int pos = cc.getResource().lastIndexOf("/");
            return cc.getResource().substring(pos + 1);
        }
        return comp.getClass().getSimpleName();
    }
}

