/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.util;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    private static final NumberFormat _numFormat = NumberFormat.getNumberInstance();

    public static String prettyPrint(long num) {
        return _numFormat.format(num);
    }

    public static String prettyPrint(Number num) {
        return _numFormat.format(num);
    }

    public static String prettyPrint(Date date) {
        return DateFormat.getDateTimeInstance().format(date);
    }

    public static String replace(String src, String search, String replace) {
        if (src == null) {
            return src;
        }
        if (search == null || search.length() == 0) {
            throw new IllegalArgumentException("Search string must not be empty");
        }
        String result = src;
        int ind = 0;
        while ((ind = result.indexOf(search, ind)) >= 0) {
            result = String.valueOf(result.substring(0, ind)) + replace + result.substring(ind + search.length());
            ind += replace.length();
        }
        return result;
    }

    public static String escape(String src) {
        String result = StringHelper.replace(src, "\\", "\\\\");
        result = StringHelper.replace(result, "\t", "\\t");
        result = StringHelper.replace(result, "\r", "\\r");
        result = StringHelper.replace(result, "\n", "\\n");
        result = StringHelper.replace(result, "\"", "\\\"");
        return result;
    }

    public static String unescape(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            char curChar = src.charAt(i);
            if (curChar != '\\') {
                result.append(curChar);
            } else {
                if (++i >= src.length()) {
                    throw new IllegalArgumentException("String ends with '\\'");
                }
                result.append(StringHelper.unescapeChar(src.charAt(i)));
            }
            ++i;
        }
        return result.toString();
    }

    private static char unescapeChar(char escapedChar) {
        switch (escapedChar) {
            case '\\': {
                return '\\';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\"': {
                return '\"';
            }
        }
        throw new IllegalArgumentException("unsupported string format: '\\" + escapedChar + "' is not supported.");
    }

    public static String truncate(String str, int maxLen) {
        if (str == null || str.length() < maxLen) {
            return str;
        }
        if (maxLen < 0) {
            return "";
        }
        return str.substring(0, maxLen);
    }

    public static String substring(String str, int beginIndex) {
        if (str == null) {
            return null;
        }
        if (beginIndex < 0) {
            return str;
        }
        if (beginIndex >= str.length()) {
            return "";
        }
        return str.substring(beginIndex);
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        if (str == null) {
            return null;
        }
        if (beginIndex > endIndex) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > str.length()) {
            endIndex = str.length();
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String strip(String s, int numStart, int numEnd) {
        if (s == null) {
            return s;
        }
        return StringHelper.substring(s, numStart, s.length() - numEnd);
    }

    public static int numMatches(String s, char ch) {
        if (s == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ch) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int numMatches(String s, String search) {
        if (s == null || search == null || "".equals(s) || "".equals(search)) {
            return 0;
        }
        int result = 0;
        int curIndex = 0;
        while ((curIndex = s.indexOf(search, curIndex)) != -1) {
            ++curIndex;
            ++result;
        }
        return result;
    }

    public static boolean startsWithAny(String str, Collection<String> prefixes) {
        if (str == null) {
            return false;
        }
        Iterator<String> iter = prefixes.iterator();
        while (iter.hasNext()) {
            if (!str.startsWith(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAny(String str, String[] prefixes) {
        if (str == null) {
            return false;
        }
        int i = 0;
        while (i < prefixes.length) {
            if (str.startsWith(prefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean endsWithAny(String str, Collection<String> prefixes) {
        if (str == null) {
            return false;
        }
        Iterator<String> iter = prefixes.iterator();
        while (iter.hasNext()) {
            if (!str.endsWith(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(String str, String[] prefixes) {
        if (str == null) {
            return false;
        }
        int i = 0;
        while (i < prefixes.length) {
            if (str.endsWith(prefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String firstUpper(String str) {
        if (str.length() > 0) {
            return str.substring(0, 1).toUpperCase().concat(str.substring(1));
        }
        return "";
    }

    public static String firstLower(String str) {
        if (str.length() > 0) {
            return str.substring(0, 1).toLowerCase().concat(str.substring(1));
        }
        return "";
    }
}

