/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.launching.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.openarchitectureware.workflow.Activator;

public class WFLaunchConfigMainTab
extends JavaLaunchTab {
    private WidgetListener fListener = new WidgetListener();
    private Text projText;
    private Button projButton;
    private Text wfText;
    private Button wfButton;
    private Button stopInMainCheckbox;
    private Button javaDebugCheckbox;
    private Path wfPath;

    public String getName() {
        return "Main";
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.projButton = this.createPushButton(parent, "&Browse...", null);
        this.projText = this.createGroup(comp, "&Project:", this.projButton, null);
        this.createVerticalSpacer(comp, 1);
        this.wfButton = this.createPushButton(parent, "&Search...", null);
        this.stopInMainCheckbox = this.createCheckButton(parent, "St&op in main");
        this.javaDebugCheckbox = this.createCheckButton(parent, "Java Debug");
        this.wfText = this.createGroup(comp, "initial Workflow File", this.wfButton, new Button[]{this.stopInMainCheckbox, this.javaDebugCheckbox});
    }

    private Text createGroup(Composite comp, String title, Button searchButton, Button[] checkButtons) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setText(title);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        Text text = new Text((Composite)group, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setFont(font);
        text.addModifyListener((ModifyListener)this.fListener);
        searchButton.setParent((Composite)group);
        searchButton.addSelectionListener((SelectionListener)this.fListener);
        if (checkButtons != null) {
            Button[] buttonArray = checkButtons;
            int n = checkButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                button.setParent((Composite)group);
                GridData gd = new GridData();
                gd.horizontalSpan = 2;
                button.setLayoutData((Object)gd);
                button.addSelectionListener((SelectionListener)this.fListener);
                ++n2;
            }
        }
        return text;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            this.projText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
            this.setWfText(config.getAttribute("startWorkflow", ""));
            this.stopInMainCheckbox.setSelection(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false));
            this.javaDebugCheckbox.setSelection(config.getAttribute("java_debug", false));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void setWfText(String fullName) {
        this.wfPath = new Path(fullName);
        String projectName = this.projText.getText().trim();
        int pos = fullName.indexOf(projectName);
        if (projectName.length() > 0 && pos >= 0) {
            this.wfText.setText(fullName.substring(pos + projectName.length() + 1));
        } else {
            this.wfText.setText(fullName);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projText.getText().trim());
        config.setAttribute("startWorkflow", this.wfPath.toString());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, this.stopInMainCheckbox.getSelection());
        config.setAttribute("java_debug", this.javaDebugCheckbox.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String text = this.wfText.getText().trim();
        if (text.length() > 0) {
            if (this.getWorkspaceRoot().findMember((IPath)this.wfPath) == null) {
                this.setErrorMessage("Specified file does not exist");
                return false;
            }
        } else {
            this.setMessage("Specify a workflow file");
        }
        return super.isValid(launchConfig);
    }

    private void handleWfButtonSelected() {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)this.getWorkspaceRoot(), 1);
        dialog.setTitle("select starting workflow file");
        dialog.setMessage("select starting workflow file");
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.setWfText(file.getFullPath().toString());
        }
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.projText.setText(projectName);
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Select a project to constrain your search.");
        try {
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects());
        }
        catch (JavaModelException jme) {
            Activator.logError((Exception)((Object)jme));
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            WFLaunchConfigMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WFLaunchConfigMainTab.this.projButton) {
                WFLaunchConfigMainTab.this.handleProjectButtonSelected();
            } else if (source == WFLaunchConfigMainTab.this.wfButton) {
                WFLaunchConfigMainTab.this.handleWfButtonSelected();
            } else {
                WFLaunchConfigMainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

