/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.openarchitectureware.debug.model.SyntaxElementTO;
import org.openarchitectureware.workflow.util.PluginConfigurationElementUtil;

public class OawBreakpoint
extends LineBreakpoint {
    public static final String DEBUG_MODEL_ID = "org.openarchitectureware.debug.model";
    public static final String RESOURCE = "resource";
    public static final String NAME = "name";
    public static final String ELEMENT_NAME = "element";

    public OawBreakpoint() {
    }

    public OawBreakpoint(final IResource resource, final String elementName, final int lineNumber, final int start, final int end) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(OawBreakpoint.this.getMarkerId());
                OawBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("charStart", start);
                marker.setAttribute("charEnd", end);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)OawBreakpoint.this.getModelIdentifier());
                marker.setAttribute(OawBreakpoint.RESOURCE, (Object)resource.getFullPath().toString());
                marker.setAttribute(OawBreakpoint.NAME, (Object)resource.getName());
                marker.setAttribute(OawBreakpoint.ELEMENT_NAME, (Object)elementName);
                marker.setAttribute("message", (Object)OawBreakpoint.this.getName());
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public String getModelIdentifier() {
        return DEBUG_MODEL_ID;
    }

    public String getName() {
        return String.valueOf(this.getMarker().getAttribute(NAME, "")) + " [line: " + this.getMarker().getAttribute("lineNumber", 0) + "] - " + this.getMarker().getAttribute(ELEMENT_NAME, "");
    }

    public int getLine() {
        return this.getMarker().getAttribute("lineNumber", 0);
    }

    public int getOffset() {
        return this.getMarker().getAttribute("charStart", 0);
    }

    public String getResource() {
        return this.getMarker().getAttribute(RESOURCE, "");
    }

    public SyntaxElementTO createTO() {
        SyntaxElementTO se = new SyntaxElementTO();
        se.resource = this.getResource();
        se.line = this.getLine();
        se.start = this.getOffset();
        return se;
    }

    public boolean equals(int start, String resource) {
        return this.getOffset() == start && this.getResource().endsWith(resource);
    }

    private String getMarkerId() {
        return PluginConfigurationElementUtil.getConfigAttribute("org.eclipse.debug.core.breakpoints/breakpoint[class=" + ((Object)((Object)this)).getClass().getName() + "]/markerType");
    }
}

