/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.sourcelookup;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.openarchitectureware.debug.sourcelookup.PackageFragmentRootContainer;
import org.openarchitectureware.debug.sourcelookup.SourceFolderSourceContainer;
import org.openarchitectureware.workflow.Activator;

public class OawSourceLookupUtil {
    private static IJavaModel model;

    public static ISourceContainer[] translate(IRuntimeClasspathEntry[] entries) {
        ArrayList<PackageFragmentRootContainer> containers = new ArrayList<PackageFragmentRootContainer>(entries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            Object container = null;
            switch (entry.getType()) {
                case 2: {
                    IPackageFragmentRoot root = OawSourceLookupUtil.getPackageFragmentRoot(entry);
                    if (root == null) {
                        String path = entry.getLocation();
                        File file = new File(path);
                        if (file.isDirectory()) {
                            IResource resource = entry.getResource();
                            if (resource instanceof IContainer) {
                                container = new FolderSourceContainer((IContainer)resource, false);
                                break;
                            }
                            container = new DirectorySourceContainer(file, false);
                            break;
                        }
                        container = new ExternalArchiveSourceContainer(path, true);
                        break;
                    }
                    container = new PackageFragmentRootContainer(root);
                    break;
                }
                case 1: {
                    IResource resource = entry.getResource();
                    if (resource == null || resource.getType() != 4) break;
                    IJavaProject javaProject = JavaCore.create((IProject)((IProject)resource));
                    if (javaProject.exists()) {
                        container = new SourceFolderSourceContainer(javaProject);
                        break;
                    }
                    if (!resource.exists()) break;
                    container = new ProjectSourceContainer((IProject)resource, false);
                    break;
                }
            }
            if (container != null && !containers.contains(container)) {
                containers.add((PackageFragmentRootContainer)((Object)container));
            }
            ++n2;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IRuntimeClasspathEntry entry) {
        IJavaProject jp;
        IResource resource = entry.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            jp = JavaCore.create((IProject)project);
            if (project.isOpen() && jp.exists()) {
                IPackageFragmentRoot root = jp.getPackageFragmentRoot(resource);
                return root;
            }
        }
        if (model == null) {
            model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        }
        Path reqPath = resource == null ? new Path(entry.getLocation()) : entry.getPath();
        try {
            IJavaProject[] iJavaProjectArray = model.getJavaProjects();
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                jp = iJavaProjectArray[n2];
                if (jp.getProject().isOpen()) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getPackageFragmentRoots();
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        if (root.isExternal() && root.getPath().equals((Object)reqPath)) {
                            return root;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.logError((Exception)((Object)e));
        }
        return null;
    }
}

