/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.sourcelookup;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;

public class SourceFolderSourceContainer
extends CompositeSourceContainer {
    private IJavaProject fProject;
    private ISourceContainer[] fSourceFolders;
    public static final String TYPE_ID = "org.openarchitectureware.workflow.sourceFolderSourceContainer";

    public SourceFolderSourceContainer(IJavaProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        this.fProject = project;
    }

    public String getName() {
        return this.fProject.getElementName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.fSourceFolders == null) {
            ArrayList<FolderSourceContainer> containers = new ArrayList<FolderSourceContainer>();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.fProject.getProject().isOpen()) {
                IClasspathEntry[] entries = this.fProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    switch (entry.getEntryKind()) {
                        case 3: {
                            IPath path = entry.getPath();
                            IResource resource = root.findMember(path);
                            if (!(resource instanceof IContainer)) break;
                            containers.add(new FolderSourceContainer((IContainer)resource, false));
                        }
                    }
                    ++i;
                }
            }
            this.fSourceFolders = containers.toArray(new ISourceContainer[containers.size()]);
        }
        return this.fSourceFolders;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaProjectSourceContainer) {
            return this.fProject.equals(obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fProject.hashCode();
    }

    public Object[] findSourceElements(String name) throws CoreException {
        this.getSourceContainers();
        return this.findSourceElements(name, this.fSourceFolders);
    }

    public void dispose() {
        this.fSourceFolders = null;
        super.dispose();
    }
}

