/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.openarchitectureware.debug.breakpoint.actions.BreakpointActionGroup;
import org.openarchitectureware.workflow.editors.ColorManager;
import org.openarchitectureware.workflow.editors.XMLConfiguration;
import org.openarchitectureware.workflow.editors.XMLDocumentProvider;
import org.openarchitectureware.workflow.editors.outline.EditorContentOutlinePage;

public class WorkflowEditor
extends TextEditor {
    private ColorManager colorManager = new ColorManager();
    private BreakpointActionGroup actionGroup;
    private EditorContentOutlinePage outlinePage;

    public WorkflowEditor() {
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        this.actionGroup = new BreakpointActionGroup(this);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("oaw"));
        super.editorContextMenuAboutToShow(menu);
        this.actionGroup.fillContextMenu(menu);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("oaw"));
        super.rulerContextMenuAboutToShow(menu);
        this.actionGroup.fillContextMenu(menu);
    }

    public ISourceViewer internalGetSourceViewer() {
        return this.getSourceViewer();
    }

    public IVerticalRuler internalGetVerticalRuler() {
        return this.getVerticalRuler();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new EditorContentOutlinePage((ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.outlinePage.setInput(this.getEditorInput());
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        if (this.outlinePage != null) {
            this.outlinePage.setInput(newInput);
        }
    }

    protected void editorSaved() {
        super.editorSaved();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }
}

