/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors.outline;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.openarchitectureware.workflow.editors.parser.XMLAttribute;
import org.openarchitectureware.workflow.editors.parser.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OutlineContentHandler
extends DefaultHandler
implements ContentHandler {
    private XMLElement rootElement;
    private XMLElement dtdElement;
    private Locator locator;
    private IDocument document;
    private String positionCategory;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String namespace, String localname, String qName, Attributes attributes) throws SAXException {
        int lineNumber = this.locator.getLineNumber() - 1;
        XMLElement element = new XMLElement(localname);
        int startPosition = this.getOffsetFromLine(lineNumber);
        Position position = new Position(startPosition);
        this.addPosition(position);
        element.setPosition(position);
        if (this.rootElement == null) {
            this.rootElement = element;
        }
        if (attributes != null) {
            int attributeLength = attributes.getLength();
            int i = 0;
            while (i < attributeLength) {
                String value = attributes.getValue(i);
                String localName = attributes.getLocalName(i);
                element.addChildAttribute(new XMLAttribute(localName, value));
                ++i;
            }
        }
        if (this.dtdElement != null) {
            this.dtdElement.addChildElement(element);
        }
        this.dtdElement = element;
    }

    public void endElement(String namespace, String localname, String qName) throws SAXException {
        int lineNumber = this.locator.getLineNumber();
        int endPosition = this.getOffsetFromLine(lineNumber);
        if (this.dtdElement != null) {
            Position position = this.dtdElement.getPosition();
            int length = endPosition - position.getOffset();
            position.setLength(length);
            this.dtdElement = this.dtdElement.getParent();
        }
    }

    private void addPosition(Position position) {
        try {
            this.document.addPosition(this.positionCategory, position);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    private int getOffsetFromLine(int lineNumber) {
        int offset = 0;
        try {
            offset = this.document.getLineOffset(lineNumber);
        }
        catch (BadLocationException badLocationException) {
            try {
                offset = this.document.getLineOffset(lineNumber - 1);
            }
            catch (BadLocationException badLocationException2) {}
        }
        return offset;
    }

    public XMLElement getRootElement() {
        return this.rootElement;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setPositionCategory(String positionCategory) {
        this.positionCategory = positionCategory;
    }
}

