/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors.parser;

import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.workflow.editors.parser.XMLValidationError;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationErrorHandler
extends DefaultHandler {
    private List<XMLValidationError> errorList = new ArrayList<XMLValidationError>();
    private Locator locator;

    public void error(SAXParseException e) throws SAXException {
        this.handleError(e, false);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void handleError(SAXParseException e, boolean isFatal) {
        XMLValidationError validationError = this.nextError(e, isFatal);
        this.errorList.add(validationError);
        System.out.println(validationError.toString());
    }

    protected XMLValidationError nextError(SAXParseException e, boolean isFatal) {
        String errorMessage = e.getMessage();
        int lineNumber = this.locator.getLineNumber();
        int columnNumber = this.locator.getColumnNumber();
        this.log(this, String.valueOf(isFatal ? "FATAL " : "Non-Fatal") + "Error on line " + lineNumber + ", column " + columnNumber + ": " + errorMessage);
        XMLValidationError validationError = new XMLValidationError();
        validationError.setLineNumber(lineNumber);
        validationError.setColumnNumber(columnNumber);
        validationError.setErrorMessage(errorMessage);
        return validationError;
    }

    private void log(XMLValidationErrorHandler handler, String string) {
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.handleError(e, true);
    }

    public List getErrorList() {
        return this.errorList;
    }
}

