/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.openarchitectureware.workflow.util.ResourceLoaderDefaultImpl;

public class ProjectIncludingResourceLoader
extends ResourceLoaderDefaultImpl {
    private ClassLoader projectCL;

    public ProjectIncludingResourceLoader(IProject project) throws CoreException {
        this.projectCL = this.createClassLoader(project);
    }

    public ClassLoader createClassLoader(IProject project) throws CoreException {
        IJavaProject jp = JavaCore.create((IProject)project);
        IClasspathEntry[] javacp = jp.getResolvedClasspath(true);
        URL[] url = new URL[javacp.length];
        int i = 0;
        while (i < javacp.length) {
            try {
                url[i] = javacp[i].getPath().toFile().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return new URLClassLoader(url);
    }

    protected URL internalGetResource(String path) {
        URL resource = this.projectCL.getResource(path);
        if (resource == null) {
            resource = super.internalGetResource(path);
        }
        return resource;
    }

    protected InputStream internalGetResourceAsStream(String path) {
        URL url = this.internalGetResource(path);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

