/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ListenPointHelper;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.net.AbstractAddress;
import org.openorb.net.Address;
import org.openorb.util.ExceptionTool;
import org.openorb.util.Trace;

public class IIOPAddress
extends AbstractAddress
implements Cloneable {
    private InetAddress m_host;
    private String m_host_name;
    private int m_port;
    private Version m_version;
    private int m_orb_type = 0;
    private int m_hash = -1;
    private String m_protocol = "iiop";
    private CodeSetComponentInfo m_codeset_component_info = null;
    private IIOPAddress[] m_alternates = null;
    public static final short MASK_PRI_VERSION = 15;
    public static final short[] PRI_VERSION = new short[]{15, 14, 13};
    public static final short PRI_FLAG_ALTERNATE = 2048;
    public static final short PRI_FLAG_NONPRIMARY = 1024;
    public static final short MASK_PRI_SECURE = 240;
    public static final short PRI_UNSECURE = 240;

    private IIOPAddress() {
    }

    public void setHost(InetAddress host) {
        if (host != null) {
            this.m_host = host;
            this.m_host_name = host.getHostName();
            this.m_hash = -1;
        }
    }

    public void setPort(int port) {
        if (port != 0) {
            this.m_port = port;
            this.m_hash = -1;
        }
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
        this.m_hash = -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Trace.signalIllegalCondition(null, "Clone operation not supported (" + ex + ").");
            return null;
        }
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String get_hostname() {
        return this.m_host_name;
    }

    public InetAddress get_host() {
        return this.m_host;
    }

    public int get_port() {
        return this.m_port;
    }

    public Version get_version() {
        return this.m_version;
    }

    public int get_orb_type() {
        return this.m_orb_type;
    }

    public CodeSetComponentInfo getCodesetComponentInfo() {
        return this.m_codeset_component_info;
    }

    public Address[] get_alternates() {
        return this.m_alternates;
    }

    public String getEndpointString() {
        return this.m_protocol + ":" + this.m_version.major + "." + this.m_version.minor + "@" + this.m_host_name + ":" + this.m_port;
    }

    public String getEndpointDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getEndpointString());
        if (this.m_host == null) {
            sb.append(" host unknown");
        } else {
            boolean comma = false;
            if (this.getPriority((short)240) != 240) {
                sb.append(" flags: secure(");
                sb.append(this.getPriority((short)240) >> 8);
                sb.append(")");
                comma = true;
            }
            if (this.getPriority((short)1024) == 0) {
                if (comma) {
                    sb.append(", ");
                } else {
                    sb.append(" flags: ");
                }
                sb.append("primary");
                comma = true;
            }
            if (this.getPriority((short)2048) != 0) {
                if (comma) {
                    sb.append(", ");
                } else {
                    sb.append(" flags: ");
                }
                sb.append("alternate");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.m_hash == -1) {
            this.m_hash = super.hashCode() ^ this.m_host.hashCode() ^ this.m_port ^ this.m_protocol.hashCode();
        }
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IIOPAddress)) {
            return false;
        }
        IIOPAddress ia2 = (IIOPAddress)obj;
        if (this.m_port != ia2.m_port || !this.m_host_name.equals(ia2.m_host_name) || !this.m_protocol.equals(ia2.m_protocol) || this.m_version.major != ia2.m_version.major || this.m_version.minor != ia2.m_version.minor) {
            return false;
        }
        return super.equals(obj);
    }

    static IIOPAddress[] get_addresses(Codec codec, IOR ior, int selected_profile, Logger logger) {
        if (ior.profiles[selected_profile].tag != 0) {
            throw new INV_OBJREF("Invalid tag for object reference", 1146056972, CompletionStatus.COMPLETED_NO);
        }
        IIOPAddress addr = new IIOPAddress();
        addr.set_ior(ior, selected_profile);
        byte[] pd = ior.profiles[selected_profile].profile_data;
        if (pd[1] != 1) {
            return new IIOPAddress[0];
        }
        TaggedComponent[] procomp = null;
        try {
            int i;
            TaggedComponent[] cpts;
            switch (pd[2]) {
                case 0: {
                    IDLEntity body = ProfileBody_1_0Helper.extract(codec.decode_value(pd, ProfileBody_1_0Helper.type()));
                    addr.m_version = body.iiop_version;
                    addr.m_host_name = body.host;
                    addr.m_port = body.port & 0xFFFF;
                    addr.set_oid(body.object_key);
                    procomp = new TaggedComponent[]{};
                    break;
                }
                default: {
                    IDLEntity body = ProfileBody_1_1Helper.extract(codec.decode_value(pd, ProfileBody_1_1Helper.type()));
                    addr.m_version = ((ProfileBody_1_1)body).iiop_version;
                    addr.m_host_name = ((ProfileBody_1_1)body).host;
                    addr.m_port = ((ProfileBody_1_1)body).port & 0xFFFF;
                    addr.set_oid(((ProfileBody_1_1)body).object_key);
                    procomp = ((ProfileBody_1_1)body).components;
                    if (addr.m_version.minor <= 2) break;
                    addr.m_version.minor = (byte)2;
                }
            }
            try {
                addr.m_host = InetAddress.getByName(addr.m_host_name);
            }
            catch (UnknownHostException ex) {
                addr.m_host = null;
                addr.m_hash = addr.m_host_name.hashCode() ^ addr.m_port;
            }
            int mcc = 0;
            int i2 = 0;
            while (i2 < ior.profiles.length) {
                if (ior.profiles[i2].tag == 1) {
                    ++mcc;
                }
                ++i2;
            }
            if (mcc == 0) {
                cpts = procomp;
            } else {
                TaggedComponent[][] mcs;
                if (procomp != null) {
                    mcs = new TaggedComponent[mcc + 1][];
                    mcs[mcc] = procomp;
                } else {
                    mcs = new TaggedComponent[mcc][];
                }
                int i3 = 0;
                while (i3 < ior.profiles.length && mcc > 0) {
                    if (ior.profiles[i3].tag == 1) {
                        mcs[--mcc] = TaggedComponentSeqHelper.extract(codec.decode_value(ior.profiles[i3].profile_data, TaggedComponentSeqHelper.type()));
                    }
                    ++i3;
                }
                mcc = 0;
                int i4 = 0;
                while (i4 < mcs.length) {
                    mcc += mcs[i4].length;
                    ++i4;
                }
                cpts = new TaggedComponent[mcc];
                mcc = 0;
                i = 0;
                while (i < mcs.length) {
                    System.arraycopy(mcs[i], 0, cpts, mcc, mcs[i].length);
                    mcc += mcs[i].length;
                    ++i;
                }
            }
            addr.set_components(cpts, procomp.length);
            ORBSingleton sorb = new ORBSingleton();
            short priority = (short)(0x4F0 | PRI_VERSION[pd[2]]);
            ArrayList<ListenPoint> alts = new ArrayList<ListenPoint>();
            i = 0;
            while (i < cpts.length) {
                switch (cpts[i].tag) {
                    case 3: {
                        ListenPoint lp = ListenPointHelper.extract(codec.decode_value(cpts[i].component_data, ListenPointHelper.type()));
                        alts.add(lp);
                        addr.set_component_data(i, new TagAlternateIIOPAddressData(cpts[i].tag, lp.host, lp.port));
                        break;
                    }
                    case 0: {
                        addr.m_orb_type = codec.decode_value(cpts[i].component_data, sorb.get_primitive_tc(TCKind.tk_long)).extract_long();
                        addr.set_component_data(i, new TagOrbTypeData(cpts[i].tag, addr.m_orb_type));
                        break;
                    }
                    case 1: {
                        addr.m_codeset_component_info = CodeSetComponentInfoHelper.extract(codec.decode_value(cpts[i].component_data, CodeSetComponentInfoHelper.type()));
                        addr.set_component_data(i, new TagCodeSetsData(cpts[i].tag, addr.m_codeset_component_info));
                        break;
                    }
                    case 20: {
                        byte[] comp_data = cpts[i].component_data;
                        int supports = comp_data[2] << 8 & 0xFF00 | comp_data[3] & 0xFF;
                        int requires = comp_data[4] << 8 & 0xFF00 | comp_data[5] & 0xFF;
                        int port = comp_data[6] << 8 & 0xFF00 | comp_data[7] & 0xFF;
                        addr.set_component_data(i, new TagSSLSecTransData(cpts[i].tag, port, supports, requires));
                        break;
                    }
                    case 28: {
                        boolean primaryProfile;
                        boolean bl = primaryProfile = cpts[i].component_data[1] != 0;
                        if (primaryProfile) {
                            priority = (short)(priority & 0xFFFFFBFF);
                        }
                        addr.set_component_data(i, new TagFTPrimaryData(cpts[i].tag, primaryProfile));
                        break;
                    }
                    case 29: {
                        boolean heartbeatEnabled = cpts[i].component_data[1] != 0;
                        addr.set_component_data(i, new TagFTHeartbeatEnabledData(cpts[i].tag, heartbeatEnabled));
                        break;
                    }
                    case 2: {
                        throw new NO_IMPLEMENT();
                    }
                }
                ++i;
            }
            addr.setPriority(priority);
            IIOPAddress[] addrs = new IIOPAddress[1 + alts.size()];
            addrs[0] = addr;
            int i5 = 0;
            while (i5 < alts.size()) {
                ListenPoint lp = (ListenPoint)alts.get(i5);
                addrs[i5 + 1] = (IIOPAddress)addr.clone();
                addrs[i5 + 1].m_host_name = lp.host;
                try {
                    addrs[i5 + 1].m_host = InetAddress.getByName(lp.host);
                }
                catch (UnknownHostException ex) {
                    addrs[i5 + 1].m_host = null;
                    addrs[i5 + 1].m_hash = addrs[i5 + 1].m_host_name.hashCode() ^ addrs[i5 + 1].m_port;
                }
                addrs[i5 + 1].m_port = lp.port & 0xFFFF;
                addrs[i5 + 1].setPriority((short)2048, (short)2048);
                ++i5;
            }
            return addrs;
        }
        catch (FormatMismatch ex) {
            logger.error("Profile data cannot be parsed.", (Throwable)ex);
            throw ExceptionTool.initCause(new INV_OBJREF("Profile data cannot be parsed (" + ex + ")", 1146056973, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        catch (TypeMismatch ex) {
            logger.error("Profile data cannot be parsed.", (Throwable)ex);
            throw ExceptionTool.initCause(new INV_OBJREF("Profile data cannot be parsed (" + ex + ")", 1146056973, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
    }

    private static final class TagSSLSecTransData
    extends AbstractTagData {
        private final int m_port;
        private final int m_serverSupports;
        private final int m_serverRequires;

        private TagSSLSecTransData(int componentId, int port, int server_supports, int server_requires) {
            super(componentId);
            this.m_port = port;
            this.m_serverSupports = server_supports;
            this.m_serverRequires = server_requires;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = super.createMessage();
            buf.append(" TAG_SSL_SEC_TRANS");
            buf.append("\n    SSL Port: ");
            buf.append(this.m_port & 0xFFFF);
            buf.append(" (");
            this.appendIntAsHex(buf, this.m_port);
            buf.append(") ");
            buf.append("\n\tServer Requires: ");
            this.appendIntAsHex(buf, this.m_serverRequires);
            buf.append(" : ");
            this.appendDescription(buf, this.m_serverRequires);
            buf.append("\n\tServer Supports: ");
            this.appendIntAsHex(buf, this.m_serverSupports);
            buf.append(" : ");
            this.appendDescription(buf, this.m_serverSupports);
            return buf;
        }

        private StringBuffer appendDescription(StringBuffer desr, int flags) {
            boolean comma = false;
            if ((flags & 1) != 0) {
                desr.append(" Unprotected Invocation");
                comma = true;
            }
            if ((flags & 2) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" Integrity");
                comma = true;
            }
            if ((flags & 4) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" Confidentiality");
                comma = true;
            }
            if ((flags & 8) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" Detect Replay");
                comma = true;
            }
            if ((flags & 0x10) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" Detect Misordering");
                comma = true;
            }
            switch (flags & 0x60) {
                case 96: {
                    if (comma) {
                        desr.append(",");
                    }
                    desr.append(" Client and Server Authentication");
                    comma = true;
                    break;
                }
                case 64: {
                    if (comma) {
                        desr.append(",");
                    }
                    desr.append(" Client Authentication");
                    comma = true;
                    break;
                }
                case 32: {
                    if (comma) {
                        desr.append(",");
                    }
                    desr.append(" Server Authentication");
                    comma = true;
                }
            }
            if ((flags & 0x80) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" No Delegation");
                comma = true;
            }
            if ((flags & 0x100) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" Simple Delegation");
                comma = true;
            }
            if ((flags & 0x200) != 0) {
                if (comma) {
                    desr.append(",");
                }
                desr.append(" No Delegation");
            }
            return desr;
        }
    }

    private static final class TagAlternateIIOPAddressData
    extends AbstractTagData {
        private final String m_host;
        private final short m_port;

        private TagAlternateIIOPAddressData(int componentId, String host, short port) {
            super(componentId);
            this.m_host = host;
            this.m_port = port;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = super.createMessage();
            buf.append(" TAG_ALTERNATE_IIOP_ADDRESS\n");
            buf.append("\tHost: " + this.m_host);
            buf.append("\n\tPort: " + (this.m_port & 0xFFFF));
            return buf;
        }
    }

    private static final class TagOrbTypeData
    extends AbstractTagData {
        private final int m_orbType;

        private TagOrbTypeData(int componentId, int orbType) {
            super(componentId);
            this.m_orbType = orbType;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = super.createMessage();
            buf.append(" TAG_ORB_TYPE\n\tORB Type: ");
            this.appendIntAsHex(buf, this.m_orbType);
            return buf;
        }
    }

    private static final class TagCodeSetsData
    extends AbstractTagData {
        private final CodeSetComponentInfo m_info;

        private TagCodeSetsData(int componentId, CodeSetComponentInfo info) {
            super(componentId);
            this.m_info = info;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = super.createMessage();
            buf.append(" TAG_CODE_SETS\n    For char data: ");
            int cs = this.m_info.ForCharData.native_code_set;
            int j = 0;
            while (j <= this.m_info.ForCharData.conversion_code_sets.length) {
                buf.append("\n        ");
                buf.append(cs == this.m_info.ForCharData.native_code_set ? "SNCS" : "SCCS");
                buf.append(":");
                this.appendIntAsHex(buf, cs);
                buf.append(" '");
                buf.append(CodeSetDatabase.getNameFromId(cs));
                buf.append("' '");
                buf.append(CodeSetDatabase.getDescriptionFromId(cs));
                buf.append("'");
                if (j < this.m_info.ForCharData.conversion_code_sets.length) {
                    cs = this.m_info.ForCharData.conversion_code_sets[j];
                }
                ++j;
            }
            buf.append("\n    For wchar data: ");
            cs = this.m_info.ForWcharData.native_code_set;
            int j2 = 0;
            while (j2 <= this.m_info.ForWcharData.conversion_code_sets.length) {
                buf.append("\n        ");
                buf.append(cs == this.m_info.ForWcharData.native_code_set ? "SNCS" : "SCCS");
                buf.append(":");
                this.appendIntAsHex(buf, cs);
                buf.append(" '");
                buf.append(CodeSetDatabase.getNameFromId(cs));
                buf.append("' '");
                buf.append(CodeSetDatabase.getDescriptionFromId(cs));
                buf.append("'");
                if (j2 < this.m_info.ForWcharData.conversion_code_sets.length) {
                    cs = this.m_info.ForWcharData.conversion_code_sets[j2];
                }
                ++j2;
            }
            return buf;
        }
    }

    private static final class TagFTPrimaryData
    extends AbstractTagData {
        private final boolean m_primaryProfile;

        private TagFTPrimaryData(int componentId, boolean primaryProfile) {
            super(componentId);
            this.m_primaryProfile = primaryProfile;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = super.createMessage();
            buf.append(" FT.TAG_FT_PRIMARY\n\t" + (this.m_primaryProfile ? " Primary " : " NonPrimary "));
            buf.append("profile");
            return buf;
        }
    }

    private static final class TagFTHeartbeatEnabledData
    extends AbstractTagData {
        private final boolean m_heartbeatEnabled;

        private TagFTHeartbeatEnabledData(int componentId, boolean heartbeatEnabled) {
            super(componentId);
            this.m_heartbeatEnabled = heartbeatEnabled;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = super.createMessage();
            buf.append(" TAG_FT_HEARTBEAT_ENABLED\n\tHeartbeat ");
            buf.append(this.m_heartbeatEnabled ? "enabled" : "disabled");
            return buf;
        }
    }

    private static abstract class AbstractTagData {
        private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final int DIGIT_MASK = 15;
        private final int m_componentId;
        private String m_msg;

        protected AbstractTagData(int componentId) {
            this.m_componentId = componentId;
        }

        protected StringBuffer createMessage() {
            StringBuffer buf = new StringBuffer();
            buf.append("ComponentID = ");
            buf.append(this.m_componentId);
            return buf;
        }

        protected final void appendIntAsHex(StringBuffer buf, int value) {
            buf.ensureCapacity(buf.length() + 10);
            buf.append("0x");
            int i = 28;
            while (i >= 0) {
                buf.append(HEX_DIGITS[value >> i & 0xF]);
                i -= 4;
            }
        }

        public synchronized String toString() {
            if (null == this.m_msg) {
                this.m_msg = this.createMessage().toString();
            }
            return this.m_msg;
        }
    }
}

