/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ListenPointHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.CORBA.kernel.Property;
import org.openorb.PI.CodecFactoryManager;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.PI.FeatureInitializer;
import org.openorb.PI.SimpleIORInterceptor;
import org.openorb.iiop.CDRCodecFactory;
import org.openorb.iiop.CodeSetDatabaseInitializer;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.iiop.IIOPServerRequest;
import org.openorb.iiop.IIOPTransportServerInitializer;
import org.openorb.net.ClientManager;
import org.openorb.net.ServerManager;
import org.openorb.net.TransportClientInitializer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.Trace;

public class IIOPProtocolInitializer
extends AbstractLogEnabled
implements FeatureInitializer {
    private static final ServerRequestInterceptor BIDIR_INTERCEPTOR = new BiDirServerInterceptor();
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ORBInitInfo;
    static /* synthetic */ Class class$org$openorb$PI$FeatureInitInfo;

    public void init(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        if (this.getLogger().isErrorEnabled() && Trace.isLow()) {
            this.getLogger().debug("init");
        }
        CodeSetDatabaseInitializer csdb = new CodeSetDatabaseInitializer();
        csdb.enableLogging(this.getLogger().getChildLogger("csdb"));
        csdb.initialize();
        featureinfo.setFeature("CodeSetDatabase", csdb);
        ORB orb = featureinfo.orb();
        CDRCodecFactory codec_factory = new CDRCodecFactory(orb);
        Codec codec = null;
        CodecFactoryManager cfm = (CodecFactoryManager)featureinfo.getFeature("CodecFactoryManager");
        if (cfm != null) {
            cfm.register_codec_factory(new Encoding(0, 1, 0), codec_factory);
            cfm.register_codec_factory(new Encoding(0, 1, 1), codec_factory);
            Encoding enc = new Encoding(0, 1, 2);
            cfm.register_codec_factory(enc, codec_factory);
            try {
                codec = codec_factory.create_codec(enc);
            }
            catch (Exception ex) {
                this.getLogger().error("Error during create_codec().", (Throwable)ex);
                return;
            }
        }
        ServerManager svrmgr = (ServerManager)featureinfo.getFeature("ServerCPCManager");
        ClientManager cltmgr = (ClientManager)featureinfo.getFeature("ClientCPCManager");
        ListenPoint[] biDirListenPoints = null;
        ORBLoader loader = featureinfo.getLoader();
        IIOPServerProtocol svrproto = null;
        if (svrmgr != null) {
            IIOPTransportServerInitializer svrInit;
            Any any = ((org.omg.CORBA.ORB)orb).create_any();
            CodeSetComponentInfo codesetInfo = csdb.getServerCodeSets();
            CodeSetComponentInfoHelper.insert(any, codesetInfo);
            ArrayList<TaggedComponent> iorComponents = new ArrayList<TaggedComponent>();
            try {
                byte[] buf = codec.encode_value(any);
                if (buf != null) {
                    iorComponents.add(new TaggedComponent(1, buf));
                }
            }
            catch (InvalidTypeForEncoding ex) {
                String error = "Unable to encode code set component.";
                this.getLogger().error("Unable to encode code set component.", (Throwable)ex);
                throw ExceptionTool.initCause(new INITIALIZE("Unable to encode code set component."), (Throwable)ex);
            }
            Iterator itt = loader.properties("iiop.alternateAddr");
            while (itt.hasNext()) {
                int port;
                String hostport = ((Property)itt.next()).getValue();
                int idx = hostport.indexOf(58);
                if (idx < 0) continue;
                String host = hostport.substring(0, idx);
                try {
                    port = Integer.parseInt(hostport.substring(idx + 1));
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (port > 65535) continue;
                ListenPoint lp = new ListenPoint(host, (short)port);
                ListenPointHelper.insert(any, lp);
                try {
                    byte[] buf = codec.encode_value(any);
                    if (buf == null) continue;
                    iorComponents.add(new TaggedComponent(3, buf));
                }
                catch (InvalidTypeForEncoding ex) {
                    String error = "Unable to encode alternate endpoint component.";
                    this.getLogger().error("Unable to encode alternate endpoint component.", (Throwable)ex);
                    throw ExceptionTool.initCause(new INITIALIZE("Unable to encode alternate endpoint component."), (Throwable)ex);
                }
            }
            if (!iorComponents.isEmpty()) {
                TaggedComponent[] altAddrComponents = new TaggedComponent[iorComponents.size()];
                iorComponents.toArray(altAddrComponents);
                try {
                    orbinfo.add_ior_interceptor(new SimpleIORInterceptor("codesets and alts", 0, altAddrComponents));
                }
                catch (DuplicateName ex) {
                    // empty catch block
                }
            }
            boolean listen = true;
            if (loader.getBooleanProperty("iiop.allowBiDir", true)) {
                try {
                    orbinfo.add_server_request_interceptor(BIDIR_INTERCEPTOR);
                }
                catch (DuplicateName ex) {
                    // empty catch block
                }
                listen = !loader.getBooleanProperty("iiop.biDirOnlyServer", false);
            }
            try {
                svrInit = (IIOPTransportServerInitializer)loader.constructClass("iiop.TransportServerInitializerClass", "org.openorb.iiop.IIOPTransportServerInitializer", new Object[]{orbinfo, featureinfo}, new Class[]{class$org$omg$PortableInterceptor$ORBInitInfo == null ? (class$org$omg$PortableInterceptor$ORBInitInfo = IIOPProtocolInitializer.class$("org.omg.PortableInterceptor.ORBInitInfo")) : class$org$omg$PortableInterceptor$ORBInitInfo, class$org$openorb$PI$FeatureInitInfo == null ? (class$org$openorb$PI$FeatureInitInfo = IIOPProtocolInitializer.class$("org.openorb.PI.FeatureInitInfo")) : class$org$openorb$PI$FeatureInitInfo});
                if (svrInit instanceof LogEnabled) {
                    ((LogEnabled)svrInit).enableLogging(this.getLogger());
                }
            }
            catch (InvocationTargetException ex) {
                String error = "Unable to initialize TransportServerInitializer.";
                Throwable ex1 = ex.getTargetException();
                this.getLogger().error("Unable to initialize TransportServerInitializer.", ex1);
                if (ex1 instanceof Error) {
                    throw (Error)ex1;
                }
                if (ex1 instanceof RuntimeException) {
                    throw (RuntimeException)ex1;
                }
                throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize TransportServerInitializer (" + ex1 + ")", 0, CompletionStatus.COMPLETED_NO), ex1);
            }
            if (listen) {
                svrInit.open();
            }
            svrproto = new IIOPServerProtocol(svrmgr, codec_factory, svrInit);
            svrmgr.register_protocol(0, svrproto);
            if (listen) {
                svrproto.open();
            }
            biDirListenPoints = svrInit.getBiDirEndpoints();
        }
        IIOPClientProtocol cltproto = null;
        if (cltmgr != null) {
            TransportClientInitializer cltInit;
            try {
                cltInit = (TransportClientInitializer)loader.constructClass("iiop.TransportClientInitializerClass", "org.openorb.iiop.IIOPTransportClientInitializer", new Object[]{orbinfo, featureinfo}, new Class[]{class$org$omg$PortableInterceptor$ORBInitInfo == null ? (class$org$omg$PortableInterceptor$ORBInitInfo = IIOPProtocolInitializer.class$("org.omg.PortableInterceptor.ORBInitInfo")) : class$org$omg$PortableInterceptor$ORBInitInfo, class$org$openorb$PI$FeatureInitInfo == null ? (class$org$openorb$PI$FeatureInitInfo = IIOPProtocolInitializer.class$("org.openorb.PI.FeatureInitInfo")) : class$org$openorb$PI$FeatureInitInfo});
                if (cltInit instanceof LogEnabled) {
                    ((LogEnabled)cltInit).enableLogging(this.getLogger());
                }
            }
            catch (InvocationTargetException ex) {
                String error = "Unable to initialize TransportClientInitializer.";
                this.getLogger().error("Unable to initialize TransportClientInitializer.", ex.getTargetException());
                throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize TransportClientInitializer. (" + ex.getTargetException() + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            cltproto = new IIOPClientProtocol(cltmgr, codec_factory, csdb.getClientCodeSets(), cltInit, biDirListenPoints);
            cltmgr.register_protocol(0, cltproto);
            if (svrproto != null) {
                cltproto.setServerProtocol(svrproto);
                svrproto.setClientProtocol(cltproto);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class BiDirServerInterceptor
    extends LocalObject
    implements ServerRequestInterceptor {
        private BiDirServerInterceptor() {
        }

        public String name() {
            return "IIOPBiDirServerInterceptor";
        }

        public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
            if (ri instanceof IIOPServerRequest) {
                IIOPServerRequest request = (IIOPServerRequest)ri;
                IIOPServerChannel channel = (IIOPServerChannel)request.channel();
                channel.checkBiDirActivation(request);
            }
        }

        public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void send_reply(ServerRequestInfo ri) {
        }

        public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void destroy() {
        }
    }
}

