/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.IIOP.ListenPoint;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.iiop.IIOPTransport;
import org.openorb.net.Transport;
import org.openorb.net.TransportServerInitializer;
import org.openorb.util.ExceptionTool;

public class IIOPTransportServerInitializer
implements TransportServerInitializer {
    private ListenPoint m_primary_endpoint = new ListenPoint();
    private ListenPoint[] m_bidir_endpoints = new ListenPoint[]{this.m_primary_endpoint};
    private InetAddress m_host;
    private ServerSocket m_svr_socket;
    private Logger m_logger;
    private volatile boolean m_closed = true;
    private final boolean m_socketNoDelay;
    private final boolean m_boostRecvPriority;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_bufferedOutputStreamSize;
    private final int m_backlogQueueLength;
    private final int m_maxSocketTimeout;
    private final int m_minSocketTimeout;
    private final int m_overrideSocketTimeout;
    private int m_currentSocketTimeout;
    static /* synthetic */ Class class$org$openorb$iiop$IIOPTransportServerInitializer;

    public IIOPTransportServerInitializer(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        int port;
        ORBLoader loader = featureinfo.getLoader();
        this.m_logger = featureinfo.orb().getLogger();
        this.m_socketNoDelay = loader.getBooleanProperty("iiop.serverNoDelay", true);
        this.m_boostRecvPriority = loader.getBooleanProperty("iiop.boostReceivePriority", false);
        this.m_sendBufferSize = loader.getIntProperty("iiop.sendBufferSize", 0);
        this.m_receiveBufferSize = loader.getIntProperty("iiop.receiveBufferSize", 0);
        this.m_bufferedOutputStreamSize = loader.getIntProperty("iiop.bufferedOutputStreamSize", 0);
        this.m_backlogQueueLength = loader.getIntProperty("iiop.serverBacklogQueueLength", 50);
        this.m_maxSocketTimeout = loader.getIntProperty("iiop.serverMaxSocketAcceptTimeout", 250);
        this.m_minSocketTimeout = (class$org$openorb$iiop$IIOPTransportServerInitializer == null ? (class$org$openorb$iiop$IIOPTransportServerInitializer = IIOPTransportServerInitializer.class$("org.openorb.iiop.IIOPTransportServerInitializer")) : class$org$openorb$iiop$IIOPTransportServerInitializer).equals(this.getClass()) ? loader.getIntProperty("iiop.serverMinSocketAcceptTimeout", 0) : 0;
        this.m_overrideSocketTimeout = loader.getIntProperty("iiop.serverOverrideSocketTimeout", 250);
        this.m_primary_endpoint.host = loader.getStringProperty("iiop.hostname", "");
        if (this.m_primary_endpoint.host.length() == 0) {
            try {
                String publishIP = loader.getStringProperty("iiop.publishIP", "auto");
                if (publishIP.equalsIgnoreCase("auto")) {
                    this.m_primary_endpoint.host = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                    if (this.m_primary_endpoint.host.indexOf(46) < 0) {
                        this.m_primary_endpoint.host = InetAddress.getLocalHost().getHostAddress();
                    }
                } else {
                    this.m_primary_endpoint.host = publishIP.equalsIgnoreCase("true") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
            }
            catch (UnknownHostException ex) {
                this.getLogger().error("Unable to find hostname for local host.", (Throwable)ex);
                throw ExceptionTool.initCause(new INITIALIZE("Unable to find hostname for local host (" + ex + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
        }
        if ((port = loader.getIntProperty("iiop.port", 0)) > 65535 || port < 0) {
            throw new INITIALIZE("Value for server port " + port + " is out of range");
        }
        this.m_primary_endpoint.port = (short)port;
        try {
            this.m_host = InetAddress.getByName(loader.getStringProperty("iiop.listenAddress", "0.0.0.0"));
        }
        catch (UnknownHostException ex) {
            this.getLogger().error("Unable to find address for local listen port.", (Throwable)ex);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to find address for local listen port (" + ex + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
    }

    public void open() {
        if (this.m_svr_socket != null) {
            return;
        }
        this.open_port();
    }

    private void open_port() {
        try {
            int port = this.m_primary_endpoint.port & 0xFFFF;
            this.m_svr_socket = new ServerSocket(port, this.m_backlogQueueLength, this.m_host);
        }
        catch (IOException ex) {
            this.getLogger().error("Unable to listen on " + this.svrString() + " (" + ex + ").", (Throwable)ex);
            throw ExceptionTool.initCause(new COMM_FAILURE("Unable to listen on " + this.svrString() + " (" + ex + ")"), (Throwable)ex);
        }
        catch (SecurityException ex) {
            this.getLogger().error("Access denied for " + this.svrString() + ".", (Throwable)ex);
            throw ExceptionTool.initCause(new NO_PERMISSION("Access denied for " + this.svrString() + " (" + ex + ")"), (Throwable)ex);
        }
        this.m_closed = false;
        if (this.m_primary_endpoint.port == 0) {
            this.m_primary_endpoint.port = (short)this.m_svr_socket.getLocalPort();
        }
    }

    public ListenPoint getPrimaryEndpoint() {
        return this.m_primary_endpoint;
    }

    public ListenPoint[] getBiDirEndpoints() {
        return this.m_bidir_endpoints;
    }

    protected InetAddress getListenHost() {
        return this.m_host;
    }

    public void close() {
        if (this.m_closed || this.m_svr_socket == null) {
            return;
        }
        this.m_closed = true;
        try {
            this.m_svr_socket.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.m_svr_socket = null;
    }

    public boolean isOpen() {
        return !this.m_closed;
    }

    public Transport accept(int timeout) {
        try {
            if (this.m_closed) {
                return null;
            }
            this.setSocketTimeout(timeout);
            try {
                Socket sock = this.m_svr_socket.accept();
                return new IIOPTransport(sock, this.m_primary_endpoint.port & 0xFFFF, this.getLogger(), this.m_socketNoDelay, this.m_boostRecvPriority, this.m_sendBufferSize, this.m_receiveBufferSize, this.m_bufferedOutputStreamSize);
            }
            catch (InterruptedIOException ex) {
                if ("operation interrupted".equals(ex.getMessage())) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
            catch (SocketException ex) {
                return null;
            }
        }
        catch (IOException ex) {
            if (this.m_closed) {
                return null;
            }
            this.getLogger().error("IOException during accept.", (Throwable)ex);
            throw ExceptionTool.initCause(new COMM_FAILURE(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSocketTimeout(int timeout) throws SocketException {
        ServerSocket serverSocket = this.m_svr_socket;
        synchronized (serverSocket) {
            int n = timeout = this.m_minSocketTimeout < timeout && timeout < this.m_maxSocketTimeout ? timeout : this.m_overrideSocketTimeout;
            if (timeout == this.m_currentSocketTimeout) {
                return;
            }
            this.m_svr_socket.setSoTimeout(timeout);
            this.m_currentSocketTimeout = timeout;
        }
    }

    public String toString() {
        return "(iiop) " + this.svrString();
    }

    protected String svrString() {
        return "" + this.m_host + ":" + (this.m_primary_endpoint.port & 0xFFFF);
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

