/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerProtocol;
import org.openorb.net.ServerRequest;
import org.openorb.util.ExceptionTool;
import org.openorb.util.MergeStack;
import org.openorb.util.Trace;

public class ServerManagerImpl
implements ServerManager {
    private static final byte SEP_VAL = -2;
    private static final byte ESC_VAL = -3;
    private static final byte FLAG_PUID = 1;
    private byte[] m_process_uid;
    private byte[] m_server_uid;
    private org.omg.CORBA.ORB m_orb;
    private ThreadGroup m_root_group;
    private final Object m_sync_io = new Object();
    private ThreadGroup m_io_threads;
    private static ThreadGroup s_static_io_threads;
    private boolean m_use_static_thread_group;
    private Object[] m_protocol_profile_ids = new Object[0];
    private Map m_protocol_to_worker = new HashMap();
    private Map m_channels = new HashMap();
    private Thread m_channel_reaper = null;
    private int m_channel_closing_time;
    private static final int DEFAULT_CLOSE_TIME = 600000;
    private Object m_sync_state = new Object();
    private volatile boolean m_shutdown = false;
    private volatile boolean m_running = false;
    private volatile boolean m_io_complete = false;
    private ObjectAdapter m_default_adapter = null;
    private Map m_adapter_cache = new HashMap();
    private volatile int m_active_requests = 0;
    private volatile int m_holding_requests = 0;
    private Object m_sync_queue = new Object();
    private MergeStack m_requests = new MergeStack();
    private int m_tp_max_active_requests = 0;
    private int m_tp_previous_max_active_requests = 0;
    private int m_max_queue_size = 0;
    private int m_max_mgr_held_requests = 0;
    private Thread m_single_thread = null;
    private MergeStack m_waiting_requests = new MergeStack();
    private int m_thread_pool_size = 0;
    private Set m_server_threads = new HashSet();
    private boolean m_allow_pool = false;
    private ThreadGroup m_pool_threads;
    private static ThreadGroup s_static_pool_threads;
    private Thread[] m_pool_thread_array = new Thread[10];
    private int m_max_thread_pool_size = 5;
    private int m_min_thread_pool_size = 1;
    private int m_opt_thread_pool_size = 0;
    private Logger m_logger;
    private static final int POOL_ID_WAIT = -1;
    private static final int POOL_ID_NO_WAIT = -2;

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    private static SystemException createQueueFullException() {
        return new TRANSIENT(1146056705, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createDiscardException() {
        return new TRANSIENT(1330446337, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createInactiveException() {
        return new OBJ_ADAPTER(1330446337, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createDestroyedException() {
        return new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
    }

    private static SystemException createShutdownException() {
        return new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_NO);
    }

    public ServerManagerImpl(org.omg.CORBA.ORB orb) {
        this.m_orb = orb;
        this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        ORBLoader loader = ((ORB)orb).getLoader();
        try {
            byte[] ssuid = loader.getStringProperty("openorb.server.alias", "").getBytes("UTF-8");
            this.m_server_uid = new byte[ssuid.length + 1];
            System.arraycopy(ssuid, 0, this.m_server_uid, 0, ssuid.length);
            this.m_server_uid[ssuid.length] = -2;
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Encoding not supported.", (Throwable)ex);
            throw ExceptionTool.initCause(new INITIALIZE("Encoding not supported (" + ex + ")"), (Throwable)ex);
        }
        this.m_max_queue_size = loader.getIntProperty("openorb.server.maxQueueSize", Integer.MAX_VALUE);
        this.m_max_mgr_held_requests = loader.getIntProperty("openorb.server.maxManagerHeldRequests", Integer.MAX_VALUE);
        this.m_min_thread_pool_size = loader.getIntProperty("openorb.server.minThreadPoolSize", 1);
        this.m_max_thread_pool_size = loader.getIntProperty("openorb.server.maxThreadPoolSize", 10);
        this.m_root_group = Thread.currentThread().getThreadGroup();
        long time = System.currentTimeMillis();
        this.m_process_uid = new byte[8];
        this.m_process_uid[7] = (byte)(time >>> 56);
        this.m_process_uid[6] = (byte)(time >>> 48);
        this.m_process_uid[5] = (byte)(time >>> 40);
        this.m_process_uid[4] = (byte)(time >>> 32);
        this.m_process_uid[3] = (byte)(time >>> 24);
        this.m_process_uid[2] = (byte)(time >>> 16);
        this.m_process_uid[1] = (byte)(time >>> 8);
        this.m_process_uid[0] = (byte)time;
        this.m_channel_closing_time = loader.getIntProperty("openorb.server.reapCloseDelay", 600000);
        this.m_use_static_thread_group = loader.getBooleanProperty("openorb.useStaticThreadGroup", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPoolLimits(int min, int max) {
        if (min < 0 || max < 0 || min > max) {
            throw new IllegalArgumentException("Invalid thread pool size range");
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            this.m_min_thread_pool_size = min;
            this.m_max_thread_pool_size = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("Invalid max queue size");
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            this.m_max_queue_size = maxQueueSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxManagerHeldRequests(int maxManagerHeldRequests) {
        if (maxManagerHeldRequests < 0) {
            throw new IllegalArgumentException("Invalid max held requests");
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            this.m_max_mgr_held_requests = maxManagerHeldRequests;
        }
    }

    public byte[] create_cacheable_object_key(boolean use_suid, byte[][] parts) {
        int pos;
        int len = 4 + (use_suid ? this.m_server_uid.length : this.m_process_uid.length) + parts.length - 1;
        int escs = 0;
        int i = 0;
        while (i < parts.length) {
            len += parts[i].length;
            int j = 0;
            while (j < parts[i].length) {
                switch (parts[i][j]) {
                    case -3: 
                    case -2: {
                        ++escs;
                    }
                }
                ++j;
            }
            ++i;
        }
        byte[] object_key = new byte[len += escs];
        object_key[0] = 0;
        object_key[1] = 79;
        object_key[2] = 79;
        if (use_suid) {
            object_key[3] = 0;
            System.arraycopy(this.m_server_uid, 0, object_key, 4, this.m_server_uid.length);
            pos = 4 + this.m_server_uid.length;
        } else {
            object_key[3] = 1;
            System.arraycopy(this.m_process_uid, 0, object_key, 4, this.m_process_uid.length);
            pos = 4 + this.m_process_uid.length;
        }
        int p = 0;
        while (p < parts.length && escs > 0) {
            int i2 = 0;
            while (i2 < parts[p].length) {
                switch (parts[p][i2]) {
                    case -3: 
                    case -2: {
                        object_key[pos++] = -3;
                        --escs;
                    }
                }
                object_key[pos] = parts[p][i2];
                ++i2;
                ++pos;
            }
            if (pos < object_key.length) {
                object_key[pos++] = -2;
            }
            ++p;
        }
        while (p < parts.length) {
            System.arraycopy(parts[p], 0, object_key, pos, parts[p].length);
            if ((pos += parts[p].length) < object_key.length) {
                object_key[pos++] = -2;
            }
            ++p;
        }
        return object_key;
    }

    public byte[][] extract_cacheable_object_key(byte[] object_key) {
        int[] offsets = this.find_object_key_offsets(object_key);
        if (offsets == null) {
            return null;
        }
        byte[][] parts = new byte[offsets.length][];
        int end = object_key.length;
        int i = parts.length - 1;
        while (i >= 0) {
            int begin = offsets[i];
            int escs = 0;
            int j = begin;
            while (j < end) {
                if (object_key[j] == -3) {
                    ++j;
                    ++escs;
                }
                ++j;
            }
            parts[i] = new byte[end - begin - escs];
            if (escs == 0) {
                System.arraycopy(object_key, begin, parts[i], 0, end - begin);
            } else {
                int j2 = begin;
                int k = 0;
                while (j2 < end) {
                    if (object_key[j2] == -3) {
                        ++j2;
                    }
                    parts[i][k] = object_key[j2];
                    ++j2;
                    ++k;
                }
            }
            end = begin - 1;
            --i;
        }
        return parts;
    }

    private int[] find_object_key_offsets(byte[] object_key) {
        if (!this.is_local_cacheable_object_key(object_key)) {
            return null;
        }
        int start = 4;
        start = (object_key[3] & 1) == 1 ? (start += this.m_process_uid.length) : (start += this.m_server_uid.length);
        int parts = 1;
        int i = start;
        while (i < object_key.length) {
            switch (object_key[i]) {
                case -2: {
                    ++parts;
                    break;
                }
                case -3: {
                    ++i;
                }
            }
            ++i;
        }
        int[] offsets = new int[parts];
        offsets[0] = start;
        int upto = 1;
        int i2 = start;
        while (i2 < object_key.length && upto < offsets.length) {
            switch (object_key[i2]) {
                case -2: {
                    offsets[upto++] = i2 + 1;
                    break;
                }
                case -3: {
                    ++i2;
                }
            }
            ++i2;
        }
        return offsets;
    }

    public boolean is_cacheable_object_key(byte[] object_key) {
        return object_key.length >= 4 && object_key[0] == 0 && object_key[1] == 79 && object_key[2] == 79;
    }

    public boolean is_suid_object_key(byte[] object_key) {
        return object_key.length >= 4 && (object_key[3] & 1) == 0;
    }

    public boolean is_local_cacheable_object_key(byte[] object_key) {
        if (!this.is_cacheable_object_key(object_key)) {
            return false;
        }
        if ((object_key[3] & 1) == 1) {
            if (object_key.length - 4 < this.m_process_uid.length) {
                return false;
            }
            int i = 0;
            while (i < this.m_process_uid.length) {
                if (object_key[i + 4] != this.m_process_uid[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            if (object_key.length - 4 < this.m_server_uid.length) {
                return false;
            }
            int i = 0;
            while (i < this.m_server_uid.length) {
                if (object_key[i + 4] != this.m_server_uid[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void register_protocol(int profile_tag, ServerProtocol protocol) {
        if (protocol == null) {
            return;
        }
        int i = 0;
        while (i < this.m_protocol_profile_ids.length) {
            if (this.m_protocol_profile_ids[i] == protocol && profile_tag == (Integer)this.m_protocol_profile_ids[i + 1]) {
                return;
            }
            ++i;
        }
        Object[] tmp = new Object[this.m_protocol_profile_ids.length + 2];
        System.arraycopy(this.m_protocol_profile_ids, 0, tmp, 0, this.m_protocol_profile_ids.length);
        tmp[this.m_protocol_profile_ids.length] = protocol;
        tmp[this.m_protocol_profile_ids.length + 1] = new Integer(profile_tag);
        this.m_protocol_profile_ids = tmp;
    }

    public Object[] get_protocol_ids() {
        return this.m_protocol_profile_ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protocol_listening(ServerProtocol protocol) {
        Object object = this.m_sync_io;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            if (this.m_io_threads == null || this.m_io_threads.isDestroyed()) {
                if (this.m_use_static_thread_group) {
                    if (s_static_io_threads == null || s_static_io_threads.isDestroyed()) {
                        s_static_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                    }
                    this.m_io_threads = s_static_io_threads;
                } else {
                    this.m_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                }
            }
            Thread p = new Thread(this.m_io_threads, new ProtocolRunner(protocol), "Worker for " + protocol.toString());
            p.setDaemon(true);
            p.start();
            this.m_protocol_to_worker.put(protocol, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protocol_not_listening(ServerProtocol protocol, boolean paused) {
        Thread thread;
        Object object = this.m_sync_io;
        synchronized (object) {
            if (paused) {
                thread = (Thread)this.m_protocol_to_worker.get(protocol);
                if (thread != null) {
                    this.m_protocol_to_worker.put(protocol, null);
                }
            } else {
                thread = (Thread)this.m_protocol_to_worker.remove(protocol);
            }
        }
        if (thread != null) {
            Thread curr = Thread.currentThread();
            thread.interrupt();
            while (thread != curr && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_channel(ServerChannel channel) {
        Object object = this.m_sync_io;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            if (this.m_channels.containsKey(channel)) {
                return;
            }
            if (this.m_io_threads == null || this.m_io_threads.isDestroyed()) {
                if (this.m_use_static_thread_group) {
                    if (s_static_io_threads == null || s_static_io_threads.isDestroyed()) {
                        s_static_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                    }
                    this.m_io_threads = s_static_io_threads;
                } else {
                    this.m_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                }
            }
            Thread thread = new Thread(this.m_io_threads, new ChannelRecvRunner(channel), "Receive Worker for " + channel.toString());
            thread.setDaemon(true);
            thread.start();
            this.m_channels.put(channel, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister_channel(ServerChannel channel) {
        Thread thread;
        Object object = this.m_sync_io;
        synchronized (object) {
            thread = (Thread)this.m_channels.remove(channel);
        }
        if (thread != null) {
            Thread curr = Thread.currentThread();
            thread.interrupt();
            while (thread != curr && thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channel_reaper() {
        int lasttime = RequestIDAllocator.get_request_id();
        ServerChannel[] chans = new ServerChannel[]{};
        while (!this.m_shutdown) {
            try {
                Thread.sleep(this.m_channel_closing_time);
            }
            catch (InterruptedException ex) {
                return;
            }
            if (this.m_shutdown) {
                return;
            }
            Object object = this.m_sync_queue;
            synchronized (object) {
                this.m_tp_previous_max_active_requests = this.m_tp_max_active_requests;
                this.m_tp_max_active_requests = this.m_active_requests;
                this.recalcOptThreadPoolSize();
                if (this.m_opt_thread_pool_size < this.m_thread_pool_size) {
                    this.m_sync_queue.notifyAll();
                }
            }
            Object object2 = this.m_sync_io;
            synchronized (object2) {
                if (this.m_channels.isEmpty()) {
                    continue;
                }
                chans = this.m_channels.keySet().toArray(chans);
            }
            int i = 0;
            while (i < chans.length && chans[i] != null) {
                if (chans[i].channel_age() < lasttime) {
                    chans[i].soft_close(false);
                }
                ++i;
            }
            lasttime = RequestIDAllocator.get_request_id();
        }
    }

    public ObjectAdapter find_adapter(byte[] object_key) {
        return this.find_adapter(object_key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectAdapter find_adapter(byte[] object_key, ServerRequest request) {
        if (!this.is_cacheable_object_key(object_key)) {
            return this.m_default_adapter;
        }
        if (!this.is_local_cacheable_object_key(object_key)) {
            if (request == null) return null;
            request.server_cancel(new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO));
            return null;
        }
        int[] offsets = this.find_object_key_offsets(object_key);
        ProgressiveAIDKey aid_key = new ProgressiveAIDKey(object_key, offsets);
        block37: while (true) {
            AdapterValue ada_val = null;
            Object object = this.m_sync_state;
            synchronized (object) {
                aid_key.useHash(offsets.length - 1);
                ada_val = (AdapterValue)this.m_adapter_cache.get(aid_key);
                if (ada_val != null) {
                    ada_val.IncHits();
                    return ada_val.adapter();
                }
                int i = offsets.length - 2;
                while (true) {
                    if (i < 0 || ada_val != null) {
                        // MONITOREXIT @DISABLED, blocks:[37, 22, 38, 56] lbl23 : MonitorExitStatement: MONITOREXIT : var6_6
                        if (ada_val != null) break;
                        if (request == null) return null;
                        request.server_cancel(new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO));
                        return null;
                    }
                    aid_key.useHash(i);
                    ada_val = (AdapterValue)this.m_adapter_cache.get(aid_key);
                    --i;
                }
            }
            ObjectAdapter adapter = ada_val.adapter();
            if (adapter.object_id(object_key) != null) {
                ada_val.IncHits();
                return adapter;
            }
            boolean is_st_thread = false;
            boolean made_st_thread = false;
            try {
                Object object2;
                do {
                    Object var22_23;
                    AdapterManagerImpl manager = null;
                    if (request != null) {
                        Object object3;
                        if (!is_st_thread && adapter.single_threaded()) {
                            object2 = this.m_sync_queue;
                            synchronized (object2) {
                                if (this.m_single_thread == Thread.currentThread()) {
                                    is_st_thread = true;
                                } else {
                                    if (this.m_single_thread != null) {
                                        this.m_waiting_requests.addLast(request);
                                        ++this.m_holding_requests;
                                        object3 = null;
                                        return object3;
                                    }
                                    this.m_single_thread = Thread.currentThread();
                                    made_st_thread = true;
                                    is_st_thread = true;
                                }
                            }
                        }
                        if ((manager = (AdapterManagerImpl)adapter.getAdapterManager()) != null && !manager.begin_request(request)) {
                            object3 = null;
                            return object3;
                        }
                    }
                    try {
                        adapter = adapter.find_adapter(object_key);
                    }
                    catch (AdapterDestroyedException ex) {
                        byte[] aid = ex.getAdapterID();
                        int[] aoff = this.find_object_key_offsets(aid);
                        int offset = aoff[aoff.length - 1];
                        AdapterValue child_ada_val = new AdapterValue(aid, offset, ex.getObjectAdapter());
                        Object object4 = this.m_sync_state;
                        synchronized (object4) {
                            child_ada_val = (AdapterValue)this.m_adapter_cache.get(child_ada_val);
                            if (child_ada_val == null) {
                                // MONITOREXIT @DISABLED, blocks:[48, 32, 1, 37, 39, 28] lbl74 : MonitorExitStatement: MONITOREXIT : var16_18
                                var22_23 = null;
                                if (manager == null) continue block37;
                                manager.complete_request(request);
                                continue block37;
                            }
                            if (request != null) {
                                if (child_ada_val.getDestroyRequests() == null) {
                                    child_ada_val.setDestroyRequests(new MergeStack());
                                }
                                child_ada_val.getDestroyRequests().addLast(request);
                                ++this.m_holding_requests;
                                ObjectAdapter objectAdapter = null;
                                // MONITOREXIT @DISABLED, blocks:[32, 1, 37, 39, 28, 47] lbl86 : MonitorExitStatement: MONITOREXIT : var16_18
                                var22_23 = null;
                                if (manager != null) {
                                    manager.complete_request(request);
                                }
                                if (!made_st_thread) return objectAdapter;
                                Object object5 = this.m_sync_queue;
                                synchronized (object5) {
                                    this.m_single_thread = null;
                                    return objectAdapter;
                                }
                            }
                            try {
                                child_ada_val.setWaitingForDestroy(true);
                                boolean interrupted = false;
                                while (true) {
                                    if (!child_ada_val.getWaitingForDestroy()) {
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                        // MONITOREXIT @DISABLED, blocks:[32, 1, 37, 39, 40, 28, 44, 13] lbl104 : MonitorExitStatement: MONITOREXIT : var16_18
                                        var22_23 = null;
                                        if (manager == null) continue block37;
                                        manager.complete_request(request);
                                        continue block37;
                                    }
                                    try {
                                        this.m_sync_state.wait();
                                    }
                                    catch (InterruptedException iex) {
                                        interrupted = true;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                var22_23 = null;
                                if (manager == null) throw throwable;
                                manager.complete_request(request);
                                throw throwable;
                            }
                        }
                    }
                    var22_23 = null;
                    if (manager != null) {
                        manager.complete_request(request);
                    }
                    if (adapter != null) continue;
                    if (request != null) {
                        request.server_cancel(new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO));
                    }
                    object2 = null;
                    return object2;
                } while (adapter.object_id(object_key) == null);
                object2 = adapter;
                return object2;
            }
            finally {
                if (!made_st_thread) continue;
                Object object6 = this.m_sync_queue;
                synchronized (object6) {
                    this.m_single_thread = null;
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_adapter(byte[] aid, ObjectAdapter adapter) {
        if (aid.length == 0) {
            if (this.m_default_adapter == null) {
                this.m_default_adapter = adapter;
            }
            return;
        }
        if (!this.is_local_cacheable_object_key(aid)) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        int offset = this.find_object_key_offsets(aid)[0];
        AdapterValue ada_val = new AdapterValue(aid, offset, adapter);
        AdapterManagerImpl manager = (AdapterManagerImpl)adapter.getAdapterManager();
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_adapter_cache.containsKey(ada_val)) {
                return;
            }
            if (manager != null) {
                manager.addManagedAdapter(adapter);
            }
            this.m_adapter_cache.put(ada_val, ada_val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister_adapter(byte[] aid) {
        if (aid.length == 0) {
            this.m_default_adapter = null;
            return;
        }
        if (!this.is_local_cacheable_object_key(aid)) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
        }
        int offset = this.find_object_key_offsets(aid)[0];
        AdapterValue ada_val = new AdapterValue(aid, offset, null);
        Object object = this.m_sync_state;
        synchronized (object) {
            ada_val = (AdapterValue)this.m_adapter_cache.remove(ada_val);
            if (ada_val == null) {
                return;
            }
            if (ada_val.getWaitingForDestroy()) {
                ada_val.setWaitingForDestroy(false);
                this.m_sync_state.notifyAll();
            }
        }
        AdapterManagerImpl manager = (AdapterManagerImpl)ada_val.adapter().getAdapterManager();
        if (manager != null) {
            manager.removeManagedAdapter(ada_val.adapter());
        }
        if (ada_val.getDestroyRequests() != null && !ada_val.getDestroyRequests().isEmpty()) {
            Object object2 = this.m_sync_queue;
            synchronized (object2) {
                this.m_active_requests += ada_val.getDestroyRequests().size();
                this.m_holding_requests -= ada_val.getDestroyRequests().size();
                this.m_requests.append(ada_val.getDestroyRequests());
                this.m_sync_queue.notifyAll();
            }
        }
    }

    public ServerManager.AdapterManager create_adapter_manager() {
        return new AdapterManagerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue_request(ServerRequest request) {
        if (this.m_shutdown) {
            request.server_cancel(ServerManagerImpl.createShutdownException());
        }
        Object object = this.m_sync_queue;
        synchronized (object) {
            if (this.m_max_queue_size == 0 || this.m_active_requests < this.m_max_queue_size) {
                ++this.m_active_requests;
                this.m_requests.addLast(request);
                this.m_sync_queue.notify();
                if (this.m_active_requests > this.m_tp_max_active_requests) {
                    this.m_tp_max_active_requests = this.m_active_requests;
                    this.recalcOptThreadPoolSize();
                }
                if (this.m_thread_pool_size < this.m_min_thread_pool_size) {
                    this.extend_thread_pool(this.m_min_thread_pool_size - this.m_thread_pool_size);
                } else if (this.m_thread_pool_size < this.m_max_thread_pool_size && this.m_active_requests > this.m_thread_pool_size) {
                    this.extend_thread_pool(1);
                }
                return;
            }
        }
        request.server_cancel(ServerManagerImpl.createQueueFullException());
    }

    private void recalcOptThreadPoolSize() {
        this.m_opt_thread_pool_size = this.m_tp_previous_max_active_requests > this.m_tp_max_active_requests ? (this.m_tp_max_active_requests + this.m_tp_previous_max_active_requests) / 2 : this.m_tp_max_active_requests * 11 / 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean work_pending() {
        if (this.m_shutdown) {
            return false;
        }
        if (!this.m_running) {
            Object object = this.m_sync_io;
            synchronized (object) {
                return !this.m_channels.isEmpty();
            }
        }
        Object object = this.m_sync_queue;
        synchronized (object) {
            return !this.m_requests.isEmpty();
        }
    }

    public boolean serve_request(boolean wait) {
        if (!this.m_running) {
            this.startup(false, false);
        }
        return this.thread_pool_main(wait ? -1 : -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean thread_pool_main(int pool_id) {
        Thread currThread = Thread.currentThread();
        if (pool_id < 0) {
            Object object = this.m_sync_queue;
            synchronized (object) {
                this.m_server_threads.add(currThread);
            }
        }
        boolean completedRequest = false;
        while (true) {
            ServerRequest nextRequest = null;
            Object object = this.m_sync_queue;
            synchronized (object) {
                block21: {
                    while (true) {
                        if (completedRequest) {
                            --this.m_active_requests;
                        }
                        if (this.m_shutdown || completedRequest && pool_id < 0 || pool_id >= this.m_opt_thread_pool_size && pool_id >= this.m_min_thread_pool_size) {
                            if (pool_id >= 0) {
                                this.m_pool_thread_array[pool_id] = null;
                                --this.m_thread_pool_size;
                                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                                    this.getLogger().debug("(ServerManager) Thread pool shrunk to " + this.m_thread_pool_size);
                                }
                            }
                            if (this.m_single_thread == currThread) {
                                this.m_single_thread = null;
                            }
                            this.m_server_threads.remove(currThread);
                            if (this.m_shutdown && this.m_server_threads.isEmpty()) {
                                this.m_sync_queue.notifyAll();
                            }
                            return completedRequest;
                        }
                        completedRequest = false;
                        if (!(this.m_waiting_requests.isEmpty() || this.m_single_thread != null && this.m_single_thread != currThread)) {
                            if (this.m_single_thread != currThread) {
                                this.m_single_thread = currThread;
                            }
                            nextRequest = (ServerRequest)this.m_waiting_requests.removeFirst();
                            ++this.m_active_requests;
                            --this.m_holding_requests;
                            break block21;
                        }
                        if (this.m_single_thread == currThread) {
                            this.m_single_thread = null;
                        }
                        if (!this.m_requests.isEmpty() || pool_id == -2) break;
                        try {
                            this.m_sync_queue.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            this.m_server_threads.remove(currThread);
                            if (this.m_shutdown && this.m_server_threads.isEmpty()) {
                                this.m_sync_queue.notifyAll();
                            }
                            return false;
                        }
                    }
                    nextRequest = (ServerRequest)this.m_requests.removeFirst();
                }
            }
            this.serve_request(nextRequest);
            completedRequest = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serve_request(ServerRequest request) {
        int state = request.begin_request();
        while (true) {
            Object var12_10;
            AdapterManagerImpl manager;
            ObjectAdapter adapter;
            switch (state) {
                case 1: {
                    adapter = this.find_adapter(request.object_key(), request);
                    if (adapter == null) return;
                    state = request.adapter(adapter);
                    if (state != 5) break;
                    return;
                }
                case 5: {
                    return;
                }
                default: {
                    adapter = request.adapter();
                }
            }
            if (state != 2) {
                throw Trace.signalIllegalCondition(this.getLogger(), "state != ServerRequest.STATE_QUEUED");
            }
            if (adapter.single_threaded()) {
                Object object = this.m_sync_queue;
                synchronized (object) {
                    if (this.m_single_thread == null) {
                        this.m_single_thread = Thread.currentThread();
                    } else if (this.m_single_thread != Thread.currentThread()) {
                        this.m_waiting_requests.addLast(request);
                        ++this.m_holding_requests;
                        return;
                    }
                }
            }
            if ((manager = (AdapterManagerImpl)adapter.getAdapterManager()) != null && !manager.begin_request(request)) {
                return;
            }
            try {
                try {
                    request.dispatch();
                }
                catch (AdapterDestroyedException ex) {
                    byte[] aid = ex.getAdapterID();
                    if (adapter != ex.getObjectAdapter()) {
                        Trace.signalIllegalCondition(this.getLogger(), "Adapters do not match.");
                    }
                    int[] aid_offsets = this.find_object_key_offsets(aid);
                    AdapterValue ada_val = new AdapterValue(aid, aid_offsets[0], adapter);
                    Object object = this.m_sync_state;
                    synchronized (object) {
                        ada_val = (AdapterValue)this.m_adapter_cache.get(ada_val);
                        if (ada_val != null && ada_val.adapter() == adapter) {
                            if (ada_val.getDestroyRequests() == null) {
                                ada_val.setDestroyRequests(new MergeStack());
                            }
                            ada_val.getDestroyRequests().addLast(request);
                            ++this.m_holding_requests;
                            // MONITOREXIT @DISABLED, blocks:[1, 6, 11, 13, 15] lbl53 : MonitorExitStatement: MONITOREXIT : var9_9
                            var12_10 = null;
                            if (manager == null) return;
                            manager.complete_request(request);
                            return;
                        }
                    }
                    var12_10 = null;
                    if (manager == null) continue;
                    manager.complete_request(request);
                    continue;
                }
                var12_10 = null;
                if (manager == null) return;
                manager.complete_request(request);
                return;
            }
            catch (Throwable throwable) {
                var12_10 = null;
                if (manager == null) throw throwable;
                manager.complete_request(request);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean is_server_thread() {
        Object object = this.m_sync_state;
        synchronized (object) {
            return this.m_server_threads.contains(Thread.currentThread());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extend_thread_pool(int count) {
        if (this.m_pool_threads == null || this.m_pool_threads.isDestroyed()) {
            if (this.m_use_static_thread_group) {
                if (ServerManagerImpl.s_static_pool_threads == null || ServerManagerImpl.s_static_pool_threads.isDestroyed()) {
                    ServerManagerImpl.s_static_pool_threads = new ThreadGroup(this.m_root_group, "Server Threads");
                }
                this.m_pool_threads = ServerManagerImpl.s_static_pool_threads;
            } else {
                this.m_pool_threads = new ThreadGroup(this.m_root_group, "Server Threads");
            }
        }
        if (this.m_pool_thread_array.length < this.m_thread_pool_size + count) {
            tmp = new Thread[this.m_thread_pool_size + count];
            System.arraycopy(this.m_pool_thread_array, 0, tmp, 0, this.m_pool_thread_array.length);
            this.m_pool_thread_array = tmp;
        }
        this.m_thread_pool_size += count;
        id = 0;
        i = 0;
        ** GOTO lbl28
        {
            ++id;
            do {
                if (this.m_pool_thread_array[id] != null) continue block0;
                this.m_pool_thread_array[id] = new PoolThread(this.m_pool_threads, id);
                this.m_server_threads.add(this.m_pool_thread_array[id]);
                this.m_pool_thread_array[id].setDaemon(true);
                this.m_pool_thread_array[id].start();
                ++id;
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("ServerManager Thread pool grew to " + this.m_thread_pool_size);
                }
                ++i;
lbl28:
                // 2 sources

            } while (i < count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wait_for_startup() {
        if (!this.m_running) {
            Object object = this.m_sync_state;
            synchronized (object) {
                while (!this.m_running) {
                    if (this.m_shutdown) {
                        return false;
                    }
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException ex) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(boolean block, boolean allowPool) {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            if (!this.m_running) {
                this.m_running = true;
                this.m_allow_pool = allowPool;
                if (this.m_io_threads == null || this.m_io_threads.isDestroyed()) {
                    if (this.m_use_static_thread_group) {
                        if (s_static_io_threads == null || s_static_io_threads.isDestroyed()) {
                            s_static_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                        }
                        this.m_io_threads = s_static_io_threads;
                    } else {
                        this.m_io_threads = new ThreadGroup(this.m_root_group, "Server IO");
                    }
                }
                if (this.m_channel_closing_time > 0) {
                    this.m_channel_reaper = new Thread(this.m_io_threads, new Runnable(){

                        public void run() {
                            ServerManagerImpl.this.channel_reaper();
                        }
                    }, "Channel Reaper");
                    this.m_channel_reaper.setDaemon(true);
                    this.m_channel_reaper.start();
                }
                this.m_sync_state.notifyAll();
            } else if (allowPool && !this.m_allow_pool) {
                this.m_allow_pool = true;
                if (this.m_opt_thread_pool_size < this.m_min_thread_pool_size) {
                    this.extend_thread_pool(this.m_opt_thread_pool_size);
                } else if (this.m_opt_thread_pool_size < this.m_max_thread_pool_size) {
                    this.extend_thread_pool(this.m_opt_thread_pool_size);
                } else {
                    this.extend_thread_pool(this.m_max_thread_pool_size);
                }
            }
            if (block) {
                try {
                    while (this.m_running) {
                        this.m_sync_state.wait();
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait_for_complete) {
        ORBLoader loader;
        ServerChannel[] channels;
        ServerProtocol[] protocols;
        if (!wait_for_complete) {
            Object object = this.m_sync_state;
            synchronized (object) {
                if (this.m_shutdown) {
                    return;
                }
                Thread t = new Thread(this.m_root_group, new Runnable(){

                    public void run() {
                        ServerManagerImpl.this.shutdown(true);
                    }
                }, "ORB shutdown thread");
                t.setDaemon(true);
                t.start();
                while (!this.m_io_complete) {
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return;
        }
        if (this.is_server_thread()) {
            throw new BAD_INV_ORDER(1330446339, CompletionStatus.COMPLETED_MAYBE);
        }
        boolean interrupt = false;
        Object object = this.m_sync_state;
        synchronized (object) {
            Object object2 = this.m_sync_io;
            synchronized (object2) {
                if (this.m_shutdown) {
                    return;
                }
                this.m_shutdown = true;
                protocols = new ServerProtocol[this.m_protocol_to_worker.size()];
                protocols = this.m_protocol_to_worker.keySet().toArray(protocols);
            }
            if (this.m_channel_reaper != null) {
                this.m_channel_reaper.interrupt();
            }
        }
        int i = 0;
        while (i < protocols.length) {
            if (protocols[i] != null) {
                protocols[i].close();
            }
            ++i;
        }
        Object object3 = this.m_sync_state;
        synchronized (object3) {
            this.m_io_complete = true;
            this.m_sync_state.notifyAll();
        }
        Object object4 = this.m_sync_queue;
        synchronized (object4) {
            this.m_sync_queue.notifyAll();
            while (!this.m_server_threads.isEmpty()) {
                try {
                    this.m_sync_queue.wait();
                }
                catch (InterruptedException ex) {
                    interrupt = true;
                }
            }
        }
        Object object5 = this.m_sync_state;
        synchronized (object5) {
            ServerRequest request;
            while (!this.m_waiting_requests.isEmpty()) {
                request = (ServerRequest)this.m_waiting_requests.removeFirst();
                request.server_cancel(ServerManagerImpl.createShutdownException());
                --this.m_holding_requests;
            }
            while (!this.m_requests.isEmpty()) {
                request = (ServerRequest)this.m_requests.removeFirst();
                request.server_cancel(ServerManagerImpl.createShutdownException());
                --this.m_active_requests;
            }
            Iterator itt = this.m_adapter_cache.values().iterator();
            while (itt.hasNext()) {
                AdapterValue ada_val = (AdapterValue)itt.next();
                AdapterManagerImpl manager = (AdapterManagerImpl)ada_val.adapter().getAdapterManager();
                if (manager != null && manager.m_state == State.HOLDING) {
                    if (manager.m_hold_requests != null) {
                        while (!manager.m_hold_requests.isEmpty()) {
                            ServerRequest request2 = (ServerRequest)manager.m_hold_requests.removeFirst();
                            request2.server_cancel(ServerManagerImpl.createShutdownException());
                            --this.m_holding_requests;
                        }
                    }
                    manager.m_state = State.INACTIVE;
                }
                ada_val.adapter().etherealize(true);
            }
            if (this.m_active_requests != 0) {
                Trace.signalIllegalCondition(this.getLogger(), "Active requests not empty.");
            }
            if (this.m_holding_requests != 0) {
                Trace.signalIllegalCondition(this.getLogger(), "Holding requests not empty.");
            }
        }
        if (this.m_channel_reaper != null) {
            try {
                this.m_channel_reaper.join();
                this.m_channel_reaper = null;
            }
            catch (InterruptedException ex) {
                interrupt = true;
            }
        }
        Object object6 = this.m_sync_io;
        synchronized (object6) {
            channels = new ServerChannel[this.m_channels.size()];
            channels = this.m_channels.keySet().toArray(channels);
        }
        int i2 = 0;
        while (i2 < channels.length) {
            channels[i2].soft_close(true);
            ++i2;
        }
        Object object7 = this.m_sync_state;
        synchronized (object7) {
            this.m_running = false;
            this.m_sync_state.notifyAll();
        }
        if (!this.m_use_static_thread_group) {
            if (this.m_io_threads != null) {
                this.m_io_threads.setDaemon(true);
                try {
                    this.m_io_threads.destroy();
                }
                catch (IllegalThreadStateException ex) {
                    // empty catch block
                }
            }
            if (this.m_pool_threads != null) {
                this.m_pool_threads.setDaemon(true);
                try {
                    this.m_pool_threads.destroy();
                }
                catch (IllegalThreadStateException ex) {
                    // empty catch block
                }
            }
        }
        if ((loader = ((ORB)this.m_orb).getLoader()) instanceof Disposable) {
            ((Disposable)loader).dispose();
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private static class AdapterValue {
        private byte[] m_aid;
        private int m_hash;
        private int m_offset;
        private ObjectAdapter m_adapter;
        private int m_priority;
        private int m_hits = 0;
        private MergeStack m_destroy_requests;
        private boolean m_waiting_for_destroy = false;

        public AdapterValue(byte[] aid, int offset, ObjectAdapter adapter) {
            this.m_aid = aid;
            this.m_offset = offset;
            this.m_hash = 0;
            int i = offset;
            while (i < this.m_aid.length) {
                this.m_hash = 31 * this.m_hash + (this.m_aid[i] & 0xFF);
                ++i;
            }
            this.m_adapter = adapter;
            this.m_priority = this.m_adapter != null ? this.m_adapter.cache_priority() : -1;
        }

        public boolean is_cacheable_object_key() {
            return this.m_offset != 0;
        }

        public int hashCode() {
            return this.m_hash;
        }

        public int offset() {
            return this.m_offset;
        }

        public byte[] aid() {
            return this.m_aid;
        }

        public int hits() {
            return this.m_hits;
        }

        public void IncHits() {
            ++this.m_hits;
        }

        public ObjectAdapter adapter() {
            return this.m_adapter;
        }

        public MergeStack getDestroyRequests() {
            return this.m_destroy_requests;
        }

        public void setDestroyRequests(MergeStack destroy_requests) {
            this.m_destroy_requests = destroy_requests;
        }

        public boolean getWaitingForDestroy() {
            return this.m_waiting_for_destroy;
        }

        public void setWaitingForDestroy(boolean waiting_for_destroy) {
            this.m_waiting_for_destroy = waiting_for_destroy;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AdapterValue) {
                AdapterValue o2 = (AdapterValue)obj;
                if (o2.m_hash != this.m_hash || o2.m_offset != this.m_offset || o2.m_aid.length != this.m_aid.length) {
                    return false;
                }
                int i = this.m_aid.length - 1;
                while (i >= 0) {
                    if (this.m_aid[i] != o2.m_aid[i]) {
                        return false;
                    }
                    --i;
                }
                return true;
            }
            if (obj instanceof ProgressiveAIDKey) {
                int i;
                ProgressiveAIDKey o2 = (ProgressiveAIDKey)obj;
                if (o2.hashCode() != this.m_hash) {
                    return false;
                }
                if (this.m_offset == 0 != (o2.offsets()[0] == 0)) {
                    return false;
                }
                int n = i = o2.hashTo() == o2.offsets().length - 1 ? o2.aid().length : o2.offsets()[o2.hashTo() + 1];
                if (i - o2.offsets()[0] != this.m_aid.length - this.m_offset) {
                    return false;
                }
                int j = this.m_aid.length;
                --i;
                --j;
                while (j >= this.m_offset) {
                    if (o2.aid()[i] != this.m_aid[j]) {
                        return false;
                    }
                    --i;
                    --j;
                }
                return true;
            }
            return false;
        }
    }

    private static class ProgressiveAIDKey {
        private byte[] m_aid;
        private int[] m_offsets;
        private int[] m_hashes;
        private int m_hash;
        private int m_hash_to;

        public ProgressiveAIDKey(byte[] aid, int[] offsets) {
            this.m_aid = aid;
            this.m_offsets = offsets;
            this.m_hashes = new int[this.m_offsets.length];
            this.m_hash = 0;
            int i = 0;
            while (i < this.m_hashes.length) {
                int s = this.m_offsets[i];
                int e = i + 1 < this.m_hashes.length ? this.m_offsets[i + 1] : this.m_aid.length;
                int j = s;
                while (j < e) {
                    this.m_hash = 31 * this.m_hash + (this.m_aid[j] & 0xFF);
                    ++j;
                }
                this.m_hashes[i] = this.m_hash;
                ++i;
            }
            this.m_hash_to = this.m_offsets.length - 1;
        }

        public boolean is_cacheable_object_key() {
            return this.m_offsets[0] != 0;
        }

        public int hashCode() {
            return this.m_hash;
        }

        public int hashTo() {
            return this.m_hash_to;
        }

        public int[] offsets() {
            return this.m_offsets;
        }

        public byte[] aid() {
            return this.m_aid;
        }

        public int useHash(int to) {
            this.m_hash_to = to;
            this.m_hash = to == -1 ? 0 : this.m_hashes[to];
            return this.m_hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AdapterValue) {
                int i;
                AdapterValue o2 = (AdapterValue)obj;
                if (o2.offset() == 0 != (this.m_offsets[0] == 0)) {
                    return false;
                }
                if (o2.hashCode() != this.m_hash) {
                    return false;
                }
                int n = i = this.m_hash_to == this.m_offsets.length - 1 ? this.m_aid.length : this.m_offsets[this.m_hash_to + 1];
                if (i - this.m_offsets[0] != o2.aid().length - o2.offset()) {
                    return false;
                }
                int j = o2.aid().length;
                --i;
                --j;
                while (j >= o2.offset()) {
                    if (this.m_aid[i] != o2.aid()[j]) {
                        return false;
                    }
                    --i;
                    --j;
                }
                return true;
            }
            if (obj instanceof ProgressiveAIDKey) {
                ProgressiveAIDKey o2 = (ProgressiveAIDKey)obj;
                if (o2.m_offsets[0] == 0 != (this.m_offsets[0] == 0)) {
                    return false;
                }
                if (o2.m_hash_to != this.m_hash_to) {
                    return false;
                }
                int i = this.m_hash_to;
                while (i >= 0) {
                    if (o2.m_hashes[i] != this.m_hashes[i] || o2.m_offsets[i] - o2.m_offsets[0] != this.m_offsets[i] - this.m_offsets[0]) {
                        return false;
                    }
                    --i;
                }
                int i2 = this.m_hash_to == this.m_offsets.length - 1 ? this.m_aid.length : this.m_offsets[this.m_hash_to + 1];
                int j = o2.m_hash_to == o2.m_offsets.length - 1 ? o2.m_aid.length : o2.m_offsets[o2.m_hash_to + 1];
                --i2;
                --j;
                while (i2 >= this.m_offsets[0]) {
                    if (this.m_aid[i2] != o2.m_aid[j]) {
                        return false;
                    }
                    --i2;
                    --j;
                }
                return true;
            }
            return false;
        }
    }

    public class AdapterManagerImpl
    extends LocalObject
    implements POAManager,
    ServerManager.AdapterManager {
        private Set m_managed_adapters = new HashSet();
        private State m_state = State.HOLDING;
        private int m_managed_active_requests = 0;
        private MergeStack m_hold_requests;
        private boolean m_etherealize;
        private int m_max_manager_held_requests_override = ServerManagerImpl.access$500(ServerManagerImpl.this);

        AdapterManagerImpl() {
        }

        public void setMaxManagerHeldRequests(int max) {
            if (max < 0) {
                throw new IllegalArgumentException();
            }
            this.m_max_manager_held_requests_override = max;
        }

        public synchronized State get_state() {
            return this.m_state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate(boolean etherealize, boolean wait_for_completion) throws AdapterInactive {
            if (wait_for_completion && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(1330446342, CompletionStatus.COMPLETED_NO);
            }
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                if (this.m_state == State.INACTIVE) {
                    if (this.m_managed_active_requests == 0) {
                        throw new AdapterInactive();
                    }
                    if (wait_for_completion) {
                        this.wait_for_complete();
                    }
                    return;
                }
                this.m_state = State.INACTIVE;
                if (!wait_for_completion && etherealize && this.m_managed_active_requests > 0) {
                    this.m_etherealize = true;
                    etherealize = false;
                }
                if (wait_for_completion && this.m_managed_active_requests == 0) {
                    wait_for_completion = false;
                }
            }
            if (this.m_hold_requests != null) {
                while (!this.m_hold_requests.isEmpty()) {
                    ServerRequest request = (ServerRequest)this.m_hold_requests.removeFirst();
                    request.server_cancel(ServerManagerImpl.createInactiveException());
                }
                ServerManagerImpl.this.m_holding_requests -= this.m_hold_requests.size();
            }
            if (wait_for_completion || etherealize) {
                AdapterManagerImpl adapterManagerImpl2 = this;
                synchronized (adapterManagerImpl2) {
                    if (wait_for_completion) {
                        this.wait_for_complete();
                    }
                    if (etherealize) {
                        this.complete_deactivate();
                    }
                }
            }
        }

        private void complete_deactivate() {
            ObjectAdapter[] adapters = new ObjectAdapter[this.m_managed_adapters.size()];
            this.m_managed_adapters.toArray(adapters);
            int i = 0;
            while (i < adapters.length) {
                adapters[i].etherealize(true);
                ++i;
            }
        }

        private void wait_for_complete() {
            try {
                while (this.m_managed_active_requests > 0 && this.m_state != State.ACTIVE) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void discard_requests(boolean wait_for_completion) throws AdapterInactive {
            if (wait_for_completion && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(1330446342, CompletionStatus.COMPLETED_NO);
            }
            AbstractCollection hold = null;
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                switch (this.m_state.value()) {
                    case 3: {
                        throw new AdapterInactive();
                    }
                    case 0: {
                        if (this.m_hold_requests == null || this.m_hold_requests.isEmpty()) break;
                        hold = this.m_hold_requests;
                        this.m_hold_requests = null;
                        break;
                    }
                }
                this.m_state = State.DISCARDING;
                if (hold == null || hold.isEmpty()) {
                    if (!wait_for_completion) return;
                    this.wait_for_complete();
                    return;
                }
            }
            while (!hold.isEmpty()) {
                ServerRequest request = (ServerRequest)((MergeStack)hold).removeFirst();
                request.server_cancel(ServerManagerImpl.createDiscardException());
                --ServerManagerImpl.this.m_holding_requests;
            }
            if (!wait_for_completion) return;
            AdapterManagerImpl adapterManagerImpl2 = this;
            synchronized (adapterManagerImpl2) {
                this.wait_for_complete();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hold_requests(boolean wait_for_completion) throws AdapterInactive {
            if (wait_for_completion && ServerManagerImpl.this.is_server_thread()) {
                throw new BAD_INV_ORDER(1330446342, CompletionStatus.COMPLETED_NO);
            }
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                if (this.m_state == State.INACTIVE) {
                    throw new AdapterInactive();
                }
                this.m_state = State.HOLDING;
                if (wait_for_completion) {
                    this.wait_for_complete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate() throws AdapterInactive {
            MergeStack hold = null;
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                switch (this.m_state.value()) {
                    case 3: {
                        throw new AdapterInactive();
                    }
                    case 1: {
                        return;
                    }
                    case 0: {
                        hold = this.m_hold_requests;
                        this.m_hold_requests = null;
                    }
                }
                this.m_state = State.ACTIVE;
                this.notifyAll();
            }
            if (hold != null && !hold.isEmpty()) {
                Object object = ServerManagerImpl.this.m_sync_queue;
                synchronized (object) {
                    ServerManagerImpl.this.m_holding_requests -= hold.size();
                    ServerManagerImpl.this.m_active_requests += hold.size();
                    ServerManagerImpl.this.m_requests.append(hold);
                    ServerManagerImpl.this.m_sync_queue.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean begin_request(ServerRequest request) {
            SystemException respond_ex = null;
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                switch (this.m_state.value()) {
                    case 1: {
                        ++this.m_managed_active_requests;
                        return true;
                    }
                    case 0: {
                        if (this.m_hold_requests == null || this.m_hold_requests.size() < (this.m_max_manager_held_requests_override < ServerManagerImpl.this.m_max_mgr_held_requests ? this.m_max_manager_held_requests_override : ServerManagerImpl.this.m_max_mgr_held_requests)) {
                            if (this.m_hold_requests == null) {
                                this.m_hold_requests = new MergeStack();
                            }
                            this.m_hold_requests.addLast(request);
                            ++ServerManagerImpl.this.m_holding_requests;
                            return false;
                        }
                    }
                    case 2: {
                        respond_ex = ServerManagerImpl.createDiscardException();
                        break;
                    }
                    case 3: {
                        respond_ex = ServerManagerImpl.createInactiveException();
                    }
                }
            }
            request.server_cancel(respond_ex);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete_request(ServerRequest request) {
            AdapterManagerImpl adapterManagerImpl = this;
            synchronized (adapterManagerImpl) {
                if (--this.m_managed_active_requests == 0) {
                    if (this.m_etherealize) {
                        this.complete_deactivate();
                    }
                    this.notifyAll();
                }
            }
        }

        synchronized void addManagedAdapter(ObjectAdapter adapter) {
            this.m_managed_adapters.add(adapter);
        }

        synchronized void removeManagedAdapter(ObjectAdapter adapter) {
            this.m_managed_adapters.remove(adapter);
        }
    }

    private class PoolThread
    extends Thread {
        private int m_id;

        private PoolThread(ThreadGroup group, int id) {
            super(group, "Thread pool thread #" + id);
            this.m_id = id;
        }

        public void run() {
            ServerManagerImpl.this.thread_pool_main(this.m_id);
        }
    }

    private class ChannelRecvRunner
    implements Runnable {
        private ServerChannel m_server_channel;

        public ChannelRecvRunner(ServerChannel chan) {
            this.m_server_channel = chan;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this.m_server_channel.run_recv();
            }
        }
    }

    private class ProtocolRunner
    implements Runnable {
        private ServerProtocol m_server_protocol;

        public ProtocolRunner(ServerProtocol svrproto) {
            this.m_server_protocol = svrproto;
        }

        public void run() {
            if (ServerManagerImpl.this.wait_for_startup()) {
                this.m_server_protocol.run_listen();
            }
        }
    }
}

