/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2;

import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openarchitectureware.MetamodelContributor;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.metamodel.MetamodelContributorRegistry;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.XpandPluginExecutionContext;
import org.openarchitectureware.xpand2.editor.PreferencesConstants;
import org.openarchitectureware.xpand2.editor.color.ColorProvider;
import org.osgi.framework.BundleContext;

public class XpandEditorPlugin
extends AbstractUIPlugin {
    private static XpandEditorPlugin plugin;
    private ColorProvider colorProvider;
    private ContributionTemplateStore templateStore;
    private ContributionContextTypeRegistry contextTypeRegistry;

    public XpandEditorPlugin() {
        plugin = this;
        this.colorProvider = new ColorProvider();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        OawPlugin.getDefault();
        PreferencesConstants.initializeDefaultValues(this.getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.colorProvider.dispose();
        this.colorProvider = null;
    }

    public static XpandEditorPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)XpandEditorPlugin.getId(), (String)path);
    }

    public static String getId() {
        return XpandEditorPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ColorProvider getColorProvider() {
        return XpandEditorPlugin.getDefault().colorProvider;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = XpandEditorPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        return XpandEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static XpandExecutionContext getExecutionContext(IJavaProject project) {
        IOawProject xp = OawPlugin.getOawModelManager().findProject(project.getPath());
        if (xp == null) {
            return null;
        }
        XpandPluginExecutionContext ctx = new XpandPluginExecutionContext(xp);
        List contr = MetamodelContributorRegistry.getActiveMetamodelContributors((IJavaProject)project);
        for (MetamodelContributor contributor : contr) {
            MetaModel[] metamodels;
            MetaModel[] metaModelArray = metamodels = contributor.getMetamodels(project, (TypeSystem)ctx);
            int n = metamodels.length;
            int n2 = 0;
            while (n2 < n) {
                MetaModel element = metaModelArray[n2];
                ctx.registerMetaModel(element);
                ++n2;
            }
        }
        return ctx;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), XpandEditorPlugin.getDefault().getPreferenceStore(), "templates");
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = new ContributionContextTypeRegistry();
            this.contextTypeRegistry.addContextType("org.openarchitectureware.xpand2.editor.context.Default");
        }
        return this.contextTypeRegistry;
    }
}

