/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.core.internal.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.openarchitectureware.ResourceContributorBase;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.expression.Resource;
import org.openarchitectureware.xpand2.ast.Template;
import org.openarchitectureware.xpand2.core.internal.XpandResourceImpl;
import org.openarchitectureware.xpand2.internal.XpandLog;
import org.openarchitectureware.xpand2.model.XpandResource;
import org.openarchitectureware.xpand2.parser.XpandParseFacade;
import org.openarchitectureware.xtend.parser.ErrorHandler;

public class XpandResourceParser
extends ResourceContributorBase {
    public Resource parse(IStorage source, String fqn) {
        Template tpl = null;
        Reader reader = this.createReader(source);
        if (reader == null) {
            return null;
        }
        try {
            tpl = XpandParseFacade.file((Reader)reader, (String)fqn, (ErrorHandler)this.getErrorHandler(source));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.logError(e.getMessage(), e);
            }
        }
        if (tpl == null) {
            return null;
        }
        tpl.setFullyQualifiedName(fqn);
        return tpl;
    }

    protected IOawResource createOawResource(Resource resource, IStorage source) {
        return new XpandResourceImpl((XpandResource)((Template)resource), source, this);
    }

    protected Reader createReader(IStorage resource) {
        InputStreamReader reader;
        InputStream in;
        try {
            in = resource.getContents();
        }
        catch (CoreException e1) {
            XpandLog.logInfo(e1.getMessage());
            return null;
        }
        if (resource != null) {
            String fileEncoding = ResourcesPlugin.getEncoding();
            try {
                if (resource instanceof IFile) {
                    fileEncoding = ((IFile)resource).getCharset();
                }
            }
            catch (CoreException e) {
                XpandLog.logError("Could not get file encoding falling back to default...", e);
            }
            if (fileEncoding == null) {
                reader = new InputStreamReader(in);
            } else {
                try {
                    reader = new InputStreamReader(in, fileEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    XpandLog.logError("Unsupported encoding falling back to default...", e);
                    reader = new InputStreamReader(in);
                }
            }
        } else {
            reader = new InputStreamReader(in);
        }
        return reader;
    }

    protected void logError(String message, Throwable t) {
        XpandLog.logError(message, t);
    }

    protected void logInfo(String message) {
        XpandLog.logInfo(message);
    }

    public String getFileExtension() {
        return "xpt";
    }
}

