/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.editor.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.codeassist.ExpressionProposalComputer;
import org.openarchitectureware.expression.codeassist.ExtensionImportProposalComputer;
import org.openarchitectureware.expression.codeassist.ProposalFactory;
import org.openarchitectureware.expression.codeassist.TypeProposalComputer;
import org.openarchitectureware.expression.editor.codeassist.AbstractOawContentAssistProcessor;
import org.openarchitectureware.expression.editor.codeassist.ProposalComparator;
import org.openarchitectureware.xpand2.XpandEditorPlugin;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.codeassist.ExpandProposalComputer;
import org.openarchitectureware.xpand2.codeassist.FastAnalyzer;
import org.openarchitectureware.xpand2.codeassist.KeywordProposalComputer;
import org.openarchitectureware.xpand2.codeassist.NamespaceProposalComputer;
import org.openarchitectureware.xpand2.codeassist.StatementProposalComputer;
import org.openarchitectureware.xpand2.codeassist.XpandPartition;
import org.openarchitectureware.xpand2.core.IXpandResource;
import org.openarchitectureware.xpand2.editor.codeassist.XpandProposalFactoryEclipseImpl;
import org.openarchitectureware.xpand2.internal.XpandLog;
import org.openarchitectureware.xpand2.model.XpandDefinition;
import org.openarchitectureware.xtend.XtendFile;
import org.openarchitectureware.xtend.codeassist.Partition;

public class XpandContentAssistProcessor
extends AbstractOawContentAssistProcessor {
    public XpandContentAssistProcessor(IEditorPart editor) {
        super(editor);
    }

    protected ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int documentOffset) {
        try {
            String txt = viewer.getDocument().get().substring(0, documentOffset);
            XpandDefinition[] defs = new XpandDefinition[]{};
            IFile file = this.getFile();
            IXpandResource tpl = (IXpandResource)OawPlugin.getOawModelManager().findOawResource((IStorage)file);
            if (tpl != null) {
                defs = tpl.getDefinitions();
            }
            XpandExecutionContext ctx = XpandEditorPlugin.getExecutionContext(this.getJavaProject());
            Partition p = FastAnalyzer.computePartition((String)txt);
            if (p == Partition.COMMENT) {
                return new ICompletionProposal[0];
            }
            List<CompletionProposal> proposals = new ArrayList();
            XpandProposalFactoryEclipseImpl f = new XpandProposalFactoryEclipseImpl(documentOffset);
            if (p == Partition.TYPE_DECLARATION) {
                ctx = FastAnalyzer.computeExecutionContext((String)txt, (XpandExecutionContext)ctx, (XpandDefinition[])defs);
                proposals = new TypeProposalComputer().computeProposals(txt, (ExecutionContext)ctx, (ProposalFactory)f);
            } else if (p == Partition.EXPRESSION) {
                ctx = FastAnalyzer.computeExecutionContext((String)txt, (XpandExecutionContext)ctx, (XpandDefinition[])defs);
                String expression = txt.substring(txt.lastIndexOf(171));
                proposals.addAll(new ExpressionProposalComputer().computeProposals(expression, (ExecutionContext)ctx, (ProposalFactory)f));
                proposals.addAll(new KeywordProposalComputer().computeProposals(txt, (ExecutionContext)ctx, (ProposalFactory)f));
            } else if (p == XpandPartition.EXPAND_STATEMENT) {
                ctx = FastAnalyzer.computeExecutionContext((String)txt, (XpandExecutionContext)ctx, (XpandDefinition[])defs);
                proposals.addAll(new ExpandProposalComputer().computeProposals(txt, (ExecutionContext)ctx, (ProposalFactory)f));
                proposals.add(new CompletionProposal("\u00ab\u00bb", documentOffset, 0, 1));
            } else if (p == Partition.NAMESPACE_IMPORT) {
                ctx = FastAnalyzer.computeExecutionContext((String)txt, (XpandExecutionContext)ctx, (XpandDefinition[])defs);
                proposals.addAll(new NamespaceProposalComputer().computeProposals(txt, (ExecutionContext)ctx, (ProposalFactory)f));
            } else if (p == Partition.EXTENSION_IMPORT) {
                IOawProject project = OawPlugin.getOawModelManager().findProject((IResource)this.getFile());
                IOawResource[] resources = project.getAllRegisteredResources();
                HashSet<String> extensionNames = new HashSet<String>();
                IOawResource[] iOawResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IOawResource resource = iOawResourceArray[n2];
                    if (resource instanceof XtendFile) {
                        extensionNames.add(resource.getFullyQualifiedName());
                    }
                    ++n2;
                }
                List extensionProposals = new ExtensionImportProposalComputer().computeProposals(txt, (ExecutionContext)ctx, (ProposalFactory)f, extensionNames);
                proposals.addAll(extensionProposals);
            } else if (p == Partition.DEFAULT) {
                ctx = FastAnalyzer.computeExecutionContext((String)txt, (XpandExecutionContext)ctx, (XpandDefinition[])defs);
                proposals.addAll(new StatementProposalComputer().computeProposals(txt, (ExecutionContext)ctx, (ProposalFactory)f));
                proposals.add(new CompletionProposal("\u00ab\u00bb", documentOffset, 0, 1));
            }
            Collections.sort(proposals, new ProposalComparator());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        catch (Exception e) {
            XpandLog.logError(e);
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '\u00ab'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

