/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.uml2;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.openarchitectureware.workflow.WfCHelper;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class UML2Writer
extends AbstractWorkflowComponent {
    private static final Log LOG = LogFactory.getLog(UML2Writer.class);
    private static final String COMPONENT_NAME = "UML2 Writer";
    private String outPath;
    private String destinationFolder = "./";
    private String inputSlot = "default";
    private boolean useUML1x = false;

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
        if (!this.destinationFolder.equals("")) {
            if (!this.destinationFolder.endsWith("/")) {
                this.destinationFolder = String.valueOf(this.destinationFolder) + "/";
            }
        } else {
            this.destinationFolder = "./";
        }
    }

    public void setInputSlot(String slot) {
        this.inputSlot = slot;
    }

    public void setOutPath(String path) {
        this.outPath = path;
        if (!this.outPath.endsWith("/")) {
            this.outPath = String.valueOf(this.outPath) + "/";
        }
        if (this.outPath.startsWith("/")) {
            this.outPath = this.outPath.substring(1);
        }
    }

    public void setUseUML1x(boolean useUML1x) {
        this.useUML1x = useUML1x;
    }

    public void checkConfiguration(Issues issues) {
        if (!WfCHelper.isParamSet((String)this.inputSlot)) {
            issues.addError("Parameter 'inputSlot' must be set");
        }
        if (!WfCHelper.isLegalDir((String)this.destinationFolder)) {
            issues.addError("Property 'destinationFolder' does not specify a legal directory");
        }
    }

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        LOG.info((Object)("Running " + this.getComponentName()));
        Object slotContent = ctx.get(this.inputSlot);
        if (slotContent == null) {
            issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' is empty.");
            return;
        }
        if (!(slotContent instanceof Collection) && !(slotContent instanceof Package)) {
            issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' does not contain a list, a model or a profile", slotContent);
            return;
        }
        ResourceSetImpl rsImpl = new ResourceSetImpl();
        Resource.Factory factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(this.getUMLFileExtension());
        rsImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emx", factory);
        rsImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("epx", factory);
        if (slotContent instanceof Collection) {
            for (Object o : (Collection)slotContent) {
                if (!(o instanceof Package)) continue;
                Package model = (Package)o;
                this.saveModel(model, (ResourceSet)rsImpl);
            }
        } else if (slotContent instanceof Package) {
            this.saveModel((Package)slotContent, (ResourceSet)rsImpl);
        }
    }

    private void saveModel(Package model, ResourceSet rsImpl) {
        String modelFile = String.valueOf(this.destinationFolder) + this.outPath + model.getName() + "." + this.getUMLFileExtension();
        URI fileURI = URI.createFileURI((String)modelFile);
        Resource r = rsImpl.createResource(fileURI);
        r.getContents().add((Object)model);
        Iterator allContents = (Iterator)UML2Util.getAllContents((EObject)model, (boolean)true, (boolean)false);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof Element)) continue;
            r.getContents().addAll((Collection)((Element)eObject).getStereotypeApplications());
        }
        try {
            r.save(null);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
    }

    private String getUMLFileExtension() {
        return this.useUML1x ? "uml2" : "uml";
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

