/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CookieAction;

public final class CustomizeBeanAction
extends CookieAction {
    private static final String HELP_KEY_CUSTOMIZING = "beans.customizing";
    static final long serialVersionUID = -6378495195905487716L;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class array$Lorg$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    protected void performAction(Node[] activatedNodes) {
        if (CustomizeBeanAction.compileNodes(activatedNodes)) {
            CustomizeBeanAction.customize((InstanceCookie)activatedNodes[0].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = CustomizeBeanAction.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie));
        }
    }

    public static boolean compileNodes(Node[] nodes) {
        try {
            Class<?> c = ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CustomizeBeanAction.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass("org.openide.actions.AbstractCompileAction");
            Method m = c.getDeclaredMethod("compileNodes", array$Lorg$openide$nodes$Node == null ? (array$Lorg$openide$nodes$Node = CustomizeBeanAction.class$("[Lorg.openide.nodes.Node;")) : array$Lorg$openide$nodes$Node);
            return (Boolean)m.invoke(null, new Object[]{nodes});
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
            return false;
        }
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = CustomizeBeanAction.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie};
    }

    public String getName() {
        return NbBundle.getMessage(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction, "CustomizeBean");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction);
    }

    protected String resourceIcon() {
        return "/org/openide/resources/actions/customize.gif";
    }

    public static void customize(final InstanceCookie cookie) {
        if (cookie == null) {
            return;
        }
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction);
        Window w = null;
        Object b = null;
        try {
            b = cookie.instanceCreate();
        }
        catch (Exception ex) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)ex, bundle.getString("EXC_IntrospectionNoClass"));
            em.notify(16, ex);
            return;
        }
        final Object bean = b;
        if (bean instanceof Window) {
            w = (Window)bean;
            w.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    e.getWindow().dispose();
                }
            });
        } else if (bean instanceof Component) {
            DialogDescriptor dd = new DialogDescriptor((Component)bean, bundle.getString("CTL_Component_Title"), false, null);
            dd.setOptions(new Object[]{NotifyDescriptor.CLOSED_OPTION});
            dd.setHelpCtx(new HelpCtx(HELP_KEY_CUSTOMIZING));
            w = DialogDisplayer.getDefault().createDialog(dd);
        }
        final Window window = w;
        PropertySheet propertySheet = new PropertySheet();
        Node[] nodes = new Node[1];
        BeanNode bn = null;
        try {
            bn = new BeanNode(bean);
        }
        catch (IntrospectionException e) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)e, NbBundle.getMessage(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction, "EXC_Introspection", bean.getClass().getName()));
            em.notify(16, e);
            return;
        }
        nodes[0] = bn;
        propertySheet.setNodes(nodes);
        JButton ser = new JButton(bundle.getString("CTL_Serialize"));
        final JButton serAs = new JButton(bundle.getString("CTL_SerializeAs"));
        final JButton cancel = new JButton(bundle.getString("CTL_Cancel"));
        serAs.setMnemonic(bundle.getString("CTL_SerializeAs_Mnemonic").charAt(0));
        ser.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Serialize"));
        serAs.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SerializeAs"));
        cancel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Cancel"));
        propertySheet.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CustomizeBeanPanel"));
        final Dialog[] dialog = new Dialog[1];
        boolean brr = (class$java$io$Serializable == null ? (class$java$io$Serializable = CustomizeBeanAction.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(bean.getClass());
        serAs.setEnabled(brr);
        ser.setEnabled(brr && cookie instanceof InstanceCookie.Origin);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() == cancel || ev.getSource() == NotifyDescriptor.CANCEL_OPTION || ev.getSource() == NotifyDescriptor.CLOSED_OPTION) {
                    dialog[0].dispose();
                    if (window != null) {
                        window.dispose();
                    }
                    return;
                }
                if (CustomizeBeanAction.serializeJavaBean(bean, ev.getSource() == serAs ? null : ((InstanceCookie.Origin)cookie).instanceOrigin())) {
                    dialog[0].dispose();
                    if (window != null) {
                        window.dispose();
                    }
                }
            }
        };
        DialogDescriptor descr = new DialogDescriptor((Object)propertySheet, NbBundle.getMessage(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction, "FMT_CTL_CustomizeTitle", bean.getClass().getName()), false, new Object[]{ser, serAs, cancel}, (Object)cancel, 0, new HelpCtx(HELP_KEY_CUSTOMIZING), listener);
        dialog[0] = DialogDisplayer.getDefault().createDialog(descr);
        CustomizeWindowAdapter wa = new CustomizeWindowAdapter(window);
        dialog[0].addWindowListener(wa);
        dialog[0].show();
        CustomizeWindowAdapter customizeWindowAdapter = wa;
        synchronized (customizeWindowAdapter) {
            if (window != null && !wa.closedBeenWindow) {
                Rectangle r = dialog[0].getBounds();
                ((Component)window).setLocation(r.x + r.width, r.y);
                window.show();
                wa.closedBeenWindow = true;
            }
        }
    }

    public static boolean serializeJavaBean(final Object bean, FileObject file) {
        FileSystem targetFS;
        String name;
        FileObject parent;
        block7: {
            ResourceBundle bundle = NbBundle.getBundle(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction);
            parent = null;
            name = null;
            try {
                if (file == null) {
                    JPanel p = new JPanel(new BorderLayout(12, 0));
                    JTextField tf = new JTextField(20);
                    JLabel l = new JLabel(bundle.getString("CTL_SerializeTarget"));
                    l.setDisplayedMnemonic(bundle.getString("CTL_SerializeTarget_Mnemonic").charAt(0));
                    l.setLabelFor(tf);
                    p.add((Component)tf, "Center");
                    p.add((Component)l, "West");
                    tf.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SerializeTarget"));
                    try {
                        DataFolder df = (DataFolder)NodeOperation.getDefault().select(bundle.getString("CTL_SerializeAs"), bundle.getString("CTL_SaveIn"), RepositoryNodeFactory.getDefault().repository(new FolderFilter()), new FolderAcceptor(), p)[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = CustomizeBeanAction.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                        parent = df.getPrimaryFile();
                        targetFS = parent.getFileSystem();
                        name = tf.getText();
                        break block7;
                    }
                    catch (UserCancelException ex) {
                        return false;
                    }
                }
                parent = file.getParent();
                name = file.getName();
                targetFS = file.getFileSystem();
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().annotate((Throwable)e, bundle.getString("EXC_Serialization") + " " + name);
                ErrorManager.getDefault().notify(e);
                return false;
            }
        }
        final String fileName = name;
        final FileObject parentFile = parent;
        try {
            targetFS.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() throws IOException {
                    ByteArrayOutputStream baos = null;
                    ObjectOutputStream oos = null;
                    OutputStream os = null;
                    FileObject serFile = null;
                    FileLock lock = null;
                    try {
                        baos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(baos);
                        oos.writeObject(bean);
                        serFile = parentFile.getFileObject(fileName, "ser");
                        if (serFile == null) {
                            serFile = parentFile.createData(fileName, "ser");
                        }
                        lock = serFile.lock();
                        oos.close();
                        os = serFile.getOutputStream(lock);
                        baos.writeTo(os);
                        Object var7_6 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os == null) return;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os == null) throw throwable;
                        os.close();
                        throw throwable;
                    }
                    os.close();
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = CustomizeBeanAction.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction, "EXC_Serialization2", bean.getClass().getName()));
            ErrorManager.getDefault().notify(4096, e);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomizeWindowAdapter
    extends WindowAdapter {
        public boolean closedBeenWindow = false;
        private Window window;

        public CustomizeWindowAdapter(Window window) {
            this.window = window;
        }

        public void windowClosed(WindowEvent we) {
            CustomizeWindowAdapter customizeWindowAdapter = this;
            synchronized (customizeWindowAdapter) {
                if (this.window != null) {
                    this.window.dispose();
                    this.closedBeenWindow = true;
                }
            }
        }
    }

    private static final class FolderAcceptor
    implements NodeAcceptor {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        FolderAcceptor() {
        }

        public boolean acceptNodes(Node[] nodes) {
            if (nodes == null || nodes.length == 0) {
                return false;
            }
            DataFolder cookie = (DataFolder)nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = FolderAcceptor.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            return nodes.length == 1 && cookie != null && !cookie.getPrimaryFile().isReadOnly();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class FolderFilter
    implements DataFilter {
        static final long serialVersionUID = 6754682007992329276L;

        FolderFilter() {
        }

        public boolean acceptDataObject(DataObject obj) {
            return obj instanceof DataFolder && (!obj.getPrimaryFile().isReadOnly() || obj.getPrimaryFile().getParent() != null);
        }
    }
}

